/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.File;
import java.io.IOException;
import java.io.SyncFailedException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.ImportClass;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.JavaPackageClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.RenameFullNameElement;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MoveClassRefactoringPlugin
extends JavaRefactoringPlugin {
    private Map sourceObjectsMap;
    private Collection resources;
    private Collection otherDataObjects = Collections.EMPTY_LIST;
    private Map sourceClassesMap;
    private Collection allClasses;
    private boolean particularClassSelected;
    private Map accessesOriginalPackageMap;
    private Map accessedByOriginalPackageMap;
    private Map movingToDefaultPackageMap;
    private Map movingFromDefaultPackageMap;
    private FileObject folder = null;
    private MoveClassRefactoring refactoring;
    private ClassPath classPath;
    private Map checkedSourcesMap;
    private int size;
    private FileObject target;
    private boolean isPackageRename = false;
    private String newPackageName;
    private ArrayList createdFolderNames = new ArrayList();
    private ArrayList createdFolderNamesDuringUndo = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public MoveClassRefactoringPlugin(MoveClassRefactoring refactoring) {
        this.refactoring = refactoring;
        this.resources = refactoring.getResources();
        this.otherDataObjects = refactoring.getOtherDataObjects();
        this.classPath = RefactoringClassPathImplementation.getDefault();
        this.folder = refactoring.getSourceFolder();
    }

    private Problem init() {
        Resource r;
        this.sourceObjectsMap = new HashMap(this.resources.size());
        Problem prob = null;
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            r = (Resource)i.next();
            if (r.isValid()) {
                DataObject dob = JavaMetamodel.getManager().getDataObject(r);
                this.sourceObjectsMap.put(r, dob);
                if (!CheckUtils.isFromLibrary(r)) continue;
                prob = MoveClassRefactoringPlugin.createProblem(prob, true, MoveClassRefactoringPlugin.getCannotMove(dob.getPrimaryFile()));
                continue;
            }
            i.remove();
        }
        this.size = this.resources.size();
        this.accessesOriginalPackageMap = new HashMap(this.size);
        this.accessedByOriginalPackageMap = new HashMap(this.size);
        this.movingToDefaultPackageMap = new HashMap(this.size);
        this.movingFromDefaultPackageMap = new HashMap(this.size);
        this.sourceClassesMap = new HashMap(this.size * 2);
        this.checkedSourcesMap = new HashMap(this.size);
        this.allClasses = new ArrayList(10);
        i = this.resources.iterator();
        while (i.hasNext()) {
            r = (Resource)i.next();
            LinkedList list = new LinkedList();
            list.addAll(r.getClassifiers());
            this.sourceClassesMap.put(r, list.toArray(new JavaClass[list.size()]));
            this.checkedSourcesMap.put(r, new HashSet());
        }
        i = this.refactoring.getSelectedDataObjects().iterator();
        while (i.hasNext()) {
            DataObject dob = (DataObject)i.next();
            if (!(dob instanceof DataFolder)) continue;
            this.putSubfolders(dob.getPrimaryFile());
        }
        return prob;
    }

    private static final String getCannotMove(FileObject f) {
        ClassPath cp = ClassPath.getClassPath((FileObject)f, (String)"classpath/source");
        if (cp == null) {
            cp = ClassPath.getClassPath((FileObject)f, (String)"classpath/boot");
        }
        String name = cp.getResourceName(f);
        return new MessageFormat(NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_CannotMoveFile")).format(new Object[]{name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        Resource r;
        JavaClass[] sourceClasses;
        Problem prob = this.init();
        if (prob != null) {
            return prob;
        }
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            Resource res = (Resource)i.next();
            if (!CheckUtils.isElementInOpenProject((Element)res)) {
                return new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
            }
            sourceClasses = (JavaClass[])this.sourceClassesMap.get(res);
            for (int x = 0; x < sourceClasses.length; ++x) {
                this.collectAllClasses(this.allClasses, sourceClasses[x]);
            }
        }
        this.fireProgressListenerStart(1, 3 * this.size + 3);
        i = this.resources.iterator();
        while (i.hasNext()) {
            if (this.cancelRequest) {
                return null;
            }
            r = (Resource)i.next();
            this.accessedByOriginalPackageMap.put(r, this.isAccessedByOriginalPackage(r));
            JavaPackage sourcePackage = (JavaPackage)r.refImmediateComposite();
            this.movingFromDefaultPackageMap.put(r, "".equals(sourcePackage.getName()));
            this.accessesOriginalPackageMap.put(r, Boolean.FALSE);
        }
        try {
            i = this.resources.iterator();
            while (i.hasNext()) {
                r = (Resource)i.next();
                sourceClasses = (JavaClass[])this.sourceClassesMap.get(r);
                this.fireProgressListenerStep();
                if (sourceClasses.length > 1 && this.particularClassSelected) {
                    Problem x = new Problem(true, MoveClassRefactoringPlugin.getString("ERR_SourceWithMoreClasses"));
                    return x;
                }
                this.fireProgressListenerStep();
            }
            Problem problem = this.checkUsedElements(null);
            boolean defaultPackageWarned = false;
            Iterator i2 = this.resources.iterator();
            while (i2.hasNext()) {
                Resource r2 = (Resource)i2.next();
                this.fireProgressListenerStep();
                Boolean boolVal = (Boolean)this.accessesOriginalPackageMap.get(r2);
                boolean accessesOriginalPackage = boolVal != null ? boolVal : false;
                boolean movingFromDefaultPackage = (Boolean)this.movingFromDefaultPackageMap.get(r2);
                if (!accessesOriginalPackage || !movingFromDefaultPackage || defaultPackageWarned) continue;
                Problem p = new Problem(false, MoveClassRefactoringPlugin.getString("ERR_ClassToMoveInDefaultPackage"));
                p.setNext(problem);
                problem = p;
                defaultPackageWarned = true;
            }
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            problem = this.checkAccessesMyFeature(problem);
            this.fireProgressListenerStep();
            Problem problem2 = problem;
            return problem2;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        return this.checkParameters(this.refactoring.getTargetClassPathRoot(), this.refactoring.getTargetPackageName());
    }

    public Problem checkParameters() {
        return this.setParameters(this.refactoring.getTargetClassPathRoot(), this.refactoring.getTargetPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag elements) {
        Object problem = null;
        this.fireProgressListenerStart(3, 2 + 2 * this.resources.size());
        try {
            this.fireProgressListenerStep();
            Object thisCP = null;
            Object targetRoot = null;
            this.checkWhereUsed(elements);
            this.fireProgressListenerStep();
            Iterator i = this.resources.iterator();
            while (i.hasNext()) {
                if (this.cancelRequest) {
                    Problem problem2 = null;
                    return problem2;
                }
                Resource resource = (Resource)i.next();
                JavaPackage sourcePackage = (JavaPackage)resource.refImmediateComposite();
                Boolean boolVal = (Boolean)this.accessesOriginalPackageMap.get(resource);
                boolean accessesOriginalPackage = boolVal != null ? boolVal : false;
                boolean movingFromDefaultPackage = (Boolean)this.movingFromDefaultPackageMap.get(resource);
                if (accessesOriginalPackage && !movingFromDefaultPackage && !this.containsImport(resource, sourcePackage.getName())) {
                    elements.add(this.refactoring, new InsertImport(resource, sourcePackage.getName(), false));
                }
                this.fireProgressListenerStep();
                DataObject sourceObject = (DataObject)this.sourceObjectsMap.get(resource);
                elements.add(this.refactoring, new MoveClass(sourceObject, this.refactoring.getTargetClassPathRoot(), this.refactoring.getTargetPackageName(resource), (JavaClass[])this.sourceClassesMap.get(resource)));
                this.fireProgressListenerStep();
            }
            this.removeUnusedImports(elements);
            i = this.otherDataObjects.iterator();
            while (i.hasNext()) {
                DataObject dob = (DataObject)i.next();
                elements.add(this.refactoring, new MoveClass(dob, this.refactoring.getTargetClassPathRoot(), this.refactoring.getTargetPackageName(dob.getPrimaryFile()), null));
            }
            Problem problem3 = null;
            return problem3;
        }
        finally {
            this.referencesIterator = null;
            this.fireProgressListenerStop();
        }
    }

    private Collection getOldPackages() {
        HashSet<RefFeatured> set = new HashSet<RefFeatured>(3);
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            set.add(r.refImmediateComposite());
        }
        return set;
    }

    private Collection getEmptyPackages() {
        HashSet<JavaPackage> packages = new HashSet<JavaPackage>(3);
        Iterator i = this.getOldPackages().iterator();
        while (i.hasNext()) {
            JavaPackage pack = (JavaPackage)i.next();
            HashSet packResources = new HashSet(pack.getResources());
            packResources.removeAll(this.resources);
            packResources.remove(null);
            if (!packResources.isEmpty()) continue;
            packages.add(pack);
        }
        return packages;
    }

    private void removeUnusedImports(RefactoringElementsBag elements) {
        Iterator iter = this.getEmptyPackages().iterator();
        while (iter.hasNext()) {
            JavaPackage oldPackage = (JavaPackage)iter.next();
            Resource[] referenced = MoveClassRefactoringPlugin.findReferencedResources(oldPackage.getName());
            for (int i = 0; i < referenced.length; ++i) {
                List imports = referenced[i].getImports();
                Iterator it = imports.iterator();
                while (it.hasNext()) {
                    Import imp = (Import)it.next();
                    NamedElement el = imp.getImportedNamespace();
                    if (!oldPackage.equals(el)) continue;
                    elements.add(this.refactoring, new RemoveImport(imp));
                }
            }
        }
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            String targetPkgName = this.refactoring.getTargetPackageName(r);
            Iterator importsIterator = r.getImports().iterator();
            while (importsIterator.hasNext()) {
                Import imp = (Import)importsIterator.next();
                NamedElement ne = imp.getImportedNamespace();
                if (ne instanceof UnresolvedClass) continue;
                if (ne instanceof JavaClass) {
                    ne = (NamedElement)ne.getResource().refImmediateComposite();
                }
                if (!(ne instanceof JavaPackage) || !ne.getName().equals(targetPkgName)) continue;
                elements.add(this.refactoring, new RemoveImport(imp));
            }
        }
    }

    private static Resource[] findReferencedResources(String packageName) {
        if ("".equals(packageName)) {
            return new Resource[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        String part = tokenizer.nextToken();
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList((Object[])ClassIndex.findResourcesForIdentifier((String)part)));
        while (tokenizer.hasMoreTokens()) {
            part = tokenizer.nextToken();
            result.retainAll(Arrays.asList((Object[])ClassIndex.findResourcesForIdentifier((String)part)));
        }
        return result.toArray(new Resource[result.size()]);
    }

    private static String getPackageName(ClassPath cp, FileObject f) {
        return cp.getResourceName(f, '.', false);
    }

    private boolean isFullName(MultipartId id) {
        while (id != null) {
            if (id.getElement() instanceof JavaPackage) {
                return true;
            }
            id = id.getParent();
        }
        return false;
    }

    private Problem checkUsedElements(Problem problem) {
        Iterator iter = this.allClasses.iterator();
        while (iter.hasNext()) {
            if (this.cancelRequest) {
                return null;
            }
            JavaClass jc = (JavaClass)iter.next();
            problem = this.checkUsedElements((Element)jc, new HashSet(), problem);
        }
        return problem;
    }

    private Problem checkUsedElements(Element elem, Set markedResources, Problem problem) {
        List elements = elem.getChildren();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (this.cancelRequest) {
                return null;
            }
            Object el = iter.next();
            if (el instanceof JavaClass || el instanceof Feature && !(elem instanceof Feature)) continue;
            if (el instanceof ElementReference) {
                Feature f;
                Resource res;
                NamedElement namedElem = ((ElementReference)el).getElement();
                while (namedElem instanceof Array) {
                    namedElem = ((Array)namedElem).getType();
                }
                if (namedElem instanceof Feature && (res = (f = (Feature)namedElem).getResource()) != null && !this.resources.contains(res) && !markedResources.contains(res)) {
                    JavaPackage pkg = (JavaPackage)res.refImmediateComposite();
                    boolean accessesOriginalPackage = false;
                    Iterator i = this.resources.iterator();
                    while (i.hasNext()) {
                        Resource resource = (Resource)i.next();
                        JavaPackage sourcePackage = (JavaPackage)resource.refImmediateComposite();
                        if (sourcePackage != pkg) continue;
                        this.accessesOriginalPackageMap.put(resource, Boolean.TRUE);
                        accessesOriginalPackage = true;
                    }
                    int modifiers = f.getModifiers();
                    if (!(f instanceof Initializer || (modifiers & 1) != 0 || (modifiers & 2) != 0 || Modifier.isProtected(modifiers) && (this.getEnclosingClass((Element)el).isSubTypeOf((ClassDefinition)((JavaClass)f.getDeclaringClass())) || !Modifier.isProtected(modifiers) || this.allClasses.contains(this.getEnclosingClass((Element)f))))) {
                        String modStr;
                        markedResources.add(res);
                        String string = modStr = (modifiers & 4) != 0 ? MoveClassRefactoringPlugin.getString("LBL_Protected") : MoveClassRefactoringPlugin.getString("LBL_PackagePrivate");
                        Problem p = f instanceof JavaClass ? new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateClass2")).format(new Object[]{this.getEnclosingClass((Element)el).getSimpleName(), modStr, ((JavaClass)f).getSimpleName()})) : (f instanceof Constructor ? new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateConstructor2")).format(new Object[]{this.getEnclosingClass((Element)el).getSimpleName(), modStr, ((JavaClass)f.getDeclaringClass()).getSimpleName()})) : new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateFeature2")).format(new Object[]{this.getEnclosingClass((Element)el).getSimpleName(), modStr, this.getFeatureKindName(f), f.getName(), ((JavaClass)f.getDeclaringClass()).getSimpleName()})));
                        p.setNext(problem);
                        problem = p;
                    }
                }
            }
            if (el instanceof TypeReference) continue;
            problem = this.checkUsedElements((Element)el, markedResources, problem);
        }
        return problem;
    }

    private void checkWhereUsed(RefactoringElementsBag elements) {
        Iterator i = this.resources.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            if (this.refactoring.getTargetPackageName(resource).equals(((JavaPackage)resource.refImmediateComposite()).getName())) continue;
            JavaClass[] sourceClasses = (JavaClass[])this.sourceClassesMap.get(resource);
            for (int x = 0; x < sourceClasses.length; ++x) {
                this.checkWhereUsed(elements, sourceClasses[x], resource);
            }
        }
    }

    private Element getImport(Element e) {
        Element orig = e;
        while (e instanceof MultipartId) {
            e = (Element)e.refImmediateComposite();
        }
        if (e instanceof Import) {
            return e;
        }
        return orig;
    }

    private void checkWhereUsed(RefactoringElementsBag elements, JavaClass jc, Resource r) {
        String targetPkgName = this.refactoring.getTargetPackageName(r);
        JavaPackage targetPackage = ((JavaModelPackage)jc.refImmediatePackage()).getJavaPackage().resolvePackage(targetPkgName);
        Collection users = jc.getReferences();
        boolean movingToDefaultPackage = (Boolean)this.movingToDefaultPackageMap.get(r);
        this.referencesIterator = users.iterator();
        while (this.referencesIterator.hasNext()) {
            MultipartId id;
            if (this.cancelRequest) {
                return;
            }
            Element elem = this.getImport((Element)this.referencesIterator.next());
            if (elem instanceof MultipartId) {
                if (this.isFullName((MultipartId)elem)) {
                    elements.add(this.refactoring, new RenameFullNameElement(jc, (MultipartId)elem, targetPkgName));
                    continue;
                }
                Resource res = elem.getResource();
                JavaPackage resPkg = (JavaPackage)res.refImmediateComposite();
                Set checkedSources = (Set)this.checkedSourcesMap.get(r);
                if (movingToDefaultPackage || this.resources.contains(res) || checkedSources.contains(res)) continue;
                checkedSources.add(res);
                if (resPkg == targetPackage || this.containsImport(res, jc.getName())) continue;
                elements.add(this.refactoring, new InsertImport(res, targetPkgName + '.' + jc.getSimpleName(), true));
                continue;
            }
            if (!(elem instanceof Import)) continue;
            if (movingToDefaultPackage) {
                elements.add(this.refactoring, new RemoveImport((Import)elem));
                continue;
            }
            for (id = ((Import)elem).getIdentifier(); id != null && !jc.equals(id.getElement()); id = id.getParent()) {
            }
            if (!$assertionsDisabled && id == null) {
                throw new AssertionError((Object)("id is null, resource = " + elem.getResource().getName() + " jc = " + jc));
            }
            elements.add(this.refactoring, new RenameFullNameElement(jc, id, targetPkgName));
        }
    }

    private JavaClass getEnclosingClass(Element elem) {
        while (elem != null && !(elem instanceof JavaClass)) {
            elem = (Element)elem.refImmediateComposite();
        }
        return (JavaClass)elem;
    }

    private boolean containsImport(Resource res, JavaClass jc) {
        JavaPackage pkg = (JavaPackage)jc.getResource().refImmediateComposite();
        Iterator iter = res.getImports().iterator();
        while (iter.hasNext()) {
            Import imp = (Import)iter.next();
            NamedElement elem = imp.getImportedNamespace();
            if (elem != jc && elem != pkg) continue;
            return true;
        }
        return false;
    }

    private boolean containsImport(Resource res, String impName) {
        Iterator iter = res.getImports().iterator();
        while (iter.hasNext()) {
            Import imp = (Import)iter.next();
            if (!impName.equals(imp.getName())) continue;
            return true;
        }
        return false;
    }

    private Problem checkAccessesMyFeature(Problem problem) {
        Iterator iter = this.allClasses.iterator();
        while (iter.hasNext()) {
            if (this.cancelRequest) {
                return null;
            }
            JavaClass jc = (JavaClass)iter.next();
            problem = this.checkAccessesMyFeature(problem, jc);
        }
        return problem;
    }

    private Problem checkAccessesMyFeature(Problem problem, JavaClass jc) {
        boolean classChecked = false;
        HashSet<Resource> set = new HashSet<Resource>();
        Iterator iter = jc.getFeatures().iterator();
        while (iter.hasNext() || !classChecked) {
            JavaClass f;
            if (!classChecked) {
                f = jc;
                classChecked = true;
            } else {
                f = (Feature)iter.next();
                if (f instanceof JavaClass) continue;
            }
            int modifiers = f.getModifiers();
            if (f instanceof Initializer || (modifiers & 1) != 0 || (modifiers & 2) != 0) continue;
            boolean isProtected = (modifiers & 4) != 0;
            Collection users = f.getReferences();
            this.referencesIterator = users.iterator();
            while (this.referencesIterator.hasNext()) {
                String modStr;
                if (this.cancelRequest) {
                    return null;
                }
                Element elem = (Element)this.referencesIterator.next();
                Resource res = elem.getResource();
                String string = modStr = (modifiers & 4) != 0 ? MoveClassRefactoringPlugin.getString("LBL_Protected") : MoveClassRefactoringPlugin.getString("LBL_PackagePrivate");
                if (this.resources.contains(res) || !set.add(res)) continue;
                JavaPackage pkg = (JavaPackage)res.refImmediateComposite();
                boolean cont = false;
                Iterator i = this.resources.iterator();
                while (i.hasNext()) {
                    JavaPackage sourcePackage = (JavaPackage)((Resource)i.next()).refImmediateComposite();
                    if (pkg == sourcePackage) continue;
                    cont = true;
                }
                if (cont || this.getEnclosingClass(elem).isSubTypeOf((ClassDefinition)jc)) continue;
                Problem p = f instanceof JavaClass ? new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateClass")).format(new Object[]{this.getEnclosingClass(elem).getSimpleName(), modStr, f.getSimpleName()})) : (f instanceof Constructor ? new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateConstructor")).format(new Object[]{this.getEnclosingClass(elem).getSimpleName(), modStr, ((JavaClass)f.getDeclaringClass()).getSimpleName()})) : new Problem(false, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_AccessesPackagePrivateFeature")).format(new Object[]{this.getEnclosingClass(elem).getSimpleName(), modStr, this.getFeatureKindName((Feature)f), f.getName(), ((JavaClass)f.getDeclaringClass()).getSimpleName()})));
                p.setNext(problem);
                problem = p;
            }
        }
        return problem;
    }

    private boolean isAccessedByOriginalPackage(Resource r) {
        JavaClass[] sourceClasses = (JavaClass[])this.sourceClassesMap.get(r);
        JavaPackage sourcePackage = (JavaPackage)r.refImmediateComposite();
        for (int x = 0; x < sourceClasses.length; ++x) {
            this.referencesIterator = sourceClasses[x].getReferences().iterator();
            while (this.referencesIterator.hasNext()) {
                if (this.cancelRequest) {
                    return false;
                }
                Element elem = (Element)this.referencesIterator.next();
                Resource res = elem.getResource();
                JavaPackage pkg = (JavaPackage)res.refImmediateComposite();
                if (this.resources.contains(res)) continue;
                return true;
            }
        }
        return false;
    }

    private String getFeatureKindName(Feature f) {
        String featureKind = f instanceof Method ? MoveClassRefactoringPlugin.getString("LBL_Method") : (f instanceof Field ? MoveClassRefactoringPlugin.getString("LBL_Field") : (f instanceof Constructor ? MoveClassRefactoringPlugin.getString("LBL_Constructor") : (f instanceof JavaClass ? MoveClassRefactoringPlugin.getString("LBL_Class") : "???")));
        return featureKind;
    }

    private void collectAllClasses(Collection classes, JavaClass jc) {
        classes.add(jc);
        Iterator iter = jc.getFeatures().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof JavaClass)) continue;
            this.collectAllClasses(classes, (JavaClass)obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem setParameters(FileObject target, String newPackageName) {
        this.newPackageName = newPackageName;
        Problem p = null;
        this.target = target;
        this.fireProgressListenerStart(2, 1 + this.resources.size());
        try {
            Iterator i = this.resources.iterator();
            while (i.hasNext()) {
                Resource r = (Resource)i.next();
                FileObject targetRoot = this.refactoring.getTargetClassPathRoot();
                String targetPackageName = this.refactoring.getTargetPackageName(r);
                FileObject targetF = targetRoot.getFileObject(targetPackageName.replace('.', '/'));
                String pkgName = null;
                if (targetF != null && !targetF.canWrite()) {
                    Problem problem = new Problem(true, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_PackageIsReadOnly")).format(new Object[]{targetPackageName}));
                    return problem;
                }
                this.movingToDefaultPackageMap.put(r, targetF != null && targetF.equals(this.classPath.findOwnerRoot(targetF)));
                pkgName = targetPackageName;
                if (pkgName == null) {
                    pkgName = "";
                } else if (pkgName.length() > 0) {
                    pkgName = pkgName + '.';
                }
                this.fireProgressListenerStep();
                JavaClass[] sourceClasses = (JavaClass[])this.sourceClassesMap.get(r);
                String[] names = new String[sourceClasses.length];
                for (int x = 0; x < names.length; ++x) {
                    names[x] = sourceClasses[x].getName();
                }
                FileObject movedFile = JavaMetamodel.getManager().getDataObject(r).getPrimaryFile();
                String fileName = movedFile.getName();
                if (targetF != null) {
                    FileObject[] children = targetF.getChildren();
                    for (int x = 0; x < children.length; ++x) {
                        if (!children[x].getName().equals(fileName) || !"java".equals(children[x].getExt()) || children[x].equals(movedFile) || children[x].isVirtual()) continue;
                        Problem problem = new Problem(true, new MessageFormat(MoveClassRefactoringPlugin.getString("ERR_ClassToMoveClashes")).format(new Object[]{fileName}));
                        return problem;
                    }
                }
                boolean accessedByOriginalPackage = (Boolean)this.accessedByOriginalPackageMap.get(r);
                boolean movingToDefaultPackage = (Boolean)this.movingToDefaultPackageMap.get(r);
                if (p == null && accessedByOriginalPackage && movingToDefaultPackage) {
                    p = new Problem(false, MoveClassRefactoringPlugin.getString("ERR_MovingClassToDefaultPackage"));
                }
                if (!((DataObject)this.sourceObjectsMap.get(r)).getFolder().getPrimaryFile().equals(targetF) || !this.isPackageCorrect(r)) continue;
                Problem problem = new Problem(true, MoveClassRefactoringPlugin.getString("ERR_CannotMoveIntoSamePackage"));
                return problem;
            }
            this.fireProgressListenerStep();
        }
        finally {
            this.fireProgressListenerStop();
        }
        return p;
    }

    private boolean isPackageCorrect(Resource r) {
        String resourceName = r.getName();
        int index = resourceName.lastIndexOf(47);
        String estimatedPackageName = index == -1 ? "" : resourceName.substring(0, index);
        return estimatedPackageName.replace('/', '.').equals(r.getPackageName());
    }

    private Problem checkParameters(FileObject targetClassPathRoot, String newName) {
        if (!MoveClassRefactoringPlugin.isValidPackageName(newName)) {
            String s = MoveClassRefactoringPlugin.getString("ERR_InvalidPackage");
            String msg = new MessageFormat(s).format(new Object[]{newName});
            return new Problem(true, msg);
        }
        return null;
    }

    private static boolean isValidPackageName(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith(".") || name.endsWith(".")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        while (tokenizer.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    static final JavaPackage findJavaPackage(ClassPath cp, FileObject file) {
        FileObject root = cp.findOwnerRoot(file);
        JavaModelPackage jmp = JavaModel.getJavaExtent((FileObject)root);
        JavaPackageClass proxy = jmp.getJavaPackage();
        return proxy.resolvePackage(MoveClassRefactoringPlugin.getPackageName(cp, file));
    }

    static final String getString(String key) {
        return NbBundle.getMessage((Class)MoveClassRefactoring.class, (String)key);
    }

    private FileObject createFolder(FileObject folder, String name, boolean isUndo) throws IOException {
        String separators = File.separatorChar != '/' ? "/" + File.separatorChar : "/";
        StringTokenizer st = new StringTokenizer(name, separators);
        while (st.hasMoreElements()) {
            FileObject f;
            block6: {
                name = st.nextToken();
                if (name.length() <= 0) continue;
                f = folder.getFileObject(name);
                if (f == null) {
                    try {
                        f = folder.createFolder(name);
                        if (isUndo) {
                            this.createdFolderNames.add(f.getURL());
                        } else {
                            this.createdFolderNamesDuringUndo.add(f.getURL());
                        }
                    }
                    catch (SyncFailedException ex) {
                        folder.refresh();
                        f = folder.getFileObject(name);
                        if (f != null) break block6;
                        throw ex;
                    }
                }
            }
            folder = f;
        }
        return folder;
    }

    private void putSubfolders(FileObject fo) {
        if (".svn".equalsIgnoreCase(fo.getNameExt()) || "_svn".equalsIgnoreCase(fo.getNameExt())) {
            return;
        }
        try {
            this.createdFolderNames.add(fo.getURL());
        }
        catch (FileStateInvalidException fsi) {
            ErrorManager.getDefault().notify((Throwable)fsi);
        }
        FileObject[] children = fo.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].isFolder()) continue;
            this.putSubfolders(children[i]);
        }
    }

    static {
        $assertionsDisabled = !MoveClassRefactoringPlugin.class.desiredAssertionStatus();
    }

    static class RemoveImport
    extends SimpleRefactoringElementImpl {
        private Import imp;
        private Resource res;
        private PositionBounds bounds = null;

        public RemoveImport(Import imp) {
            this.imp = imp;
            this.res = (Resource)imp.refImmediateComposite();
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return new MessageFormat(MoveClassRefactoringPlugin.getString("LBL_RemoveImport")).format(new Object[]{this.imp.getName()});
        }

        public void performChange() {
            this.res.getImports().remove(this.imp);
        }

        public Element getJavaElement() {
            return this.res;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.res);
            }
            return this.bounds;
        }

        public FileObject getParentFile() {
            return null;
        }
    }

    static class InsertImport
    extends SimpleRefactoringElementImpl {
        protected ImportClass proxy;
        protected Resource source;
        protected String newName;
        protected boolean isNamed;
        private PositionBounds bounds = null;
        protected Import addedImport = null;

        public InsertImport(Resource source, String newName, boolean isNamed) {
            this.source = source;
            this.newName = newName;
            this.isNamed = isNamed;
            this.proxy = ((JavaModelPackage)source.refOutermostPackage()).getImport();
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return new MessageFormat(MoveClassRefactoringPlugin.getString("LBL_InsertImport")).format(new Object[]{this.newName});
        }

        public void performChange() {
            this.addedImport = this.proxy.createImport(this.newName, null, false, !this.isNamed);
            this.source.addImport(this.addedImport);
        }

        public Element getJavaElement() {
            return this.source;
        }

        public PositionBounds getPosition() {
            if (this.bounds == null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)this.source);
            }
            return this.bounds;
        }

        public FileObject getParentFile() {
            return null;
        }
    }

    class MoveClass
    extends SimpleRefactoringElementImpl
    implements RefactoringElementImplementation,
    ExternalChange {
        private DataObject source;
        private FileObject target;
        private FileObject oldTarget = null;
        private JavaClass[] sourceClasses;
        private PositionBounds bounds = null;
        private DataObject copiedObject = null;
        private FileObject targetRoot = null;
        private String packageName = null;

        public MoveClass(DataObject source, FileObject target, JavaClass[] sourceClasses) {
            this.source = source;
            this.target = target;
            this.sourceClasses = sourceClasses;
        }

        public MoveClass(DataObject source, FileObject targetRoot, String packageName, JavaClass[] sourceClasses) {
            this.source = source;
            this.targetRoot = targetRoot;
            this.sourceClasses = sourceClasses;
            this.packageName = packageName;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            String name = this.target == null ? this.packageName : MoveClassRefactoringPlugin.getPackageName(MoveClassRefactoringPlugin.this.classPath, this.target);
            if ("".equals(name)) {
                name = MoveClassRefactoringPlugin.getString("LBL_DefaultPackage");
            }
            if (this.sourceClasses == null) {
                return new MessageFormat(MoveClassRefactoringPlugin.getString("LBL_MoveObject")).format(new Object[]{this.source.getNodeDelegate().getDisplayName(), name});
            }
            return new MessageFormat(MoveClassRefactoringPlugin.getString("LBL_MoveClass")).format(new Object[]{name});
        }

        public Element getJavaElement() {
            if (this.sourceClasses == null || this.sourceClasses.length == 0) {
                return null;
            }
            return (Element)this.sourceClasses[0].refImmediateComposite();
        }

        public PositionBounds getPosition() {
            Resource res;
            if (this.sourceClasses == null || this.sourceClasses.length == 0) {
                return null;
            }
            if (this.bounds == null && this.sourceClasses[0].isValid() && (res = this.sourceClasses[0].getResource()) != null) {
                this.bounds = JavaMetamodel.getManager().getElementPosition((Element)res.getPackageIdentifier());
            }
            return this.bounds;
        }

        public void performChange() {
            String name;
            String string = name = this.target == null ? this.packageName : MoveClassRefactoringPlugin.getPackageName(MoveClassRefactoringPlugin.this.classPath, this.target);
            if (this.sourceClasses != null) {
                JavaModel.getResource((FileObject)this.source.getPrimaryFile()).setPackageName(name);
            }
            if (this.target == null || !this.target.equals(this.source.getPrimaryFile().getParent())) {
                JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
            }
        }

        private void doMove(final boolean isUndo) {
            try {
                this.source.getPrimaryFile().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        if (MoveClass.this.target == null) {
                            MoveClass.this.target = MoveClassRefactoringPlugin.this.createFolder(MoveClass.this.targetRoot, MoveClass.this.packageName.replace('.', '/'), isUndo);
                        } else if (!MoveClass.this.target.isValid()) {
                            MoveClass.this.target = MoveClassRefactoringPlugin.this.createFolder(MoveClass.this.target.getFileSystem().getRoot(), MoveClass.this.target.getPath(), isUndo);
                        }
                        DataFolder folder = DataFolder.findFolder((FileObject)MoveClass.this.target);
                        DataFolder sourceFolder = DataFolder.findFolder((FileObject)MoveClass.this.source.getPrimaryFile().getParent());
                        MoveClass.this.oldTarget = MoveClass.this.source.getPrimaryFile().getParent();
                        MoveClass.this.source.move(folder);
                        ArrayList col = isUndo ? MoveClassRefactoringPlugin.this.createdFolderNamesDuringUndo : MoveClassRefactoringPlugin.this.createdFolderNames;
                        for (int i = col.size() - 1; i >= 0; --i) {
                            URL name = (URL)col.get(i);
                            FileObject fileToRemove = URLMapper.findFileObject((URL)name);
                            if (fileToRemove == null || !fileToRemove.isValid() || fileToRemove.getChildren().length != 0) continue;
                            fileToRemove.delete();
                            col.remove(i);
                        }
                    }
                });
                JavaMetamodel.getManager().addModified(this.source.getPrimaryFile());
            }
            catch (IOException e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }

        private boolean canDelete(DataFolder df) {
            FileObject fo = df.getPrimaryFile();
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            if (cp == null) {
                return false;
            }
            return !fo.equals(cp.findOwnerRoot(fo));
        }

        public void performExternalChange() {
            this.doMove(false);
        }

        public void undoExternalChange() {
            if (this.oldTarget == null) {
                return;
            }
            FileObject temp = this.target;
            this.target = this.oldTarget;
            this.oldTarget = temp;
            this.doMove(true);
            this.target = temp;
        }

        public FileObject getParentFile() {
            return this.source.getPrimaryFile();
        }
    }
}

