/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.ElementPartKindEnum;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Invocation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.jmi.javamodel.TypeCast;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class WhereUsedElement
extends SimpleRefactoringElementImpl {
    private final String text;
    private final String displayText;
    private final ElementPartKind displayPart;
    protected final RefObject jmiObject;
    protected final Element feature;
    protected final ElementPartKind changePart;
    private RefObject comp = null;
    private PositionBounds bounds = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WhereUsedElement(RefObject jmiObject, Element feature) {
        int endOffset;
        int startOffset;
        if (!$assertionsDisabled && feature == null) {
            throw new AssertionError(jmiObject);
        }
        Resource r = feature.getResource();
        if (!$assertionsDisabled && r == null) {
            throw new AssertionError(feature);
        }
        String sourceText = r.getSourceText();
        this.feature = feature;
        this.jmiObject = jmiObject;
        StringBuffer displayText = new StringBuffer();
        Element displayElement = this.getDisplayElement();
        if (displayElement instanceof CallableFeature || displayElement instanceof JavaClass && !(displayElement instanceof TypeParameter) || displayElement instanceof Resource) {
            startOffset = displayElement.getPartStartOffset((ElementPartKind)ElementPartKindEnum.HEADER);
            endOffset = displayElement.getPartEndOffset((ElementPartKind)ElementPartKindEnum.HEADER);
        } else {
            int so = sourceText.lastIndexOf(10, feature.getStartOffset());
            int eo = sourceText.indexOf(10, feature.getEndOffset());
            startOffset = so == -1 ? 0 : so;
            endOffset = eo == -1 ? sourceText.length() : eo;
        }
        int offset = startOffset;
        if (feature instanceof Feature) {
            if (feature instanceof CallableFeature) {
                this.displayPart = ElementPartKindEnum.HEADER;
                this.changePart = null;
                offset = this.appendText(displayText, sourceText, feature, (ElementPartKind)ElementPartKindEnum.NAME, offset);
            } else if (feature instanceof JavaClass) {
                this.displayPart = ElementPartKindEnum.HEADER;
                JavaClass jc = (JavaClass)feature;
                this.changePart = null;
            } else if (feature instanceof Field) {
                this.displayPart = null;
                this.changePart = null;
                offset = this.appendText(displayText, sourceText, feature, this.changePart, offset);
            } else {
                if (!(feature instanceof Resource)) throw new RuntimeException("Unknown type of object: " + feature.getClass().getName());
                this.displayPart = ElementPartKindEnum.HEADER;
                this.changePart = null;
            }
        } else {
            if (feature instanceof Invocation) {
                this.changePart = ElementPartKindEnum.NAME;
            } else if (feature instanceof Variable || feature instanceof TypeCast || feature instanceof ElementReference) {
                this.changePart = null;
            } else if (feature instanceof Import) {
                this.changePart = ElementPartKindEnum.NAME;
            } else {
                if (!(feature instanceof Resource)) throw new RuntimeException("Unknown type of object: " + feature.getClass().getName());
                this.changePart = ElementPartKindEnum.HEADER;
            }
            this.displayPart = this.changePart;
            offset = this.appendText(displayText, sourceText, feature, this.changePart, offset);
        }
        displayText.append(CheckUtils.htmlize(sourceText.substring(offset, endOffset)));
        this.displayText = this.normalize(displayText.toString().trim());
        this.text = this.normalize(sourceText.substring(startOffset, endOffset));
        this.getPosition();
    }

    private Element getDisplayElement() {
        if (this.feature instanceof Resource) {
            return this.feature;
        }
        if (this.feature instanceof Import) {
            return this.feature;
        }
        Element result = this.feature;
        while (!(result instanceof ClassMember || result instanceof Resource || result instanceof Import || result.refImmediateComposite() instanceof StatementBlock)) {
            result = (Element)result.refImmediateComposite();
        }
        return result;
    }

    private String normalize(String text) {
        StringBuffer result = new StringBuffer(text.length());
        boolean whitespaces = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (whitespaces) continue;
                whitespaces = true;
                result.append(' ');
                continue;
            }
            result.append(ch);
            whitespaces = false;
        }
        return result.toString();
    }

    private int appendText(StringBuffer result, String sourceText, Element feature, ElementPartKind part, int startOffset) {
        int offset = part != null ? feature.getPartStartOffset(part) : feature.getStartOffset();
        result.append(CheckUtils.htmlize(sourceText.substring(startOffset, offset)));
        result.append("<b>");
        startOffset = offset;
        offset = part != null ? feature.getPartEndOffset(part) : feature.getEndOffset();
        result.append(CheckUtils.htmlize(sourceText.substring(startOffset, offset)));
        result.append("</b>");
        return offset;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Element getJavaElement() {
        if (this.comp == null) {
            this.comp = this.feature;
            while (!(this.comp instanceof Feature) && !(this.comp instanceof Resource)) {
                this.comp = (RefObject)this.comp.refImmediateComposite();
            }
        }
        return (Element)this.comp;
    }

    public PositionBounds getPosition() {
        if (this.bounds == null) {
            this.bounds = this.displayPart == null ? JavaMetamodel.getManager().getElementPosition(this.feature) : JavaMetamodel.getManager().getElementPartPosition(this.feature, this.displayPart, 0);
        }
        return this.bounds;
    }

    public String getText() {
        return this.text;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return null;
    }

    static {
        $assertionsDisabled = !WhereUsedElement.class.desiredAssertionStatus();
    }
}

