/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class LocalsTreeModel
implements TreeModel,
PropertyChangeListener {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(108) >= 0;
    private static final int ARRAY_CHILDREN_NESTED_LENGTH = 100;
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private Vector listeners = new Vector();
    private Map cachedLocals = new WeakHashMap();
    private Map cachedArrayChildren = new WeakHashMap();

    public LocalsTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.fireTableValueChangedChanged(evt.getSource(), null);
    }

    public Object[] getChildren(Object o, int from, int to) throws UnknownTypeException {
        Object[] ch = this.getChildrenImpl(o, from, to);
        for (int i = 0; i < ch.length; ++i) {
            if (!(ch[i] instanceof Customizer)) continue;
            ((Customizer)ch[i]).addPropertyChangeListener(this);
        }
        return ch;
    }

    public Object[] getChildrenImpl(Object o, int from, int to) throws UnknownTypeException {
        try {
            if (o.equals("Root")) {
                Object[] os = this.getLocalVariables(from, to);
                return os;
            }
            if (o instanceof AbstractVariable) {
                AbstractVariable abstractVariable = (AbstractVariable)o;
                boolean isArray = abstractVariable.getInnerValue() instanceof ArrayReference;
                if (isArray) {
                    to = abstractVariable.getFieldsCount();
                }
                if (isArray && to - from > 100) {
                    ArrayChildrenNode achn = (ArrayChildrenNode)this.cachedArrayChildren.get(abstractVariable.getInnerValue());
                    if (achn == null) {
                        achn = new ArrayChildrenNode(abstractVariable);
                        this.cachedArrayChildren.put(abstractVariable.getInnerValue(), achn);
                    } else {
                        achn.update(abstractVariable);
                    }
                    return achn.getChildren();
                }
                return abstractVariable.getFields(from, to);
            }
            if (o instanceof ArrayChildrenNode) {
                return ((ArrayChildrenNode)o).getChildren();
            }
            throw new UnknownTypeException(o);
        }
        catch (VMDisconnectedException ex) {
            return new Object[0];
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getChildrenCount(Object node) throws UnknownTypeException {
        block15: {
            if (!node.equals("Root")) ** GOTO lbl31
            frame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (frame == null) {
                return 1;
            }
            sf = frame.getStackFrame();
            if (sf != null) break block15;
            return 1;
            {
                catch (VMDisconnectedException var2_4) {
                    return 0;
                }
            }
        }
        try {
            i = 0;
            try {
                i = sf.visibleVariables().size();
            }
            catch (AbsentInformationException ex) {
                ++i;
            }
            if (sf.thisObject() != null) {
                ++i;
            }
            return i;
        }
        catch (NativeMethodException ex) {
            return 1;
            catch (InternalException ex) {
                return 1;
            }
            catch (InvalidStackFrameException ex) {
                return 1;
            }
            catch (VMDisconnectedException ex) {
                return 0;
            }
lbl31:
            // 1 sources

            if (node instanceof AbstractVariable) {
                abstractVariable = (AbstractVariable)node;
                if (abstractVariable.getInnerValue() instanceof ArrayReference) {
                    return Math.min(abstractVariable.getFieldsCount(), 100);
                }
                return abstractVariable.getFieldsCount();
            }
            if (node instanceof ArrayChildrenNode) {
                return ((ArrayChildrenNode)node).getChildren().length;
            }
            throw new UnknownTypeException(node);
        }
    }

    public boolean isLeaf(Object o) throws UnknownTypeException {
        if (o.equals("Root")) {
            return false;
        }
        if (o instanceof AbstractVariable) {
            return !(((AbstractVariable)o).getInnerValue() instanceof ObjectReference);
        }
        if (o.toString().startsWith("SubArray")) {
            return false;
        }
        if (o.equals("NoInfo")) {
            return true;
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
        if (this.listener == null) {
            this.listener = new Listener(this, this.debugger);
        }
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
        if (this.listeners.size() == 0) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private void fireTableValueChangedChanged(Object node, String propertyName) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocalVariables(int from, int to) {
        Object object = this.debugger.LOCK;
        synchronized (object) {
            CallStackFrameImpl callStackFrame = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (callStackFrame == null) {
                return new String[]{"No current thread"};
            }
            StackFrame stackFrame = callStackFrame.getStackFrame();
            if (stackFrame == null) {
                return new String[]{"No current thread"};
            }
            try {
                ObjectReference thisR = stackFrame.thisObject();
                if (thisR == null) {
                    Object avs = null;
                    try {
                        return this.getLocalVariables(callStackFrame, stackFrame, from, to);
                    }
                    catch (AbsentInformationException ex) {
                        return new String[]{"NoInfo"};
                    }
                }
                Object[] avs = null;
                try {
                    avs = this.getLocalVariables(callStackFrame, stackFrame, Math.max(from - 1, 0), Math.max(to - 1, 0));
                }
                catch (AbsentInformationException ex) {
                    avs = new Object[]{"NoInfo"};
                }
                Object[] result = new Object[avs.length + 1];
                if (from < 1) {
                    result[0] = new ThisVariable(this.debugger, thisR, "");
                }
                System.arraycopy(avs, 0, result, 1, avs.length);
                return result;
            }
            catch (InternalException ex) {
                return new String[]{ex.getMessage()};
            }
        }
    }

    LocalVariable[] getLocalVariables(CallStackFrameImpl callStackFrame, StackFrame stackFrame, int from, int to) throws AbsentInformationException {
        LocalVariable[] locals = callStackFrame.getLocalVariables();
        int n = locals.length;
        to = Math.min(n, to);
        if ((from = Math.min(n, from)) != 0 || to != n) {
            LocalVariable[] subLocals = new LocalVariable[to - from];
            for (int i = from; i < to; ++i) {
                subLocals[i - from] = locals[i];
            }
            locals = subLocals;
        }
        return locals;
    }

    public Variable getVariable(Value v) {
        if (v instanceof ObjectReference) {
            return new AbstractVariable(this.debugger, (ObjectReference)v, null);
        }
        return new AbstractVariable(this.debugger, v, null);
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    private static final class ArrayChildrenNode {
        private AbstractVariable var;
        private int from = 0;
        private int length;
        private int maxIndexLog;

        public ArrayChildrenNode(AbstractVariable var) {
            this(var, 0, var.getFieldsCount(), -1);
        }

        private ArrayChildrenNode(AbstractVariable var, int from, int length, int maxIndex) {
            this.var = var;
            this.from = from;
            this.length = length;
            if (maxIndex < 0) {
                maxIndex = from + length - 1;
            }
            this.maxIndexLog = ArrayFieldVariable.log10(maxIndex);
        }

        private static int pow(int a, int b) {
            if (b == 0) {
                return 1;
            }
            int p = a;
            for (int i = 1; i < b; ++i) {
                p *= a;
            }
            return p;
        }

        public Object[] getChildren() {
            if (this.length > 100) {
                int depth = (int)Math.ceil(Math.log(this.length) / Math.log(100.0) - 1.0);
                int n = ArrayChildrenNode.pow(100, depth);
                int numCh = (int)Math.ceil((double)this.length / (double)n);
                Object[] ch = new Object[numCh];
                for (int i = 0; i < numCh; ++i) {
                    int chLength = n;
                    if (i == numCh - 1 && (chLength = this.length % n) == 0) {
                        chLength = n;
                    }
                    ch[i] = new ArrayChildrenNode(this.var, this.from + i * n, chLength, this.from + this.length - 1);
                }
                return ch;
            }
            return this.var.getFields(this.from, this.from + this.length);
        }

        public void update(AbstractVariable var) {
            this.var = var;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ArrayChildrenNode)) {
                return false;
            }
            ArrayChildrenNode achn = (ArrayChildrenNode)obj;
            return achn.var.equals(this.var) && achn.from == this.from && achn.length == this.length;
        }

        public int hashCode() {
            return this.var.hashCode() + this.from + this.length;
        }

        public String toString() {
            int num0 = this.maxIndexLog - ArrayFieldVariable.log10(this.from);
            String froms = num0 > 0 ? ArrayFieldVariable.zeros(2 * num0) + this.from : Integer.toString(this.from);
            int last = this.from + this.length - 1;
            num0 = this.maxIndexLog - ArrayFieldVariable.log10(last);
            String lasts = num0 > 0 ? ArrayFieldVariable.zeros(2 * num0) + last : Integer.toString(last);
            return "SubArray" + froms + "-" + lasts;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(LocalsTreeModel tm, JPDADebugger debugger) {
            this.debugger = debugger;
            this.model = new WeakReference<LocalsTreeModel>(tm);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        private LocalsTreeModel getModel() {
            LocalsTreeModel tm = (LocalsTreeModel)this.model.get();
            if (tm == null) {
                this.destroy();
            }
            return tm;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ((e.getPropertyName() == "currentCallStackFrame" || e.getPropertyName() == "state") && this.debugger.getState() == 3) {
                final LocalsTreeModel ltm = this.getModel();
                if (ltm == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    if (verbose) {
                        System.out.println("LTM cancel old task " + this.task);
                    }
                    this.task = null;
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (Listener.this.debugger.getState() != 3) {
                            if (verbose) {
                                System.out.println("LTM cancel started task " + Listener.this.task);
                            }
                            return;
                        }
                        if (verbose) {
                            System.out.println("LTM do task " + Listener.this.task);
                        }
                        ltm.fireTreeChanged();
                    }
                }, 500);
                if (verbose) {
                    System.out.println("LTM  create task " + this.task);
                }
            } else if (e.getPropertyName() == "state" && this.debugger.getState() != 3 && this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel task " + this.task);
                }
                this.task = null;
            }
        }
    }
}

