/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.FieldVariable;
import org.netbeans.modules.debugger.jpda.models.ObjectArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.ObjectFieldVariable;
import org.netbeans.modules.debugger.jpda.models.SuperVariable;

class AbstractVariable
implements ObjectVariable,
Customizer {
    private Value value;
    private JPDADebuggerImpl debugger;
    private String id;
    private String genericType;
    private org.netbeans.api.debugger.jpda.Field[] fields;
    private org.netbeans.api.debugger.jpda.Field[] staticFields;
    private org.netbeans.api.debugger.jpda.Field[] inheritedFields;
    private Set listeners = new HashSet();

    AbstractVariable(JPDADebuggerImpl debugger, Value value, String id) {
        this.debugger = debugger;
        this.value = value;
        this.id = id;
        if (this.id == null) {
            this.id = Integer.toString(super.hashCode());
        }
    }

    AbstractVariable(JPDADebuggerImpl debugger, Value value, String genericSignature, String id) {
        this.debugger = debugger;
        this.value = value;
        try {
            if (genericSignature != null) {
                this.genericType = AbstractVariable.getTypeDescription(new PushbackReader(new StringReader(genericSignature), 1));
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.id = id;
        if (this.id == null) {
            this.id = Integer.toString(super.hashCode());
        }
    }

    public String getValue() {
        Value v = this.getInnerValue();
        if (v == null) {
            return "null";
        }
        if (v instanceof VoidValue) {
            return "void";
        }
        if (v instanceof CharValue) {
            return "'" + AbstractVariable.convertToCharInitializer(v.toString()) + "'";
        }
        if (v instanceof PrimitiveValue) {
            return v.toString();
        }
        if (v instanceof StringReference) {
            return "\"" + AbstractVariable.convertToStringInitializer(((StringReference)v).value()) + "\"";
        }
        if (v instanceof ClassObjectReference) {
            return "class " + ((ClassObjectReference)v).reflectedType().name();
        }
        if (v instanceof ArrayReference) {
            return "#" + ((ArrayReference)v).uniqueID() + "(length=" + ((ArrayReference)v).length() + ")";
        }
        return "#" + ((ObjectReference)v).uniqueID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String expression) throws InvalidExpressionException {
        Object[] ls;
        Value value = this.debugger.evaluateIn(expression);
        this.setValue(value);
        this.setInnerValue(value);
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "value", null, value);
        Set set = this.listeners;
        synchronized (set) {
            ls = this.listeners.toArray();
        }
        for (int i = 0; i < ls.length; ++i) {
            ((PropertyChangeListener)ls[i]).propertyChange(evt);
        }
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        throw new InternalError();
    }

    public void setObject(Object bean) {
        try {
            if (!(bean instanceof String)) {
                throw new IllegalArgumentException("" + bean);
            }
            this.setValue((String)bean);
        }
        catch (InvalidExpressionException ieex) {
            IllegalArgumentException iaex = new IllegalArgumentException(ieex.getLocalizedMessage());
            iaex.initCause(ieex);
            throw iaex;
        }
    }

    public int getFieldsCount() {
        Value v = this.getInnerValue();
        if (v == null) {
            return 0;
        }
        if (v instanceof ArrayReference) {
            return ((ArrayReference)v).length();
        }
        if (this.fields == null) {
            this.initFields();
        }
        return this.fields.length;
    }

    public org.netbeans.api.debugger.jpda.Field getField(String name) {
        if (this.getInnerValue() == null) {
            return null;
        }
        Field f = ((ReferenceType)this.getInnerValue().type()).fieldByName(name);
        if (f == null) {
            return null;
        }
        return this.getField(f, (ObjectReference)this.getInnerValue(), this.getID());
    }

    public org.netbeans.api.debugger.jpda.Field[] getFields(int from, int to) {
        Value v = this.getInnerValue();
        if (v == null) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        if (v instanceof ArrayReference && (from > 0 || to < ((ArrayReference)v).length())) {
            Type type = v.type();
            ReferenceType rt = (ReferenceType)type;
            if (to == 0) {
                to = ((ArrayReference)v).length();
            }
            org.netbeans.api.debugger.jpda.Field[] elements = this.getFieldsOfArray((ArrayReference)v, ((ArrayType)rt).componentTypeName(), this.getID(), from, to);
            return elements;
        }
        if (this.fields == null) {
            this.initFields();
        }
        if (to != 0) {
            to = Math.min(this.fields.length, to);
            from = Math.min(this.fields.length, from);
            org.netbeans.api.debugger.jpda.Field[] fv = new org.netbeans.api.debugger.jpda.Field[to - from];
            System.arraycopy(this.fields, from, fv, 0, to - from);
            return fv;
        }
        return this.fields;
    }

    public org.netbeans.api.debugger.jpda.Field[] getAllStaticFields(int from, int to) {
        Value v = this.getInnerValue();
        if (v == null || v instanceof ArrayReference) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        if (this.fields == null) {
            this.initFields();
        }
        if (to != 0) {
            to = Math.min(this.staticFields.length, to);
            from = Math.min(this.staticFields.length, from);
            org.netbeans.api.debugger.jpda.Field[] fv = new FieldVariable[to - from];
            System.arraycopy(this.staticFields, from, fv, 0, to - from);
            return fv;
        }
        return this.staticFields;
    }

    public org.netbeans.api.debugger.jpda.Field[] getInheritedFields(int from, int to) {
        Value v = this.getInnerValue();
        if (v == null || v instanceof ArrayReference) {
            return new org.netbeans.api.debugger.jpda.Field[0];
        }
        if (this.fields == null) {
            this.initFields();
        }
        if (to != 0) {
            to = Math.min(this.inheritedFields.length, to);
            from = Math.min(this.inheritedFields.length, from);
            org.netbeans.api.debugger.jpda.Field[] fv = new FieldVariable[to - from];
            System.arraycopy(this.inheritedFields, from, fv, 0, to - from);
            return fv;
        }
        return this.inheritedFields;
    }

    public Super getSuper() {
        if (this.getInnerValue() == null) {
            return null;
        }
        Type t = this.getInnerValue().type();
        if (!(t instanceof ClassType)) {
            return null;
        }
        ClassType superType = ((ClassType)t).superclass();
        if (superType == null) {
            return null;
        }
        return new SuperVariable(this.debugger, (ObjectReference)this.getInnerValue(), superType, this.id);
    }

    public String getToStringValue() throws InvalidExpressionException {
        try {
            Value v = this.getInnerValue();
            if (v == null) {
                return null;
            }
            if (!(v.type() instanceof ClassType)) {
                return this.getValue();
            }
            if (v instanceof CharValue) {
                return "'" + AbstractVariable.convertToCharInitializer(v.toString()) + "'";
            }
            if (v instanceof StringReference) {
                return "\"" + AbstractVariable.convertToStringInitializer(((StringReference)v).value()) + "\"";
            }
            Method toStringMethod = ((ClassType)v.type()).concreteMethodByName("toString", "()Ljava/lang/String;");
            StringReference sr = (StringReference)this.debugger.invokeMethod((ObjectReference)v, toStringMethod, new Value[0]);
            if (sr == null) {
                return null;
            }
            return sr.value();
        }
        catch (VMDisconnectedException ex) {
            return "";
        }
    }

    public Variable invokeMethod(String methodName, String signature, Variable[] arguments) throws NoSuchMethodException, InvalidExpressionException {
        try {
            int j;
            int jj;
            List<Method> l;
            if (this.getInnerValue() == null) {
                return null;
            }
            Method method = null;
            if (signature != null) {
                method = ((ClassType)this.getInnerValue().type()).concreteMethodByName(methodName, signature);
            } else {
                l = ((ClassType)this.getInnerValue().type()).methodsByName(methodName);
                jj = l.size();
                for (j = 0; j < jj; ++j) {
                    if (l.get(j).isAbstract() || l.get(j).argumentTypeNames().size() != 0) continue;
                    method = l.get(j);
                    break;
                }
            }
            if (method == null) {
                l = ((ClassType)this.getInnerValue().type()).methodsByName(methodName);
                jj = l.size();
                for (j = 0; j < jj; ++j) {
                    System.out.println(l.get(j).signature());
                }
                throw new NoSuchMethodException(this.getInnerValue().type().name() + "." + methodName + " : " + signature);
            }
            Value[] vs = new Value[arguments.length];
            int k = arguments.length;
            for (int i = 0; i < k; ++i) {
                vs[i] = ((AbstractVariable)arguments[i]).getInnerValue();
            }
            Value v = this.debugger.invokeMethod((ObjectReference)this.getInnerValue(), method, vs);
            if (v instanceof ObjectReference) {
                return new AbstractVariable(this.debugger, (ObjectReference)v, this.id + method + "^");
            }
            return new AbstractVariable(this.debugger, v, this.id + method);
        }
        catch (VMDisconnectedException ex) {
            return null;
        }
    }

    public String getType() {
        if (this.genericType != null) {
            return this.genericType;
        }
        if (this.getInnerValue() == null) {
            return "";
        }
        try {
            return this.getInnerValue().type().name();
        }
        catch (VMDisconnectedException vmdex) {
            return "";
        }
    }

    public boolean equals(Object o) {
        return o instanceof AbstractVariable && this.id.equals(((AbstractVariable)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected Value getInnerValue() {
        return this.value;
    }

    protected void setInnerValue(Value v) {
        this.value = v;
        this.fields = null;
        this.staticFields = null;
        this.inheritedFields = null;
    }

    protected final JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    String getID() {
        return this.id;
    }

    private static String getTypeDescription(PushbackReader signature) throws IOException {
        int c = signature.read();
        switch (c) {
            case 90: {
                return "boolean";
            }
            case 66: {
                return "byte";
            }
            case 67: {
                return "char";
            }
            case 83: {
                return "short";
            }
            case 73: {
                return "int";
            }
            case 74: {
                return "long";
            }
            case 70: {
                return "float";
            }
            case 68: {
                return "double";
            }
            case 91: {
                int arrayCount = 1;
                while (true) {
                    if ((c = signature.read()) != 91) break;
                    ++arrayCount;
                }
                signature.unread(c);
                return AbstractVariable.getTypeDescription(signature) + " " + AbstractVariable.brackets(arrayCount);
            }
            case 76: {
                StringBuffer typeName = new StringBuffer(50);
                while (true) {
                    if ((c = signature.read()) == 59) {
                        int idx = typeName.lastIndexOf("/");
                        return idx == -1 ? typeName.toString() : typeName.substring(idx + 1);
                    }
                    if (c == 60) {
                        int idx = typeName.lastIndexOf("/");
                        if (idx != -1) {
                            typeName.delete(0, idx + 1);
                        }
                        typeName.append("<");
                        while (true) {
                            String td = AbstractVariable.getTypeDescription(signature);
                            typeName.append(td);
                            c = signature.read();
                            if (c == 62) break;
                            signature.unread(c);
                            typeName.append(',');
                        }
                        signature.read();
                        typeName.append(">");
                        return typeName.toString();
                    }
                    typeName.append((char)c);
                }
            }
        }
        throw new IOException();
    }

    private static String brackets(int arrayCount) {
        StringBuffer sb = new StringBuffer(arrayCount * 2);
        do {
            sb.append("[]");
        } while (--arrayCount > 0);
        return sb.toString();
    }

    private void initFields() {
        Value value = this.getInnerValue();
        Type type = value != null ? this.getInnerValue().type() : null;
        if (!(this.getInnerValue() instanceof ObjectReference) || !(type instanceof ReferenceType)) {
            this.fields = new org.netbeans.api.debugger.jpda.Field[0];
            this.staticFields = new org.netbeans.api.debugger.jpda.Field[0];
            this.inheritedFields = new org.netbeans.api.debugger.jpda.Field[0];
        } else {
            ObjectReference or = (ObjectReference)this.getInnerValue();
            ReferenceType rt = (ReferenceType)type;
            if (or instanceof ArrayReference) {
                this.fields = this.getFieldsOfArray((ArrayReference)or, ((ArrayType)rt).componentTypeName(), this.getID(), 0, ((ArrayReference)or).length());
                this.staticFields = new org.netbeans.api.debugger.jpda.Field[0];
                this.inheritedFields = new org.netbeans.api.debugger.jpda.Field[0];
            } else {
                this.initFieldsOfClass(or, rt, this.getID());
            }
        }
    }

    private org.netbeans.api.debugger.jpda.Field[] getFieldsOfArray(ArrayReference ar, String componentType, String parentID, int from, int to) {
        List<Value> l = ar.getValues(from, to - from);
        int k = l.size();
        org.netbeans.api.debugger.jpda.Field[] ch = new org.netbeans.api.debugger.jpda.Field[k];
        for (int i = 0; i < k; ++i) {
            Value v = l.get(i);
            ch[i] = v instanceof ObjectReference ? new ObjectArrayFieldVariable(this.debugger, (ObjectReference)v, componentType, ar, from + i, to - 1, parentID) : new ArrayFieldVariable(this.debugger, v, componentType, ar, from + i, to - 1, parentID);
        }
        return ch;
    }

    private void initFieldsOfClass(ObjectReference or, ReferenceType rt, String parentID) {
        ArrayList<FieldVariable> fields = new ArrayList<FieldVariable>();
        ArrayList<FieldVariable> staticFields = new ArrayList<FieldVariable>();
        ArrayList<FieldVariable> allInheretedFields = new ArrayList<FieldVariable>();
        List<Field> l = rt.allFields();
        HashSet<Field> s = new HashSet<Field>(rt.fields());
        int k = l.size();
        for (int i = 0; i < k; ++i) {
            Field f = l.get(i);
            FieldVariable field = this.getField(f, or, this.getID());
            if (f.isStatic()) {
                staticFields.add(field);
                continue;
            }
            if (s.contains(f)) {
                fields.add(field);
                continue;
            }
            allInheretedFields.add(field);
        }
        this.fields = fields.toArray(new org.netbeans.api.debugger.jpda.Field[fields.size()]);
        this.inheritedFields = allInheretedFields.toArray(new org.netbeans.api.debugger.jpda.Field[allInheretedFields.size()]);
        this.staticFields = staticFields.toArray(new org.netbeans.api.debugger.jpda.Field[staticFields.size()]);
    }

    FieldVariable getField(Field f, ObjectReference or, String parentID) {
        Value v = or.getValue(f);
        if (v == null || v instanceof ObjectReference) {
            return new ObjectFieldVariable(this.debugger, (ObjectReference)v, f, parentID, JPDADebuggerImpl.getGenericSignature(f), or);
        }
        return new FieldVariable(this.debugger, v, f, parentID, or);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    public String toString() {
        return "ObjectVariable ";
    }

    private static String convertToStringInitializer(String s) {
        StringBuffer sb = new StringBuffer();
        int k = s.length();
        block9: for (int i = 0; i < k; ++i) {
            switch (s.charAt(i)) {
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    private static String convertToCharInitializer(String s) {
        StringBuffer sb = new StringBuffer();
        int k = s.length();
        block9: for (int i = 0; i < k; ++i) {
            switch (s.charAt(i)) {
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block9;
                }
                default: {
                    sb.append(s.charAt(i));
                }
            }
        }
        return sb.toString();
    }
}

