/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterImpl;
import org.netbeans.modules.debugger.jpda.actions.StepActionProvider;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class StepIntoActionProvider
extends JPDADebuggerActionProvider
implements Executor,
PropertyChangeListener {
    public static final String SS_STEP_OUT = "SS_ACTION_STEPOUT";
    private static final boolean ssverbose = System.getProperty("netbeans.debugger.smartstepping") != null;
    private StepRequest stepRequest;
    private String position;
    private ContextProvider contextProvider;
    private boolean smartSteppingStepOut;
    private StepActionProvider stepActionProvider;
    private SmartSteppingFilterImpl smartSteppingFilterImpl;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    public StepIntoActionProvider(ContextProvider contextProvider) {
        super((JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class)));
        this.contextProvider = contextProvider;
        this.getSmartSteppingFilterImpl().addPropertyChangeListener(this);
        SourcePath ec = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        ec.addPropertyChangeListener(this);
        Map properties = (Map)contextProvider.lookupFirst(null, Map.class);
        if (properties != null) {
            this.smartSteppingStepOut = properties.containsKey(SS_STEP_OUT);
        }
        this.setProviderToDisableOnLazyAction(this);
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_INTO));
    }

    public void doAction(Object action) {
        this.runAction();
    }

    public void postAction(Object action, final Runnable actionPerformedNotifier) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepIntoActionProvider.this.runAction();
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction() {
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            JPDAThread t;
            if (ssverbose) {
                System.out.println("\nSS:  STEP INTO !!! *************");
            }
            if ((t = this.getDebuggerImpl().getCurrentThread()) == null || !t.isSuspended()) {
                return;
            }
            this.setStepRequest(1);
            this.position = t.getClassName() + '.' + t.getMethodName() + ':' + t.getLineNumber(null);
            try {
                this.getDebuggerImpl().resume();
            }
            catch (VMDisconnectedException e) {
                ErrorManager.getDefault().notify(256, ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)StepIntoActionProvider.class, (String)"VMDisconnected")));
            }
        }
    }

    protected void checkEnabled(int debuggerState) {
        Iterator i = this.getActions().iterator();
        while (i.hasNext()) {
            this.setEnabled(i.next(), debuggerState == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName() == "exclusionPatterns") {
            if (ev.getOldValue() != null) {
                if (ssverbose) {
                    System.out.println("\nSS:  exclusion patterns removed");
                }
                ThreadReference tr = ((JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread()).getThreadReference();
                this.removeStepRequests(tr);
            } else {
                if (ssverbose) {
                    if (this.stepRequest == null) {
                        System.out.println("SS:  exclusion patterns has been added");
                    } else {
                        System.out.println("\nSS:    add exclusion patterns:");
                    }
                }
                this.addPatternsToRequest(((Set)ev.getNewValue()).toArray(new String[((Set)ev.getNewValue()).size()]));
            }
        } else if (ev.getPropertyName() == "sourceRoots") {
            JPDAThreadImpl jtr;
            if (ssverbose) {
                System.out.println("\nSS:  source roots changed");
            }
            if ((jtr = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread()) != null) {
                ThreadReference tr = jtr.getThreadReference();
                this.removeStepRequests(tr);
            }
        } else {
            super.propertyChange(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(Event event) {
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            String stopPosition;
            if (this.stepRequest != null) {
                this.stepRequest.disable();
            }
            LocatableEvent le = (LocatableEvent)event;
            ThreadReference tr = le.thread();
            try {
                if (tr.frame(0).location().method().isSynthetic()) {
                    this.setStepRequest(1);
                    return true;
                }
            }
            catch (IncompatibleThreadStateException e) {
                // empty catch block
            }
            JPDAThread t = this.getDebuggerImpl().getThread(tr);
            boolean stop = this.getCompoundSmartSteppingListener().stopHere(this.contextProvider, t, this.getSmartSteppingFilterImpl());
            if (stop && this.position.equals(stopPosition = t.getClassName() + '.' + t.getMethodName() + ':' + t.getLineNumber(null))) {
                stop = false;
                this.setStepRequest(1);
                return true;
            }
            if (stop) {
                this.removeStepRequests(le.thread());
                Session session = (Session)this.contextProvider.lookupFirst(null, Session.class);
                if (session != null) {
                    DebuggerManager.getDebuggerManager().setCurrentSession(session);
                }
                this.getDebuggerImpl().setStoppedState(tr);
            } else {
                if (ssverbose) {
                    System.out.println("SS:  => do next step!");
                }
                if (this.smartSteppingStepOut) {
                    this.setStepRequest(3);
                } else if (this.stepRequest != null) {
                    this.stepRequest.enable();
                } else {
                    this.setStepRequest(1);
                }
            }
            if (ssverbose && stop) {
                System.out.println("SS  FINISH IN CLASS " + t.getClassName() + " ********\n");
            }
            return !stop;
        }
    }

    private StepActionProvider getStepActionProvider() {
        if (this.stepActionProvider == null) {
            List l = this.contextProvider.lookup(null, ActionsProvider.class);
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                if (!(l.get(i) instanceof StepActionProvider)) continue;
                this.stepActionProvider = (StepActionProvider)l.get(i);
            }
        }
        return this.stepActionProvider;
    }

    void removeStepRequests(ThreadReference tr) {
        super.removeStepRequests(tr);
        this.stepRequest = null;
        if (ssverbose) {
            System.out.println("SS:    remove all patterns");
        }
    }

    private void setStepRequest(int step) {
        ThreadReference tr = ((JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread()).getThreadReference();
        this.removeStepRequests(tr);
        this.stepRequest = this.getDebuggerImpl().getVirtualMachine().eventRequestManager().createStepRequest(tr, -2, step);
        this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
        this.stepRequest.setSuspendPolicy(this.getDebuggerImpl().getSuspend());
        if (ssverbose) {
            System.out.println("SS:    set patterns:");
        }
        this.addPatternsToRequest(this.getSmartSteppingFilterImpl().getExclusionPatterns());
        this.stepRequest.enable();
    }

    private SmartSteppingFilterImpl getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilterImpl == null) {
            this.smartSteppingFilterImpl = (SmartSteppingFilterImpl)this.contextProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilterImpl;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.contextProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    private void addPatternsToRequest(String[] patterns) {
        if (this.stepRequest == null) {
            return;
        }
        int k = patterns.length;
        for (int i = 0; i < k; ++i) {
            this.stepRequest.addClassExclusionFilter(patterns[i]);
            if (!ssverbose) continue;
            System.out.println("SS:      " + patterns[i]);
        }
    }
}

