/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xsd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.xml.xsd.AbstractResultNode;
import org.netbeans.modules.xml.xsd.Type;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class SchemaElement
extends AbstractResultNode
implements Element {
    protected final String namespaceURI;
    protected final String qname;
    protected final Attributes attributes;
    protected final List subelements;
    private String prefix;
    private String schemaPrefix;

    protected SchemaElement() {
        this.namespaceURI = null;
        this.qname = null;
        this.attributes = null;
        this.subelements = null;
        this.schemaPrefix = null;
    }

    protected SchemaElement(String namespaceURI, String qname, Attributes attributes, String schemaPrefix) {
        this.namespaceURI = namespaceURI;
        this.qname = qname;
        this.attributes = attributes == null ? null : new AttributesImpl(attributes);
        this.subelements = new ArrayList();
        this.schemaPrefix = schemaPrefix;
    }

    public static final SchemaElement createSchemaElement(String namespaceURI, String qname, Attributes attributes, String schemaPrefix) {
        String simpleType = null;
        String complexType = null;
        if (schemaPrefix == null) {
            simpleType = "simpleType";
            complexType = "complexType";
        } else {
            simpleType = schemaPrefix + ':' + "simpleType";
            complexType = schemaPrefix + ':' + "complexType";
        }
        if (qname.equalsIgnoreCase(simpleType) || qname.equalsIgnoreCase(complexType)) {
            return new Type(namespaceURI, qname, attributes, schemaPrefix);
        }
        return new SchemaElement(namespaceURI, qname, attributes, schemaPrefix);
    }

    public final void addSubelement(SchemaElement e) {
        this.subelements.add(e);
    }

    public final Iterator getSubelements() {
        return this.subelements.iterator();
    }

    public final boolean isComposite() {
        String sequenceToken = this.getSchemaPrefix() == null ? "sequence" : this.getSchemaPrefix() + ':' + "sequence";
        return this instanceof Type || this.getQname().equalsIgnoreCase(sequenceToken);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("SchemaElement ").append(this.qname);
        if (this.attributes != null) {
            sb.append("Attrs size: " + this.attributes.getLength());
            for (int i = 0; i < this.attributes.getLength(); ++i) {
                sb.append("\n Attr[" + i + "] localname: " + this.attributes.getLocalName(i) + " qname: " + this.attributes.getQName(i) + " value: " + this.attributes.getValue(i) + " URI: " + this.attributes.getURI(i) + " type: " + this.attributes.getType(i));
            }
        }
        return sb.toString();
    }

    public String getQname() {
        return this.qname;
    }

    public Attributes getSAXAttributes() {
        return this.attributes;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeName() {
        String name = this.getSAXAttributes().getValue("name");
        if (this.prefix != null) {
            name = this.prefix + ':' + name;
        }
        return name;
    }

    public String getTagName() {
        return this.getNodeName();
    }

    public void setPrefix(String str) throws DOMException {
        this.prefix = str;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSchemaPrefix() {
        return this.schemaPrefix;
    }

    public void setSchemaPrefix(String schemaPrefix) {
        this.schemaPrefix = schemaPrefix;
    }
}

