/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractViewTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.MetalEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.openide.awt.HtmlRenderer;

public final class MetalViewTabDisplayerUI
extends AbstractViewTabDisplayerUI {
    private static final int TXT_X_PAD = 5;
    private static final int ICON_X_LEFT_PAD = 5;
    private static final int ICON_X_RIGHT_PAD = 2;
    private static final int BUMP_X_PAD = 5;
    private static final int BUMP_Y_PAD = 4;
    private static AbstractViewTabDisplayerUI.IconLoader closeIcon;
    private static Color inactBgColor;
    private static Color actBgColor;
    private static Color borderHighlight;
    private static Color borderShadow;
    private Dimension prefSize;
    private Rectangle tempRect = new Rectangle();

    private MetalViewTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
        this.prefSize = new Dimension(100, 19);
    }

    public static ComponentUI createUI(JComponent c) {
        return new MetalViewTabDisplayerUI((TabDisplayer)c);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (closeIcon == null) {
            closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
        }
    }

    protected AbstractViewTabDisplayerUI.Controller createController() {
        return new OwnController();
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics fm = this.getTxtFontMetrics();
        int height = fm == null ? 21 : fm.getAscent() + 2 * fm.getDescent() + 4;
        Insets insets = c.getInsets();
        this.prefSize.height = height + insets.bottom + insets.top;
        return this.prefSize;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        this.paintBottomBorder(g, c);
    }

    private void paintBottomBorder(Graphics g, JComponent c) {
        Color color = this.isActive() ? MetalViewTabDisplayerUI.getActBgColor() : MetalViewTabDisplayerUI.getInactBgColor();
        g.setColor(color);
        Rectangle bounds = c.getBounds();
        g.fillRect(1, bounds.height - 3, bounds.width - 1, 2);
        g.setColor(this.getBorderShadow());
        g.drawLine(1, bounds.height - 1, bounds.width - 1, bounds.height - 1);
    }

    protected void paintTabContent(Graphics g, int index, String text, int x, int y, int width, int height) {
        FontMetrics fm = this.getTxtFontMetrics();
        g.setFont(this.getTxtFont());
        int txtWidth = width;
        if (this.isSelected(index)) {
            AbstractViewTabDisplayerUI.PinButton pin = this.configurePinButton(index);
            boolean showPin = pin != null && pin.getOrientation() != TabDisplayer.ORIENTATION_INVISIBLE;
            int space4Pin = showPin ? this.pinButton.getWidth() + 1 : 0;
            int space4Icon = 0;
            if (this.displayer.isShowCloseButton()) {
                String iconPath = this.findIconPath(index);
                Icon icon = closeIcon.obtainIcon(iconPath);
                int iconWidth = icon.getIconWidth();
                space4Icon = iconWidth + 5 + 2 + space4Pin;
                txtWidth = width - 10 - space4Icon;
                this.getCloseIconRect(this.tempRect, index);
                icon.paintIcon(this.getDisplayer(), g, this.tempRect.x, this.tempRect.y);
            } else {
                this.tempRect.x = x + (width - 2);
                this.tempRect.y = !showPin ? 0 : this.displayer.getHeight() / 2 - this.pinButton.getPreferredSize().height / 2;
                txtWidth = width - 10 - space4Pin;
                space4Icon = space4Pin + 5;
            }
            txtWidth = (int)HtmlRenderer.renderString((String)text, (Graphics)g, (int)(x + 5), (int)(height - fm.getDescent() - 4), (int)txtWidth, (int)height, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
            int bumpWidth = width - (5 + txtWidth + 5 + space4Icon);
            if (bumpWidth > 0) {
                this.paintBump(index, g, x + 5 + txtWidth + 5, y + 4, bumpWidth, height - 8);
            }
            if (showPin) {
                if (this.tempRect.x - space4Pin < x + 5 - 1) {
                    this.pinButton.setVisible(false);
                } else {
                    this.pinButton.setVisible(true);
                    this.pinButton.setLocation(this.tempRect.x - space4Pin, this.tempRect.y);
                }
            } else {
                this.pinButton.setVisible(false);
            }
        } else {
            txtWidth = width - 10;
            HtmlRenderer.renderString((String)text, (Graphics)g, (int)(x + 5), (int)(height - fm.getDescent() - 4), (int)txtWidth, (int)height, (Font)this.getTxtFont(), (Color)UIManager.getColor("textText"), (int)1, (boolean)true);
        }
    }

    protected void paintTabBorder(Graphics g, int index, int x, int y, int width, int height) {
        Color highlight = this.getBorderHighlight();
        Color shadow = this.getBorderShadow();
        boolean isSelected = this.isSelected(index);
        boolean isFirst = index == 0;
        boolean isLast = index == this.getDataModel().size() - 1;
        g.translate(x, y);
        g.setColor(shadow);
        if (!isFirst) {
            g.drawLine(0, 0, 0, height - 5);
        }
        if (!isSelected) {
            g.drawLine(1, height - 5, isLast ? width - 1 : width, height - 5);
        }
        g.setColor(highlight);
        g.drawLine(1, 0, width - 1, 0);
        if (isFirst) {
            g.drawLine(0, 0, 0, height - 2);
        }
        if (!isSelected) {
            g.drawLine(0, height - 4, isLast ? width - 1 : width, height - 4);
        }
        g.translate(-x, -y);
    }

    protected void paintTabBackground(Graphics g, int index, int x, int y, int width, int height) {
        boolean selected = this.isSelected(index);
        boolean highlighted = selected && this.isActive();
        boolean attention = this.isAttention(index);
        if (highlighted && !attention) {
            g.setColor(MetalViewTabDisplayerUI.getActBgColor());
            g.fillRect(x, y, width, height - 3);
        } else if (attention) {
            g.setColor(MetalEditorTabCellRenderer.ATTENTION_COLOR);
            g.fillRect(x, y, width, height - 3);
        } else {
            g.setColor(MetalViewTabDisplayerUI.getInactBgColor());
            g.fillRect(x, y, width, height - 3);
        }
    }

    private void paintBump(int index, Graphics g, int x, int y, int width, int height) {
        ColorUtil.paintViewTabBump(g, x, y, width, height, this.isFocused(index) ? 4 : 2);
    }

    static Color getInactBgColor() {
        if (inactBgColor == null && (inactBgColor = (Color)UIManager.get("inactiveCaption")) == null) {
            inactBgColor = new Color(204, 204, 204);
        }
        return inactBgColor;
    }

    static Color getActBgColor() {
        if (actBgColor == null && (actBgColor = (Color)UIManager.get("activeCaption")) == null) {
            actBgColor = new Color(204, 204, 255);
        }
        return actBgColor;
    }

    private Color getBorderHighlight() {
        if (borderHighlight == null) {
            borderHighlight = MetalViewTabDisplayerUI.getInactBgColor().brighter();
        }
        return borderHighlight;
    }

    private Color getBorderShadow() {
        if (borderShadow == null) {
            borderShadow = MetalViewTabDisplayerUI.getInactBgColor().darker();
        }
        return borderShadow;
    }

    private String findIconPath(int index) {
        if (this.controller.isClosePressed() == index) {
            return "org/netbeans/swing/tabcontrol/resources/met-bigclose-pressed.gif";
        }
        return this.controller.isMouseInCloseButton() == index ? "org/netbeans/swing/tabcontrol/resources/met-bigclose-focus.gif" : "org/netbeans/swing/tabcontrol/resources/met-bigclose-normal.gif";
    }

    private Rectangle getCloseIconRect(Rectangle rect, int index) {
        TabLayoutModel tlm = this.getLayoutModel();
        int x = tlm.getX(index);
        int w = tlm.getW(index);
        String iconPath = this.findIconPath(index);
        if (closeIcon == null) {
            closeIcon = new AbstractViewTabDisplayerUI.IconLoader();
        }
        Icon icon = closeIcon.obtainIcon(iconPath);
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        rect.x = x + w - iconWidth - 2;
        rect.y = this.getCenteredIconY(icon, index);
        rect.width = iconWidth;
        rect.height = iconHeight;
        return rect;
    }

    public AbstractViewTabDisplayerUI.Controller getController() {
        return this.controller;
    }

    protected AbstractViewTabDisplayerUI.PinButton createPinButton() {
        HashMap<Object, String> normalIcons = new HashMap<Object, String>(6);
        normalIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-select-east.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-select-west.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-select-south.gif");
        normalIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-select-center.gif");
        HashMap<Object, String> pressedIcons = new HashMap<Object, String>(6);
        pressedIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/met-pin-pressed-select-east.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/met-pin-pressed-select-west.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/met-pin-pressed-select-south.gif");
        pressedIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/met-pin-pressed-select-center.gif");
        HashMap<Object, String> rolloverIcons = new HashMap<Object, String>(6);
        rolloverIcons.put(TabDisplayer.ORIENTATION_EAST, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-focus-east.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_WEST, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-focus-west.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_SOUTH, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-focus-south.gif");
        rolloverIcons.put(TabDisplayer.ORIENTATION_CENTER, "org/netbeans/swing/tabcontrol/resources/met-pin-normal-focus-center.gif");
        return new AbstractViewTabDisplayerUI.PinButton(normalIcons, pressedIcons, rolloverIcons);
    }

    private class OwnController
    extends AbstractViewTabDisplayerUI.Controller {
        private OwnController() {
        }

        protected int inCloseIconRect(Point point) {
            if (!MetalViewTabDisplayerUI.this.displayer.isShowCloseButton()) {
                return -1;
            }
            int index = MetalViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (index < 0 || !MetalViewTabDisplayerUI.this.isSelected(index)) {
                return -1;
            }
            return MetalViewTabDisplayerUI.this.getCloseIconRect(MetalViewTabDisplayerUI.this.tempRect, index).contains(point) ? index : -1;
        }

        protected boolean inPinButtonRect(Point p) {
            if (!MetalViewTabDisplayerUI.this.pinButton.isVisible()) {
                return false;
            }
            Point p2 = SwingUtilities.convertPoint(MetalViewTabDisplayerUI.this.displayer, p, MetalViewTabDisplayerUI.this.pinButton);
            return MetalViewTabDisplayerUI.this.pinButton.contains(p2);
        }
    }
}

