/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.TestsuiteNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

final class RootNodeChildren
extends Children.Array {
    private volatile boolean filtered;
    private Collection reports;
    private volatile int passedSuites;
    private volatile int failedSuites;
    private volatile boolean live = false;
    private String runningSuiteName;
    private TestsuiteNode runningSuiteNode;

    RootNodeChildren(boolean filtered) {
        this.filtered = filtered;
    }

    void displaySuiteRunning(String suiteName) {
        assert (EventQueue.isDispatchThread());
        assert (this.runningSuiteName == null);
        assert (this.runningSuiteNode == null);
        this.runningSuiteName = suiteName;
        if (this.live) {
            this.runningSuiteNode = new TestsuiteNode(suiteName, this.filtered);
            this.add(new Node[]{this.runningSuiteNode});
        }
        assert (this.runningSuiteName != null);
        assert (this.runningSuiteNode != null == this.live);
    }

    TestsuiteNode displayReport(Report report) {
        TestsuiteNode correspondingNode;
        assert (EventQueue.isDispatchThread());
        assert (this.runningSuiteNode != null == (this.live && this.runningSuiteName != null));
        if (this.reports == null) {
            this.reports = new ArrayList(10);
        }
        this.reports.add(report);
        boolean isPassedSuite = this.updateStatistics(report);
        if (this.runningSuiteName != null) {
            this.runningSuiteName = null;
            if (this.live) {
                if (this.filtered && isPassedSuite) {
                    this.remove(new Node[]{this.runningSuiteNode});
                    correspondingNode = null;
                } else {
                    this.runningSuiteNode.displayReport(report);
                    correspondingNode = this.runningSuiteNode;
                }
                this.runningSuiteNode = null;
            } else {
                correspondingNode = null;
            }
        } else if (!(!this.live || this.filtered && isPassedSuite)) {
            Node[] nodeArray = new Node[1];
            correspondingNode = this.createNode(report);
            nodeArray[0] = correspondingNode;
            this.add(nodeArray);
        } else {
            correspondingNode = null;
        }
        assert (this.runningSuiteName == null);
        assert (this.runningSuiteNode == null);
        return correspondingNode;
    }

    void displayReports(Collection newReports) {
        assert (EventQueue.isDispatchThread());
        if (this.reports == null) {
            this.reports = new ArrayList(newReports);
        } else {
            this.reports.addAll(newReports);
        }
        if (!this.live) {
            Iterator it = this.reports.iterator();
            while (it.hasNext()) {
                this.updateStatistics((Report)it.next());
            }
        } else if (!this.filtered) {
            Node[] nodesToAdd = new Node[newReports.size()];
            int index = 0;
            for (Report report : newReports) {
                this.updateStatistics(report);
                nodesToAdd[index] = this.createNode(report);
                ++index;
            }
            this.add(nodesToAdd);
        } else {
            ArrayList<TestsuiteNode> toAdd = new ArrayList<TestsuiteNode>(newReports.size());
            for (Report report : newReports) {
                boolean isFailed = this.updateStatistics(report);
                if (!isFailed) continue;
                toAdd.add(this.createNode(report));
            }
            if (!toAdd.isEmpty()) {
                Node[] nodesToAdd = toAdd.toArray(new Node[toAdd.size()]);
                this.add(nodesToAdd);
            }
        }
    }

    private boolean updateStatistics(Report report) {
        boolean isPassedSuite;
        boolean bl = isPassedSuite = !report.containsFailed();
        if (isPassedSuite) {
            ++this.passedSuites;
        } else {
            ++this.failedSuites;
        }
        return isPassedSuite;
    }

    protected void addNotify() {
        super.addNotify();
        this.live = true;
        this.addAllMatchingNodes();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.remove(this.getNodes());
        this.live = false;
    }

    private void addAllMatchingNodes() {
        int nodesCount;
        boolean filterOn = this.filtered;
        int matchingNodesCount = filterOn ? this.failedSuites : this.failedSuites + this.passedSuites;
        int n = nodesCount = this.runningSuiteNode != null ? matchingNodesCount + 1 : matchingNodesCount;
        if (nodesCount != 0) {
            Node[] nodes = new Node[nodesCount];
            Iterator i = this.reports.iterator();
            int index = 0;
            while (index < matchingNodesCount) {
                Report report = (Report)i.next();
                if (filterOn && !report.containsFailed()) continue;
                nodes[index++] = this.createNode(report);
            }
            if (this.runningSuiteNode != null) {
                nodes[index++] = this.runningSuiteNode;
            }
            this.add(nodes);
        }
    }

    private void removeAllNodes() {
        this.remove(this.getNodes());
    }

    private TestsuiteNode createNode(Report report) {
        return new TestsuiteNode(report, this.filtered);
    }

    void setFiltered(boolean filtered) {
        assert (EventQueue.isDispatchThread());
        if (filtered == this.filtered) {
            return;
        }
        this.filtered = filtered;
        if (!this.live) {
            return;
        }
        if (this.passedSuites == 0) {
            return;
        }
        if (filtered) {
            this.removePassedSuites();
        } else {
            this.addPassedSuites();
        }
    }

    private void removePassedSuites() {
        assert (EventQueue.isDispatchThread());
        assert (this.live);
        Node[] nodesToRemove = new Node[this.passedSuites];
        Node[] nodes = this.getNodes();
        int nodesIndex = 0;
        int index = 0;
        while (index < nodesToRemove.length) {
            TestsuiteNode node = (TestsuiteNode)nodes[nodesIndex];
            Report report = node.getReport();
            if (report != null) {
                if (!report.containsFailed()) {
                    nodesToRemove[index++] = node;
                } else {
                    node.setFiltered(this.filtered);
                }
            }
            ++nodesIndex;
        }
        while (nodesIndex < nodes.length) {
            Report report;
            assert ((report = ((TestsuiteNode)nodes[nodesIndex]).getReport()) == null || report.containsFailed());
            ((TestsuiteNode)nodes[nodesIndex++]).setFiltered(this.filtered);
        }
        this.remove(nodesToRemove);
    }

    private void addPassedSuites() {
        assert (EventQueue.isDispatchThread());
        assert (this.live);
        this.removeAllNodes();
        this.addAllMatchingNodes();
    }
}

