/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;

public class HTMLCompletionResultItemPaintComponent
extends JPanel {
    static final String PACKAGE = "org/netbeans/modules/editor/resources/completion/defaultFolder.gif";
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int iconTextGap = 5;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static String str;
    private static final String[] frequentWords;
    public static final Color KEYWORD_COLOR;
    public static final Color TYPE_COLOR;

    public HTMLCompletionResultItemPaintComponent() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    public void setString(String str) {
        HTMLCompletionResultItemPaintComponent.str = str;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    protected void setDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    protected Icon getIcon() {
        return null;
    }

    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        this.draw(g);
    }

    protected void draw(Graphics g) {
    }

    protected void drawIcon(Graphics g, Icon icon) {
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX = i.left;
            this.drawY = i.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (g != null) {
                icon.paintIcon(this, g, this.drawX, this.drawY);
            }
            this.drawX += icon.getIconWidth() + this.iconTextGap;
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        if (i != null) {
            this.drawHeight += i.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics g, String s) {
        this.drawString(g, s, false);
    }

    protected void drawString(Graphics g, String s, boolean strike) {
        if (g != null) {
            g.setColor(this.getForeground());
        }
        this.drawStringToGraphics(g, s, null, strike);
    }

    protected void drawString(Graphics g, String s, Color c) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
        }
        this.drawStringToGraphics(g, s);
    }

    protected void drawString(Graphics g, String s, Color c, Font font, boolean strike) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
            g.setFont(font);
        }
        this.drawStringToGraphics(g, s, font, strike);
        if (g != null) {
            g.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics g, String s, Color c) {
        if (g == null) {
            this.drawString(g, "   ");
            this.drawString(g, s, c);
        } else {
            int spaceWidth;
            int w = this.getWidth() - this.getWidth(s) - this.drawX;
            if (w > (spaceWidth = this.getWidth(" ")) * 2) {
                this.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s);
            } else {
                this.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s) - this.getWidth("...   ");
                g.setColor(this.getBackground());
                g.fillRect(this.drawX, 0, this.getWidth() - this.drawX, this.getHeight());
                this.drawString(g, "...   ", c);
            }
            this.drawString(g, s, c);
        }
    }

    protected void drawStringToGraphics(Graphics g, String s) {
        this.drawStringToGraphics(g, s, null, false);
    }

    protected void drawStringToGraphics(Graphics g, String s, Font font, boolean strike) {
        if (g != null) {
            if (!strike) {
                g.drawString(s, this.drawX, this.drawY);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AttributedString strikeText = new AttributedString(s);
                strikeText.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                strikeText.addAttribute(TextAttribute.FONT, g.getFont());
                g2.drawString(strikeText.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(s, font);
    }

    protected int getWidth(String s) {
        Integer i = (Integer)this.widths.get(s);
        if (i != null) {
            return i;
        }
        if (s == null) {
            s = "";
        }
        return this.fontMetrics.stringWidth(s);
    }

    protected int getWidth(String s, Font font) {
        if (font == null) {
            return this.getWidth(s);
        }
        return this.getFontMetrics(font).stringWidth(s);
    }

    protected Color getColor(String s, Color defaultColor) {
        return this.isSelected ? this.getForeground() : defaultColor;
    }

    private void storeWidth(String s) {
        this.fontMetrics.stringWidth(s);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX += i.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    static {
        frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", THROWS};
        KEYWORD_COLOR = Color.darkGray;
        TYPE_COLOR = Color.black;
    }

    public static class StringPaintComponent
    extends HTMLCompletionResultItemPaintComponent {
        private Color c;

        public StringPaintComponent(Color c) {
            this.c = c;
        }

        protected void draw(Graphics g) {
            this.drawIcon(g, this.getIcon());
            this.drawString(g, str, this.c);
        }
    }
}

