/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.ModeStructureSnapshot;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.model.EditorSplitSubModel;
import org.netbeans.core.windows.model.Model;
import org.netbeans.core.windows.model.ModelElement;
import org.netbeans.core.windows.model.SplitSubModel;

final class ModesSubModel {
    private final Model parentModel;
    private final Set modes = new HashSet(10);
    private final EditorSplitSubModel editorSplitSubModel;
    private final HashMap slidingModes2Sides = new HashMap(5);
    private final HashMap slidingSides2Modes = new HashMap(5);
    private ModeImpl activeMode;
    private ModeImpl maximizedMode;

    public ModesSubModel(Model parentModel) {
        this.parentModel = parentModel;
        this.editorSplitSubModel = new EditorSplitSubModel(parentModel, new SplitSubModel(parentModel));
    }

    public void setEditorAreaConstraints(SplitConstraint[] editorAreaConstraints) {
        this.editorSplitSubModel.setEditorNodeConstraints(editorAreaConstraints);
    }

    public SplitConstraint[] getModelElementConstraints(ModelElement element) {
        return this.editorSplitSubModel.getModelElementConstraints(element);
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.editorSplitSubModel.getEditorNodeConstraints();
    }

    public SplitConstraint[] getModeConstraints(ModeImpl mode) {
        if (mode.getKind() == 1) {
            return this.editorSplitSubModel.getEditorArea().getModeConstraints(mode);
        }
        return this.editorSplitSubModel.getModeConstraints(mode);
    }

    public String getSlidingModeConstraints(ModeImpl mode) {
        return (String)this.slidingModes2Sides.get(mode);
    }

    public ModeImpl getSlidingMode(String side) {
        return (ModeImpl)this.slidingSides2Modes.get(side);
    }

    public Set getSlidingModes() {
        return Collections.unmodifiableSet(this.slidingModes2Sides.keySet());
    }

    public boolean addMode(ModeImpl mode, SplitConstraint[] constraints) {
        if (this.modes.contains(mode)) {
            return false;
        }
        boolean result = mode.getKind() == 1 ? this.editorSplitSubModel.getEditorArea().addMode(mode, constraints) : this.editorSplitSubModel.addMode(mode, constraints);
        if (result) {
            this.modes.add(mode);
        }
        return result;
    }

    public boolean addModeToSide(ModeImpl mode, ModeImpl attachMode, String side) {
        if (this.modes.contains(mode)) {
            return false;
        }
        boolean result = mode.getKind() == 1 ? this.editorSplitSubModel.getEditorArea().addModeToSide(mode, attachMode, side) : this.editorSplitSubModel.addModeToSide(mode, attachMode, side);
        if (result) {
            this.modes.add(mode);
        }
        return result;
    }

    public boolean addModeAround(ModeImpl mode, String side) {
        if (this.modes.contains(mode)) {
            return false;
        }
        boolean result = mode.getKind() == 1 ? false : this.editorSplitSubModel.addModeAround(mode, side);
        if (result) {
            this.modes.add(mode);
        }
        return result;
    }

    public boolean addModeAroundEditor(ModeImpl mode, String side) {
        if (this.modes.contains(mode)) {
            return false;
        }
        boolean result = mode.getKind() == 1 ? false : this.editorSplitSubModel.addModeAroundEditor(mode, side);
        if (result) {
            this.modes.add(mode);
        }
        return result;
    }

    public boolean addModeSliding(ModeImpl mode, String side) {
        if (this.modes.contains(mode) || mode.getKind() != 2) {
            return false;
        }
        this.slidingModes2Sides.put(mode, side);
        this.slidingSides2Modes.put(side, mode);
        this.modes.add(mode);
        return true;
    }

    public boolean removeMode(ModeImpl mode) {
        int kind = mode.getKind();
        if (kind == 2) {
            return true;
        }
        this.modes.remove(mode);
        if (mode.getKind() == 1) {
            return this.editorSplitSubModel.getEditorArea().removeMode(mode);
        }
        return this.editorSplitSubModel.removeMode(mode);
    }

    public boolean setActiveMode(ModeImpl activeMode) {
        if (activeMode == null || this.modes.contains(activeMode)) {
            this.activeMode = activeMode;
            return true;
        }
        return false;
    }

    public ModeImpl getActiveMode() {
        return this.activeMode;
    }

    public boolean setMaximizedMode(ModeImpl maximizedMode) {
        if (maximizedMode == null || this.modes.contains(maximizedMode)) {
            this.maximizedMode = maximizedMode;
            return true;
        }
        return false;
    }

    public ModeImpl getMaximizedMode() {
        return this.maximizedMode;
    }

    public Set getModes() {
        return new HashSet(this.modes);
    }

    public void setSplitWeights(ModelElement[] snapshots, double[] splitWeights) {
        this.editorSplitSubModel.setSplitWeights(snapshots, splitWeights);
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()) + "\n" + this.editorSplitSubModel;
    }

    public ModeStructureSnapshot.ElementSnapshot createSplitSnapshot() {
        return this.editorSplitSubModel.createSplitSnapshot();
    }

    public Set createSeparateModeSnapshots() {
        HashSet s = new HashSet();
        if (this.parentModel.getEditorAreaState() == 0) {
            return s;
        }
        s.addAll(this.editorSplitSubModel.createSeparateSnapshots());
        return s;
    }

    public Set createSlidingModeSnapshots() {
        HashSet<ModeStructureSnapshot.SlidingModeSnapshot> result = new HashSet<ModeStructureSnapshot.SlidingModeSnapshot>();
        Iterator iter = this.slidingModes2Sides.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry curEntry = iter.next();
            result.add(new ModeStructureSnapshot.SlidingModeSnapshot((ModeImpl)curEntry.getKey(), (String)curEntry.getValue()));
        }
        return result;
    }

    public ModeImpl getModeForOriginator(ModelElement originator) {
        ModeImpl mode = this.editorSplitSubModel.getModeForOriginator(originator);
        if (this.modes.contains(mode)) {
            return mode;
        }
        return null;
    }
}

