/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerCompile;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerJar;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerJavadoc;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerSources;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.modules.java.j2seproject.wsclient.CustomizerWSClientHost;
import org.netbeans.modules.java.j2seproject.wsclient.NoWebServiceClientsPanel;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CustomizerProviderImpl
implements CustomizerProvider {
    private final Project project;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFileHelper;
    private ProjectCustomizer.Category[] categories;
    private ProjectCustomizer.CategoryComponentProvider panelProvider;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private static Map project2Dialog = new HashMap();
    private static final String BUILD_CATEGORY = "BuildCategory";
    private static final String RUN_CATEGORY = "RunCategory";
    private static final String GENERAL = "General";
    private static final String SOURCES = "Sources";
    private static final String LIBRARIES = "Libraries";
    private static final String BUILD = "Build";
    private static final String BUILD_TESTS = "BuildTests";
    private static final String JAR = "Jar";
    private static final String JAVADOC = "Javadoc";
    private static final String RUN = "Run";
    private static final String RUN_TESTS = "RunTests";
    private static final String WEBSERVICECLIENTS = "WebServiceClients";
    private static final String WEBSERVICE_CATEGORY = "WebServiceCategory";

    public CustomizerProviderImpl(Project project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper refHelper, GeneratedFilesHelper genFileHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.genFileHelper = genFileHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(null);
    }

    public void showCustomizer(String preselectedCategory) {
        this.showCustomizer(preselectedCategory, null);
    }

    public void showCustomizer(String preselectedCategory, String preselectedSubCategory) {
        Dialog dialog = (Dialog)project2Dialog.get(this.project);
        if (dialog != null) {
            dialog.show();
            return;
        }
        J2SEProjectProperties uiProperties = new J2SEProjectProperties((J2SEProject)this.project, this.updateHelper, this.evaluator, this.refHelper, this.genFileHelper);
        this.init(uiProperties);
        OptionListener listener = new OptionListener(this.project, uiProperties);
        if (preselectedCategory != null && preselectedSubCategory != null) {
            for (int i = 0; i < this.categories.length; ++i) {
                if (!preselectedCategory.equals(this.categories[i].getName())) continue;
                JComponent component = this.panelProvider.create(this.categories[i]);
                if (!(component instanceof SubCategoryProvider)) break;
                ((SubCategoryProvider)((Object)component)).showSubCategory(preselectedSubCategory);
                break;
            }
        }
        dialog = ProjectCustomizer.createCustomizerDialog((ProjectCustomizer.Category[])this.categories, (ProjectCustomizer.CategoryComponentProvider)this.panelProvider, (String)preselectedCategory, (ActionListener)listener, null);
        dialog.addWindowListener(listener);
        dialog.setTitle(MessageFormat.format(NbBundle.getMessage((Class)CustomizerProviderImpl.class, (String)"LBL_Customizer_Title"), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        project2Dialog.put(this.project, dialog);
        dialog.show();
    }

    private void init(J2SEProjectProperties uiProperties) {
        ResourceBundle bundle = NbBundle.getBundle((Class)CustomizerProviderImpl.class);
        ProjectCustomizer.Category sources = ProjectCustomizer.Category.create((String)SOURCES, (String)bundle.getString("LBL_Config_Sources"), null, null);
        ProjectCustomizer.Category libraries = ProjectCustomizer.Category.create((String)LIBRARIES, (String)bundle.getString("LBL_Config_Libraries"), null, null);
        ProjectCustomizer.Category build = ProjectCustomizer.Category.create((String)BUILD, (String)bundle.getString("LBL_Config_Build"), null, null);
        ProjectCustomizer.Category jar = ProjectCustomizer.Category.create((String)JAR, (String)bundle.getString("LBL_Config_Jar"), null, null);
        ProjectCustomizer.Category javadoc = ProjectCustomizer.Category.create((String)JAVADOC, (String)bundle.getString("LBL_Config_Javadoc"), null, null);
        ProjectCustomizer.Category run = ProjectCustomizer.Category.create((String)RUN, (String)bundle.getString("LBL_Config_Run"), null, null);
        ProjectCustomizer.Category runTests = ProjectCustomizer.Category.create((String)RUN_TESTS, (String)bundle.getString("LBL_Config_Test"), null, null);
        ProjectCustomizer.Category buildCategory = ProjectCustomizer.Category.create((String)BUILD_CATEGORY, (String)bundle.getString("LBL_Config_BuildCategory"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[]{build, jar, javadoc});
        ProjectCustomizer.Category webServices = null;
        ProjectCustomizer.Category clients = null;
        List serviceClientsSettings = null;
        WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.project.getProjectDirectory());
        if (clientSupport != null) {
            serviceClientsSettings = clientSupport.getServiceClients();
        }
        if (serviceClientsSettings != null && serviceClientsSettings.size() > 0) {
            clients = ProjectCustomizer.Category.create((String)WEBSERVICECLIENTS, (String)bundle.getString("LBL_Config_WebServiceClients"), null, null);
            webServices = ProjectCustomizer.Category.create((String)WEBSERVICE_CATEGORY, (String)bundle.getString("LBL_Config_WebServices"), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[]{clients});
            this.categories = new ProjectCustomizer.Category[]{sources, libraries, buildCategory, run, webServices};
        } else {
            this.categories = new ProjectCustomizer.Category[]{sources, libraries, buildCategory, run};
        }
        HashMap<ProjectCustomizer.Category, JPanel> panels = new HashMap<ProjectCustomizer.Category, JPanel>();
        panels.put(sources, new CustomizerSources(uiProperties));
        panels.put(libraries, new CustomizerLibraries(uiProperties));
        panels.put(build, new CustomizerCompile(uiProperties));
        panels.put(jar, new CustomizerJar(uiProperties));
        panels.put(javadoc, new CustomizerJavadoc(uiProperties));
        panels.put(run, new CustomizerRun(uiProperties));
        if (serviceClientsSettings != null && serviceClientsSettings.size() > 0) {
            panels.put(clients, new CustomizerWSClientHost(uiProperties, serviceClientsSettings));
        } else {
            panels.put(clients, new NoWebServiceClientsPanel());
        }
        this.panelProvider = new PanelProvider(panels);
    }

    static interface SubCategoryProvider {
        public void showSubCategory(String var1);
    }

    private class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private Project project;
        private J2SEProjectProperties uiProperties;

        OptionListener(Project project, J2SEProjectProperties uiProperties) {
            this.project = project;
            this.uiProperties = uiProperties;
        }

        public void actionPerformed(ActionEvent e) {
            this.uiProperties.save();
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.hide();
                dialog.dispose();
            }
        }

        public void windowClosed(WindowEvent e) {
            project2Dialog.remove(this.project);
        }

        public void windowClosing(WindowEvent e) {
            Dialog dialog = (Dialog)project2Dialog.get(this.project);
            if (dialog != null) {
                dialog.hide();
                dialog.dispose();
            }
        }
    }

    private static class PanelProvider
    implements ProjectCustomizer.CategoryComponentProvider {
        private JPanel EMPTY_PANEL = new JPanel();
        private Map panels;

        PanelProvider(Map panels) {
            this.panels = panels;
        }

        public JComponent create(ProjectCustomizer.Category category) {
            JComponent panel = (JComponent)this.panels.get(category);
            return panel == null ? this.EMPTY_PANEL : panel;
        }
    }
}

