/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.core.Utilities;
import org.netbeans.modules.websvc.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.customization.model.JavaClass;
import org.netbeans.modules.websvc.customization.model.ServiceCustomization;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.WeakListeners;

public class ServicePanel
extends SaveableSectionInnerPanel {
    private Service service;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener itemListener;
    private JCheckBox defaultJavaClassCB;
    private JLabel javaClassLabel;
    private JTextField javaClassText;

    public ServicePanel(SectionView view, Service service) {
        super(view);
        this.service = service;
        this.model = this.service.getModel();
        this.initComponents();
        this.javaClassLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.javaClassText.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.defaultJavaClassCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
        this.itemListener = new DefaultItemListener();
        ItemListener il = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.itemListener, (Object)this.defaultJavaClassCB);
        this.defaultJavaClassCB.addItemListener(il);
        this.addModifier(this.javaClassText);
        this.addModifier(this.defaultJavaClassCB);
        this.addValidatee(this.javaClassText);
    }

    private void sync() {
        List ee = this.service.getExtensibilityElements(ServiceCustomization.class);
        if (ee.size() > 0) {
            ServiceCustomization sc = (ServiceCustomization)ee.get(0);
            JavaClass jc = sc.getJavaClass();
            if (jc != null) {
                this.setJavaClass(jc.getName());
            } else {
                this.defaultJavaClassCB.setSelected(true);
                this.javaClassText.setEnabled(false);
                this.javaClassText.setBackground(Color.LIGHT_GRAY);
            }
        } else {
            this.defaultJavaClassCB.setSelected(true);
            this.javaClassText.setEnabled(false);
            this.javaClassText.setBackground(Color.LIGHT_GRAY);
        }
    }

    public void setJavaClass(String name) {
        this.javaClassText.setText(name);
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List ee = this.service.getExtensibilityElements(ServiceCustomization.class);
        CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.javaClassText || jComponent == this.defaultJavaClassCB) {
            ServiceCustomization sc;
            JavaClass jc;
            String text = this.javaClassText.getText();
            if (text != null && !text.trim().equals("") && !this.defaultJavaClassCB.isSelected()) {
                if (!Utilities.isJavaIdentifier((String)text)) {
                    return;
                }
                if (ee.size() == 1) {
                    ServiceCustomization sc2 = (ServiceCustomization)ee.get(0);
                    JavaClass jc2 = sc2.getJavaClass();
                    if (jc2 == null) {
                        try {
                            jc2 = factory.createJavaClass(this.model);
                            this.model.startTransaction();
                            jc2.setName(text);
                            sc2.setJavaClass(jc2);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    } else {
                        try {
                            this.model.startTransaction();
                            jc2.setName(text);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else {
                    ServiceCustomization sc3 = factory.createServiceCustomization(this.model);
                    JavaClass jc3 = factory.createJavaClass(this.model);
                    try {
                        this.model.startTransaction();
                        jc3.setName(text);
                        sc3.setJavaClass(jc3);
                        this.service.addExtensibilityElement((ExtensibilityElement)sc3);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (ee.size() == 1 && (jc = (sc = (ServiceCustomization)ee.get(0)).getJavaClass()) != null) {
                try {
                    this.model.startTransaction();
                    sc.removeJavaClass(jc);
                    if (sc.getChildren().size() == 0) {
                        this.service.removeExtensibilityElement((ExtensibilityElement)sc);
                    }
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public void documentChanged(JTextComponent comp, String val) {
        if (comp == this.javaClassText && !Utilities.isJavaIdentifier((String)val)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, val, (JComponent)comp));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.javaClassText) {
            ServiceCustomization sc;
            JavaClass jc;
            String className = "";
            List ee = this.service.getExtensibilityElements(ServiceCustomization.class);
            if (ee.size() == 1 && (jc = (sc = (ServiceCustomization)ee.get(0)).getJavaClass()) != null) {
                className = jc.getName();
            }
            this.javaClassText.setText(className);
        }
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.javaClassLabel = new JLabel();
        this.javaClassText = new JTextField();
        this.defaultJavaClassCB = new JCheckBox();
        this.javaClassLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_JAVA_CLASS"));
        this.javaClassLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_JAVA_CLASS"));
        this.javaClassText.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("TOOLTIP_SERVICE_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_JAVA_CLASS"));
        this.javaClassText.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_JAVA_CLASS"));
        this.defaultJavaClassCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultJavaClassCB.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultJavaClassCB.setMargin(new Insets(0, 0, 0, 0));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        this.defaultJavaClassCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.javaClassLabel).add(21, 21, 21).add((Component)this.javaClassText, -2, 172, -2).add(20, 20, 20).add((Component)this.defaultJavaClassCB).addContainerGap(70, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(31, 31, 31).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.javaClassLabel).add((Component)this.javaClassText, -2, -1, -2).add((Component)this.defaultJavaClassCB)).addContainerGap(29, Short.MAX_VALUE)));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (ServicePanel.this.defaultJavaClassCB.isSelected()) {
                ServicePanel.this.javaClassText.setEnabled(false);
                ServicePanel.this.javaClassText.setBackground(Color.LIGHT_GRAY);
            } else {
                ServicePanel.this.javaClassText.setEnabled(true);
                ServicePanel.this.javaClassText.setBackground(Color.WHITE);
                ServicePanel.this.javaClassText.requestFocus();
            }
        }
    }
}

