/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeAppProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class Utils {
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";

    public static String toClasspathString(File[] classpathEntries) {
        if (classpathEntries == null) {
            return "";
        }
        StringBuffer classpath = new StringBuffer();
        for (int i = 0; i < classpathEntries.length; ++i) {
            classpath.append(classpathEntries[i].getAbsolutePath());
            if (i + 1 >= classpathEntries.length) continue;
            classpath.append(":");
        }
        return classpath.toString();
    }

    public static void notifyError(Exception ex) {
        NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
    }

    public static void mergeSteps(WizardDescriptor wizard, WizardDescriptor.Panel[] panels, String[] steps) {
        int offset;
        String[] beforeSteps;
        Object prop = wizard.getProperty(WIZARD_PANEL_CONTENT_DATA);
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
            offset = beforeSteps.length;
            if (offset > 0 && "...".equals(beforeSteps[offset - 1])) {
                --offset;
            }
        } else {
            beforeSteps = null;
            offset = 0;
        }
        String[] resultSteps = new String[offset + panels.length];
        for (int i = 0; i < offset; ++i) {
            resultSteps[i] = beforeSteps[i];
        }
        Utils.setSteps(panels, steps, resultSteps, offset);
    }

    private static void setSteps(WizardDescriptor.Panel[] panels, String[] steps, String[] resultSteps, int offset) {
        int n = steps == null ? 0 : steps.length;
        for (int i = 0; i < panels.length; ++i) {
            String step;
            JComponent component = (JComponent)panels[i].getComponent();
            String string = step = i < n ? steps[i] : null;
            if (step == null) {
                step = component.getName();
            }
            component.putClientProperty(WIZARD_PANEL_CONTENT_DATA, resultSteps);
            component.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, new Integer(i));
            component.getAccessibleContext().setAccessibleDescription(step);
            resultSteps[i + offset] = step;
        }
    }

    public static void setSteps(WizardDescriptor.Panel[] panels, String[] steps) {
        Utils.setSteps(panels, steps, steps, 0);
    }

    public static boolean isModified(JavaClass ce) {
        DataObject dataObject = JavaMetamodel.getManager().getDataObject(ce.getResource());
        assert (dataObject != null) : "DataObject not found for " + ce.getName();
        return dataObject.isModified();
    }

    public static boolean areInSameJ2EEApp(Project p1, Project p2) {
        Set globalPath = GlobalPathRegistry.getDefault().getSourceRoots();
        for (FileObject sourceRoot : globalPath) {
            List<J2eeModuleProvider> childModules;
            J2eeAppProvider j2eeApp;
            J2eeModuleProvider[] j2eeModules;
            Object j2eeAppProvider;
            Project project = FileOwnerQuery.getOwner((FileObject)sourceRoot);
            if (project == null || (j2eeAppProvider = project.getLookup().lookup(J2eeAppProvider.class)) == null || (j2eeModules = (j2eeApp = (J2eeAppProvider)j2eeAppProvider).getChildModuleProviders()) == null || j2eeModules.length <= 0) continue;
            J2eeModuleProvider affectedPrjProvider1 = (J2eeModuleProvider)p1.getLookup().lookup(J2eeModuleProvider.class);
            J2eeModuleProvider affectedPrjProvider2 = (J2eeModuleProvider)p2.getLookup().lookup(J2eeModuleProvider.class);
            if (affectedPrjProvider1 == null || affectedPrjProvider2 == null || !(childModules = Arrays.asList(j2eeModules)).contains(affectedPrjProvider1) || !childModules.contains(affectedPrjProvider2)) continue;
            return true;
        }
        return false;
    }

    public static Project[] getCallableEjbProjects(Project enterpriseProject) {
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        boolean isCallerEJBModule = false;
        J2eeModuleProvider callerJ2eeModuleProvider = (J2eeModuleProvider)enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
        if (callerJ2eeModuleProvider != null && callerJ2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
            isCallerEJBModule = true;
        }
        boolean isCallerFreeform = enterpriseProject.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        ArrayList<Project> filteredResults = new ArrayList<Project>(allProjects.length);
        for (int i = 0; i < allProjects.length; ++i) {
            boolean isEJBModule = false;
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)allProjects[i].getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null && j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
                isEJBModule = true;
            }
            if ((!isEJBModule || isCallerFreeform) && (!isCallerFreeform || !enterpriseProject.equals(allProjects[i]))) continue;
            filteredResults.add(allProjects[i]);
        }
        return filteredResults.toArray(new Project[filteredResults.size()]);
    }

    public static JavaClass findClass(String className) {
        JavaClass result = (JavaClass)Utils.resolveType(className);
        return result instanceof UnresolvedClass ? null : result;
    }

    public static Type resolveType(String typeName) {
        Type basicType;
        Type type = JavaModel.getDefaultExtent().getType().resolve(typeName);
        if (type instanceof UnresolvedClass && !((basicType = JavaModel.getDefaultExtent().getType().resolve("java.lang." + typeName)) instanceof UnresolvedClass)) {
            return basicType;
        }
        return type;
    }
}

