/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui;

import java.awt.Dialog;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.common.ui.BrokenServerAlertPanel;
import org.netbeans.modules.j2ee.common.ui.J2EEUISettings;
import org.netbeans.modules.j2ee.common.ui.NoSelectedServerWarning;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class BrokenServerSupport {
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;

    private BrokenServerSupport() {
    }

    public static boolean isBroken(String serverInstanceID) {
        return Deployment.getDefault().getServerID(serverInstanceID) == null;
    }

    public static String selectServer(String j2eeSpec, Object moduleType) {
        return NoSelectedServerWarning.selectServerDialog(new Object[]{moduleType}, j2eeSpec, NbBundle.getMessage(BrokenServerSupport.class, (String)"LBL_Resolve_Missing_Server_Title"), NbBundle.getMessage(BrokenServerSupport.class, (String)"ACSD_Resolve_Missing_Server"));
    }

    public static synchronized void showAlert() {
        if (Boolean.getBoolean("j2eeserver.no.server.instance.check")) {
            return;
        }
        if (brokenAlertShown || brokenAlertLastTime + (long)BROKEN_ALERT_TIMEOUT > System.currentTimeMillis() || !J2EEUISettings.getDefault().isShowAgainBrokenServerAlert()) {
            return;
        }
        brokenAlertShown = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    BrokenServerAlertPanel alert = new BrokenServerAlertPanel();
                    JButton close = new JButton(NbBundle.getMessage(BrokenServerSupport.class, (String)"LBL_BrokenServerCustomizer_Close"));
                    close.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrokenServerSupport.class, (String)"ACSD_BrokenServerCustomizer_Close"));
                    DialogDescriptor dd = new DialogDescriptor((Object)alert, NbBundle.getMessage(BrokenServerAlertPanel.class, (String)"MSG_Broken_Server_Title"), true, new Object[]{close}, (Object)close, 0, null, null);
                    dd.setMessageType(2);
                    Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
                    dlg.setVisible(true);
                }
                finally {
                    Class<BrokenServerSupport> clazz = BrokenServerSupport.class;
                    synchronized (BrokenServerSupport.class) {
                        brokenAlertLastTime = System.currentTimeMillis();
                        brokenAlertShown = false;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
        });
    }
}

