/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.upgrade.AutoUpgradePanel;
import org.netbeans.upgrade.ColoringStorage;
import org.netbeans.upgrade.Copy;
import org.netbeans.upgrade.IncludeExclude;
import org.netbeans.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.xml.sax.SAXException;

public final class AutoUpgrade {
    private static final List VERSION_TO_CHECK = Arrays.asList(".netbeans/5.0");

    public static void main(String[] args) throws Exception {
        String[] version = new String[1];
        File sourceFolder = AutoUpgrade.checkPrevious(version);
        if (sourceFolder != null) {
            if (!AutoUpgrade.showUpgradeDialog(sourceFolder)) {
                throw new UserCancelException();
            }
            AutoUpgrade.doUpgrade(sourceFolder, version[0]);
            AutoUpgrade.upgradeBuildProperties(sourceFolder, version);
        }
    }

    private static void upgradeBuildProperties(File sourceFolder, String[] version) throws IOException {
        try {
            float f = Float.parseFloat(version[0]);
            if ((double)f >= 5.0) {
                File userdir = new File(System.getProperty("netbeans.user", ""));
                String[] regexForSelection = new String[]{"^nbplatform[.](?!default[.]netbeans[.]dest[.]dir).+[.].+=.+$"};
                Copy.appendSelectedLines(new File(sourceFolder, "build.properties"), userdir, regexForSelection);
            }
        }
        catch (NumberFormatException nex) {
            return;
        }
    }

    private static File checkPrevious(String[] version) {
        String userHome = System.getProperty("user.home");
        File sourceFolder = null;
        if (userHome != null) {
            File userHomeFile = new File(userHome);
            boolean exists = userHomeFile.isDirectory();
            Iterator it = VERSION_TO_CHECK.iterator();
            while (it.hasNext() && sourceFolder == null) {
                String ver = (String)it.next();
                sourceFolder = new File(userHomeFile.getAbsolutePath(), ver);
                if (sourceFolder.isDirectory()) {
                    version[0] = sourceFolder.getName();
                    break;
                }
                sourceFolder = null;
            }
            return sourceFolder;
        }
        return null;
    }

    private static boolean showUpgradeDialog(File source) {
        Util.setDefaultLookAndFeel();
        JOptionPane p = new JOptionPane(new AutoUpgradePanel(source.getAbsolutePath()), 3, 0);
        JDialog d = p.createDialog(null, NbBundle.getMessage((Class)AutoUpgrade.class, (String)"MSG_Confirmation_Title"));
        d.setModal(true);
        d.setVisible(true);
        return new Integer(0).equals(p.getValue());
    }

    static void doUpgrade(File source, String oldVersion) throws IOException, PropertyVetoException {
        Set includeExclude;
        File userdir = new File(System.getProperty("netbeans.user", ""));
        try {
            InputStreamReader r = new InputStreamReader(AutoUpgrade.class.getResourceAsStream("copy" + oldVersion), "utf-8");
            includeExclude = IncludeExclude.create(r);
            ((Reader)r).close();
        }
        catch (IOException ex) {
            IOException e = new IOException("Cannot import from version: " + oldVersion);
            e.initCause(ex);
            throw e;
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + oldVersion + ". Importing from " + source + " to " + userdir);
        File oldConfig = new File(source, "config");
        LocalFileSystem lfs = new LocalFileSystem();
        lfs.setRootDirectory(oldConfig);
        XMLFileSystem xmlfs = null;
        try {
            URL url = AutoUpgrade.class.getResource("layer" + oldVersion + ".xml");
            xmlfs = new XMLFileSystem(url);
        }
        catch (SAXException ex) {
            IOException e = new IOException("Cannot import from version: " + oldVersion);
            e.initCause(ex);
            throw e;
        }
        MultiFileSystem old = AutoUpgrade.createLayeredSystem(lfs, xmlfs);
        FileSystem mine = Repository.getDefault().getDefaultFileSystem();
        Copy.copyDeep(old.getRoot(), mine.getRoot(), includeExclude);
    }

    static MultiFileSystem createLayeredSystem(LocalFileSystem lfs, XMLFileSystem xmlfs) {
        MultiFileSystem old = new MultiFileSystem(new FileSystem[]{lfs, xmlfs}){
            {
                this.setPropagateMasks(true);
            }
        };
        return old;
    }

    private static void addColoring(Map m, String name) {
        InputStream is = AutoUpgrade.class.getResourceAsStream("/org/netbeans/upgrade/resources/" + name);
        m.put(name, ColoringStorage.loadColorings(is, name));
    }

    private static void mergeColorings(Map m, String name, Map coloring) {
        Map defaults = (Map)m.get(name);
        if (defaults == null) {
            return;
        }
        Iterator it = coloring.keySet().iterator();
        while (it.hasNext()) {
            String attributeName = (String)it.next();
            AutoUpgrade.mergeAttributes(defaults, attributeName, coloring, attributeName);
        }
    }

    private static void initializeAllLanguages(Map m, Map javaColoring) {
        Map a = (Map)m.get("NetBeans41/defaultColoring.xml");
        AutoUpgrade.mergeAttributes(a, "default", javaColoring, "default");
        AutoUpgrade.mergeAttributes(a, "char", javaColoring, "java-char-literal");
        AutoUpgrade.mergeAttributes(a, "comment", javaColoring, "java-block-comment");
        AutoUpgrade.mergeAttributes(a, "error", javaColoring, "java-errors");
        AutoUpgrade.mergeAttributes(a, "identifier", javaColoring, "java-identifier");
        AutoUpgrade.mergeAttributes(a, "keyword", javaColoring, "java-keywords");
        AutoUpgrade.mergeAttributes(a, "number", javaColoring, "java-numeric-literals");
        AutoUpgrade.mergeAttributes(a, "operator", javaColoring, "java-operators");
        AutoUpgrade.mergeAttributes(a, "string", javaColoring, "java-string-literal");
        AutoUpgrade.mergeAttributes(a, "whitespace", javaColoring, "java-whitespace");
    }

    private static void initializeHighlightings(Map m, Map javaColoring) {
        Map a = (Map)m.get("NetBeans41/editorColoring.xml");
        Iterator it = a.keySet().iterator();
        while (it.hasNext()) {
            String attributeName = (String)it.next();
            AutoUpgrade.mergeAttributes(a, attributeName, javaColoring, attributeName);
        }
    }

    private static void mergeAttributes(Map m1, String n1, Map m2, String n2) {
        SimpleAttributeSet a1 = (SimpleAttributeSet)m1.get(n1);
        SimpleAttributeSet a2 = (SimpleAttributeSet)m2.get(n2);
        if (a2 == null || a1 == null) {
            return;
        }
        a1.addAttributes(a2);
        a1.addAttribute(StyleConstants.NameAttribute, n1);
    }

    private static List getFiles(FileObject folder, int depth, String fileName, String extension) {
        if (depth == 0) {
            FileObject result = folder.getFileObject(fileName, extension);
            if (result == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.singletonList(result);
        }
        Enumeration en = folder.getChildren(false);
        ArrayList result = new ArrayList();
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            if (!fo.isFolder()) continue;
            result.addAll(AutoUpgrade.getFiles(fo, depth - 1, fileName, extension));
        }
        return result;
    }

    private static void copy(FileObject sourceDir, FileObject destDir) throws IOException {
        Enumeration en = sourceDir.getData(false);
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            if (fo.isFolder()) {
                FileObject newDestDir = destDir.createFolder(fo.getName());
                AutoUpgrade.copy(fo, newDestDir);
                continue;
            }
            try {
                FileObject destFile = FileUtil.copyFile((FileObject)fo, (FileObject)destDir, (String)fo.getName(), (String)fo.getExt());
                FileUtil.copyAttributes((FileObject)fo, (FileObject)destFile);
            }
            catch (IOException ex) {
                if (fo.getNameExt().endsWith("_hidden")) continue;
                throw ex;
            }
        }
    }
}

