/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.archive.project.ArchiveProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private ArchiveProject project;
    private static final String TMPPROJ_LIT = "tmpproj";
    private static final String SUBARCHIVES_LIT = "subarchives";

    public ArchiveProjectOperations(ArchiveProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        ArchiveProjectOperations.addFile(projectDirectory, "nbproject", files);
        ArchiveProjectOperations.addFile(projectDirectory, "build.xml", files);
        ArchiveProjectOperations.addFile(projectDirectory, "dist", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        ArchiveProjectOperations.addFile(projectDirectory, TMPPROJ_LIT, files);
        ArchiveProjectOperations.addFile(projectDirectory, SUBARCHIVES_LIT, files);
        ArchiveProjectOperations.addFile(projectDirectory, "setup", files);
        return files;
    }

    public void notifyDeleting() throws IOException {
    }

    public void notifyDeleted() throws IOException {
        if (this.project.getProjectDirectory().getFileObject(TMPPROJ_LIT) == null) {
            this.project.getProjectDirectory().delete();
        }
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(final Project original, File originalPath, final String nueName) {
        if (original == null) {
            return;
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                try {
                    ArchiveProjectOperations.this.copyFilesToNewLocation(nueName, original);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(1, "" + ex);
                }
            }
        });
    }

    private void copyFilesToNewLocation(String nueName, Project original) throws IOException {
        this.project.setName(nueName);
        AntProjectHelper helper = this.project.getAntProjectHelper();
        EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
        helper.putProperties("nbproject/project.properties", projectProps);
        if (!original.getProjectDirectory().equals(this.project.getProjectDirectory())) {
            ArchiveProjectOperations.doCopy(original.getProjectDirectory().getFileObject(TMPPROJ_LIT), this.project.getProjectDirectory());
            FileObject subdir = original.getProjectDirectory().getFileObject(SUBARCHIVES_LIT);
            if (null != subdir) {
                FileObject dest = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)SUBARCHIVES_LIT);
                Enumeration subarchives = subdir.getFolders(false);
                while (subarchives.hasMoreElements()) {
                    FileObject t = (FileObject)subarchives.nextElement();
                    ArchiveProjectOperations.doCopy(t, dest);
                }
            }
        }
    }

    public void notifyMoving() throws IOException {
    }

    public void notifyMoved(final Project original, File originalPath, final String newName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                block11: {
                    try {
                        ArchiveProjectOperations.this.copyFilesToNewLocation(newName, original);
                        FileObject subdir = original.getProjectDirectory().getFileObject(ArchiveProjectOperations.SUBARCHIVES_LIT);
                        if (original.getProjectDirectory().equals(ArchiveProjectOperations.this.project.getProjectDirectory())) break block11;
                        try {
                            if (null != subdir) {
                                subdir.delete();
                            }
                        }
                        catch (IOException ex) {
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        FileObject target = original.getProjectDirectory().getFileObject(ArchiveProjectOperations.TMPPROJ_LIT);
                        if (null != target) {
                            try {
                                target.delete();
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                        }
                        if (null != (target = original.getProjectDirectory())) {
                            try {
                                target.delete();
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                        }
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
            }
        });
    }

    private static void doCopy(FileObject from, FileObject toParent) throws IOException {
        if (null != from) {
            if (from.isFolder()) {
                FileObject copy = FileUtil.createFolder((FileObject)toParent, (String)from.getNameExt());
                FileObject[] kids = from.getChildren();
                for (int i = 0; i < kids.length; ++i) {
                    ArchiveProjectOperations.doCopy(kids[i], copy);
                }
            } else {
                assert (from.isData());
                FileObject target = toParent.getFileObject(from.getName(), from.getExt());
                if (null == target) {
                    FileUtil.copyFile((FileObject)from, (FileObject)toParent, (String)from.getName(), (String)from.getExt());
                }
            }
        }
    }
}

