/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NbPlatformCustomizerHarness
extends JPanel {
    private NbPlatform plaf;
    private JButton browseButton;
    private ButtonGroup buttonGroup;
    private JRadioButton ideButton;
    private JRadioButton otherButton;
    private JTextField otherText;
    private JRadioButton platformButton;
    private JLabel versionLabel;
    private JTextField versionText;

    public NbPlatformCustomizerHarness() {
        this.initComponents();
    }

    void setPlatform(NbPlatform plaf) {
        this.plaf = plaf;
        if (plaf.isDefault()) {
            this.ideButton.setSelected(true);
        } else {
            File harnessLocation = plaf.getHarnessLocation();
            if (harnessLocation.equals(NbPlatform.getDefaultPlatform().getHarnessLocation())) {
                this.ideButton.setSelected(true);
            } else if (harnessLocation.equals(plaf.getBundledHarnessLocation())) {
                this.platformButton.setSelected(true);
            } else {
                this.otherButton.setSelected(true);
            }
        }
        this.update();
        UIUtil.setText(this.otherText, plaf.getHarnessLocation().getAbsolutePath());
    }

    private void update() {
        this.versionText.setText(NbPlatform.getHarnessVersionDisplayName(this.plaf.getHarnessVersion()));
        if (this.plaf.isDefault()) {
            this.platformButton.setEnabled(false);
            this.otherButton.setEnabled(false);
        } else {
            this.platformButton.setEnabled(true);
            this.otherButton.setEnabled(true);
        }
        this.browseButton.setEnabled(this.otherButton.isSelected());
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.ideButton = new JRadioButton();
        this.platformButton = new JRadioButton();
        this.otherButton = new JRadioButton();
        this.otherText = new JTextField();
        this.browseButton = new JButton();
        this.versionLabel = new JLabel();
        this.versionText = new JTextField();
        this.buttonGroup.add(this.ideButton);
        Mnemonics.setLocalizedText((AbstractButton)this.ideButton, (String)NbBundle.getMessage((Class)NbPlatformCustomizerHarness.class, (String)"NbPCH.ideButton"));
        this.ideButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ideButton.setMargin(new Insets(0, 0, 0, 0));
        this.ideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerHarness.this.ideButtonActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.platformButton);
        Mnemonics.setLocalizedText((AbstractButton)this.platformButton, (String)NbBundle.getMessage((Class)NbPlatformCustomizerHarness.class, (String)"NbPCH.platformButton"));
        this.platformButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.platformButton.setMargin(new Insets(0, 0, 0, 0));
        this.platformButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerHarness.this.platformButtonActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.otherButton);
        Mnemonics.setLocalizedText((AbstractButton)this.otherButton, (String)NbBundle.getMessage((Class)NbPlatformCustomizerHarness.class, (String)"NbPCH.otherButton"));
        this.otherButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.otherButton.setMargin(new Insets(0, 0, 0, 0));
        this.otherButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerHarness.this.otherButtonActionPerformed(evt);
            }
        });
        this.otherText.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage((Class)NbPlatformCustomizerHarness.class, (String)"NbPCH.browseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NbPlatformCustomizerHarness.this.browseButtonActionPerformed(evt);
            }
        });
        this.versionLabel.setLabelFor(this.versionText);
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)NbBundle.getMessage((Class)NbPlatformCustomizerHarness.class, (String)"NbPCH.versionLabel"));
        this.versionText.setEditable(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.ideButton).add((Component)this.platformButton).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.otherButton).addPreferredGap(0).add((Component)this.otherText, -1, 220, Short.MAX_VALUE))).addPreferredGap(0).add((Component)this.browseButton)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.versionLabel).addPreferredGap(0).add((Component)this.versionText, -1, 205, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.ideButton).addPreferredGap(0).add((Component)this.platformButton).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.otherButton).add((Component)this.browseButton).add((Component)this.otherText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.versionLabel).add((Component)this.versionText, -2, -1, -2)).addContainerGap(196, Short.MAX_VALUE)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(){

            public void approveSelection() {
                File dir = FileUtil.normalizeFile((File)this.getSelectedFile());
                if (NbPlatform.isHarness(dir)) {
                    super.approveSelection();
                } else {
                    this.setCurrentDirectory(dir);
                }
            }
        };
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jfc, null);
        jfc.setFileSelectionMode(1);
        jfc.setSelectedFile(this.plaf.getHarnessLocation());
        if (jfc.showOpenDialog(this) == 0) {
            try {
                this.plaf.setHarnessLocation(FileUtil.normalizeFile((File)jfc.getSelectedFile()));
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
        }
        this.update();
        UIUtil.setText(this.otherText, this.plaf.getHarnessLocation().getAbsolutePath());
    }

    private void otherButtonActionPerformed(ActionEvent evt) {
        try {
            this.plaf.setHarnessLocation(FileUtil.normalizeFile((File)new File(this.otherText.getText())));
        }
        catch (IOException e) {
            Util.err.notify((Throwable)e);
        }
        this.update();
    }

    private void platformButtonActionPerformed(ActionEvent evt) {
        try {
            this.plaf.setHarnessLocation(this.plaf.getBundledHarnessLocation());
        }
        catch (IOException e) {
            Util.err.notify((Throwable)e);
        }
        this.update();
    }

    private void ideButtonActionPerformed(ActionEvent evt) {
        try {
            this.plaf.setHarnessLocation(NbPlatform.getDefaultPlatform().getHarnessLocation());
        }
        catch (IOException e) {
            Util.err.notify((Throwable)e);
        }
        this.update();
    }
}

