/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModuleFilter;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class AddModulePanel
extends JPanel {
    private static final String FILTER_DESCRIPTION = AddModulePanel.getMessage("LBL_FilterDescription");
    private CustomizerComponentFactory.DependencyListModel universeModules;
    private RequestProcessor.Task filterTask;
    private AddModuleFilter filterer;
    private URL currectJavadoc;
    private final SingleModuleProperties props;
    private JLabel descLabel;
    private JTextPane descValue;
    private JScrollPane descValueSP;
    private JLabel filter;
    JTextField filterValue;
    private JLabel moduleLabel;
    JList moduleList;
    private JScrollPane moduleSP;
    private JButton showJavadocButton;
    private JCheckBox showNonAPIModules;

    public AddModulePanel(final SingleModuleProperties props) {
        this.props = props;
        this.initComponents();
        this.initAccessibility();
        this.filterValue.setText(FILTER_DESCRIPTION);
        this.fillUpUniverseModules();
        this.moduleList.setCellRenderer(CustomizerComponentFactory.getDependencyCellRenderer(false));
        this.moduleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AddModulePanel.this.showDescription();
                AddModulePanel.this.currectJavadoc = null;
                ModuleDependency[] deps = AddModulePanel.this.getSelectedDependencies();
                if (deps.length == 1) {
                    NbPlatform platform = props.getActivePlatform();
                    if (platform == null) {
                        AddModulePanel.this.currectJavadoc = Util.findJavadocForNetBeansOrgModules(deps[0]);
                    } else {
                        AddModulePanel.this.currectJavadoc = Util.findJavadoc(deps[0], platform);
                    }
                }
                AddModulePanel.this.showJavadocButton.setEnabled(AddModulePanel.this.currectJavadoc != null);
            }
        });
        this.filterValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                if (!FILTER_DESCRIPTION.equals(AddModulePanel.this.filterValue.getText())) {
                    AddModulePanel.this.search();
                }
            }
        });
        String[][] listNavCommands = new String[][]{{"selectPreviousRow", "selectPreviousRow"}, {"selectNextRow", "selectNextRow"}, {"selectFirstRow", "selectFirstRow"}, {"selectLastRow", "selectLastRow"}, {"scrollUp", "scrollUp"}, {"scrollDown", "scrollDown"}};
        String[][] areaNavCommands = new String[][]{{"selection-page-up", "page-up"}, {"selection-page-down", "page-down"}, {"selection-up", "caret-up"}, {"selection-down", "caret-down"}};
        AddModulePanel.exchangeCommands(listNavCommands, this.moduleList, this.filterValue);
        AddModulePanel.exchangeCommands(areaNavCommands, this.descValue, this.filterValue);
    }

    private static void exchangeCommands(String[][] commandsToExchange, final JComponent target, JComponent source) {
        InputMap targetBindings = target.getInputMap();
        KeyStroke[] targetBindingKeys = targetBindings.allKeys();
        ActionMap targetActions = target.getActionMap();
        InputMap sourceBindings = source.getInputMap();
        ActionMap sourceActions = source.getActionMap();
        for (int i = 0; i < commandsToExchange.length; ++i) {
            String commandFrom = commandsToExchange[i][0];
            String commandTo = commandsToExchange[i][1];
            final Action orig = targetActions.get(commandTo);
            if (orig == null) continue;
            sourceActions.put(commandTo, new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    orig.actionPerformed(new ActionEvent(target, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
                }
            });
            for (int j = 0; j < targetBindingKeys.length; ++j) {
                if (!targetBindings.get(targetBindingKeys[j]).equals(commandFrom)) continue;
                sourceBindings.put(targetBindingKeys[j], commandTo);
            }
        }
    }

    private void fillUpUniverseModules() {
        this.filterValue.setEnabled(false);
        this.moduleList.setEnabled(false);
        this.showNonAPIModules.setEnabled(false);
        final String lastFilter = this.filterValue.getText();
        this.filterValue.setText(CustomizerComponentFactory.WAIT_VALUE);
        this.moduleList.setModel(CustomizerComponentFactory.createListWaitModel());
        final boolean nonApiDeps = this.showNonAPIModules.isSelected();
        ModuleProperties.RP.post(new Runnable(){

            public void run() {
                final Set universeDeps = AddModulePanel.this.props.getUniverseDependencies(true, !nonApiDeps);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        AddModulePanel.this.universeModules = CustomizerComponentFactory.createSortedDependencyListModel(universeDeps);
                        AddModulePanel.this.filterer = null;
                        (this).AddModulePanel.this.moduleList.setModel(AddModulePanel.this.universeModules);
                        (this).AddModulePanel.this.moduleList.setEnabled(true);
                        (this).AddModulePanel.this.filterValue.setEnabled(true);
                        AddModulePanel.this.showNonAPIModules.setEnabled(true);
                        (this).AddModulePanel.this.filterValue.setText(lastFilter);
                        if (!FILTER_DESCRIPTION.equals(lastFilter)) {
                            AddModulePanel.this.search();
                        } else {
                            (this).AddModulePanel.this.filterValue.selectAll();
                        }
                        (this).AddModulePanel.this.filterValue.requestFocusInWindow();
                    }
                });
            }
        });
    }

    private void showDescription() {
        StyledDocument doc = this.descValue.getStyledDocument();
        try {
            String filterText;
            doc.remove(0, doc.getLength());
            ModuleDependency[] deps = this.getSelectedDependencies();
            if (deps.length != 1) {
                return;
            }
            String longDesc = deps[0].getModuleEntry().getLongDescription();
            if (longDesc != null) {
                doc.insertString(0, longDesc, null);
            }
            if ((filterText = this.filterValue.getText().trim()).length() != 0 && !FILTER_DESCRIPTION.equals(filterText)) {
                doc.insertString(doc.getLength(), "\n\n", null);
                Style bold = doc.addStyle(null, null);
                bold.addAttribute(StyleConstants.Bold, Boolean.TRUE);
                doc.insertString(doc.getLength(), AddModulePanel.getMessage("TEXT_matching_filter_contents"), bold);
                doc.insertString(doc.getLength(), "\n", null);
                if (filterText.length() > 0) {
                    String filterTextLC = filterText.toLowerCase(Locale.US);
                    Style match = doc.addStyle(null, null);
                    match.addAttribute(StyleConstants.Background, new Color(246, 248, 139));
                    Set matches = this.filterer.getMatchesFor(filterText, deps[0]);
                    Iterator it = matches.iterator();
                    boolean isEven = false;
                    Style even = doc.addStyle(null, null);
                    even.addAttribute(StyleConstants.Background, new Color(235, 235, 235));
                    while (it.hasNext()) {
                        String hit = (String)it.next();
                        int loc = doc.getLength();
                        doc.insertString(loc, hit, isEven ? even : null);
                        int start = hit.toLowerCase(Locale.US).indexOf(filterTextLC);
                        while (start != -1) {
                            doc.setCharacterAttributes(loc + start, filterTextLC.length(), match, true);
                            start = hit.toLowerCase(Locale.US).indexOf(filterTextLC, start + 1);
                        }
                        doc.insertString(doc.getLength(), "\n", isEven ? even : null);
                        isEven ^= true;
                    }
                } else {
                    Style italics = doc.addStyle(null, null);
                    italics.addAttribute(StyleConstants.Italic, Boolean.TRUE);
                    doc.insertString(doc.getLength(), AddModulePanel.getMessage("TEXT_no_filter_specified"), italics);
                }
            }
            this.descValue.setCaretPosition(0);
        }
        catch (BadLocationException e) {
            Util.err.notify(1, (Throwable)e);
        }
    }

    public ModuleDependency[] getSelectedDependencies() {
        ModuleDependency[] deps;
        if (CustomizerComponentFactory.isWaitModel(this.moduleList.getModel())) {
            deps = new ModuleDependency[]{};
        } else {
            Object[] objects = this.moduleList.getSelectedValues();
            deps = new ModuleDependency[objects.length];
            System.arraycopy(objects, 0, deps, 0, objects.length);
        }
        return deps;
    }

    private void search() {
        String text;
        if (this.filterTask != null) {
            this.filterTask.cancel();
            this.filterTask = null;
        }
        if ((text = this.filterValue.getText()).length() == 0) {
            this.moduleList.setModel(this.universeModules);
            this.moduleList.setSelectedIndex(0);
            this.moduleList.ensureIndexIsVisible(0);
        } else {
            final Runnable compute = new Runnable(){

                public void run() {
                    final Set matches = AddModulePanel.this.filterer.getMatches(text);
                    AddModulePanel.this.filterTask = null;
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            if (!text.equals((this).AddModulePanel.this.filterValue.getText())) {
                                return;
                            }
                            (this).AddModulePanel.this.moduleList.setModel(CustomizerComponentFactory.createDependencyListModel(matches));
                            int index = matches.isEmpty() ? -1 : 0;
                            (this).AddModulePanel.this.moduleList.setSelectedIndex(index);
                            (this).AddModulePanel.this.moduleList.ensureIndexIsVisible(index);
                        }
                    });
                }
            };
            if (this.filterer == null) {
                this.moduleList.setModel(CustomizerComponentFactory.createListWaitModel());
                this.filterTask = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (AddModulePanel.this.filterer == null) {
                            AddModulePanel.this.filterer = new AddModuleFilter(AddModulePanel.this.universeModules.getDependencies(), AddModulePanel.this.props.getCodeNameBase());
                            compute.run();
                        }
                    }
                });
            } else {
                compute.run();
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACS_AddModuleDependency"));
        this.filterValue.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACS_LBL_Filter"));
        this.moduleList.getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACS_CTL_ModuleList"));
        this.moduleSP.getVerticalScrollBar().getAccessibleContext().setAccessibleName(AddModulePanel.getMessage("ACS_CTL_ModuleListVerticalScroll"));
        this.moduleSP.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACSD_CTL_ModuleListVerticalScroll"));
        this.moduleSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(AddModulePanel.getMessage("ACS_CTL_ModuleListHorizontalScroll"));
        this.moduleSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleDescription(AddModulePanel.getMessage("ACSD_CTL_ModuleListHorizontalScroll"));
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage((Class)AddModulePanel.class, (String)key);
    }

    private void initComponents() {
        this.moduleLabel = new JLabel();
        this.moduleSP = new JScrollPane();
        this.moduleList = new JList();
        this.descLabel = new JLabel();
        this.filter = new JLabel();
        this.filterValue = new JTextField();
        this.descValueSP = new JScrollPane();
        this.descValue = new JTextPane();
        this.showJavadocButton = new JButton();
        this.showNonAPIModules = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setPreferredSize(new Dimension(400, 400));
        this.moduleLabel.setLabelFor(this.moduleList);
        Mnemonics.setLocalizedText((JLabel)this.moduleLabel, (String)NbBundle.getMessage((Class)AddModulePanel.class, (String)"LBL_Module"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.moduleLabel, gridBagConstraints);
        this.moduleSP.setViewportView(this.moduleList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.moduleSP, gridBagConstraints);
        this.descLabel.setLabelFor(this.descValue);
        Mnemonics.setLocalizedText((JLabel)this.descLabel, (String)NbBundle.getMessage((Class)AddModulePanel.class, (String)"LBL_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.descLabel, gridBagConstraints);
        this.filter.setLabelFor(this.filterValue);
        Mnemonics.setLocalizedText((JLabel)this.filter, (String)NbBundle.getMessage((Class)AddModulePanel.class, (String)"LBL_Filter"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.filter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.filterValue, gridBagConstraints);
        this.descValue.setEditable(false);
        this.descValue.setPreferredSize(new Dimension(6, 100));
        this.descValueSP.setViewportView(this.descValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.descValueSP, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showJavadocButton, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("CTL_ShowJavadoc"));
        this.showJavadocButton.setEnabled(false);
        this.showJavadocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddModulePanel.this.showJavadoc(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.showJavadocButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.showNonAPIModules, (String)NbBundle.getMessage((Class)AddModulePanel.class, (String)"CTL_ShowNonAPIModules"));
        this.showNonAPIModules.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showNonAPIModules.setMargin(new Insets(0, 0, 0, 0));
        this.showNonAPIModules.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddModulePanel.this.showNonAPIModulesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.showNonAPIModules, gridBagConstraints);
    }

    private void showNonAPIModulesActionPerformed(ActionEvent evt) {
        this.fillUpUniverseModules();
    }

    private void showJavadoc(ActionEvent evt) {
        HtmlBrowser.URLDisplayer.getDefault().showURL(this.currectJavadoc);
    }
}

