/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ProjectOperations;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.lookup.Lookups;

public final class SuiteOperations
implements DeleteOperationImplementation,
MoveOperationImplementation {
    private static final Map TEMPORARY_CACHE;
    private final SuiteProject suite;
    private final FileObject projectDir;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SuiteOperations(SuiteProject suite) {
        this.suite = suite;
        this.projectDir = suite.getProjectDirectory();
    }

    public void notifyDeleting() throws IOException {
        FileObject buildXML = this.projectDir.getFileObject("build.xml");
        ActionUtils.runTarget((FileObject)buildXML, (String[])new String[]{"clean"}, null).waitFinished();
        SubprojectProvider spp = (SubprojectProvider)this.suite.getLookup().lookup(SubprojectProvider.class);
        Iterator it = spp.getSubprojects().iterator();
        while (it.hasNext()) {
            NbModuleProject suiteComponent = (NbModuleProject)it.next();
            SuiteUtils.removeModuleFromSuite(suiteComponent);
        }
    }

    public void notifyDeleted() throws IOException {
        this.suite.getHelper().notifyDeleted();
    }

    public void notifyMoving() throws IOException {
        Set subprojects = SuiteUtils.getSubProjects(this.suite);
        if (!subprojects.isEmpty()) {
            TEMPORARY_CACHE.put(ProjectUtils.getInformation((Project)this.suite).getName(), subprojects);
        }
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, String nueName) throws IOException {
        if (original == null) {
            this.suite.getHelper().notifyDeleted();
        } else {
            FileObject origSuiteFO;
            boolean isRename;
            String name = ProjectUtils.getInformation((Project)this.suite).getName();
            Set subprojects = (Set)TEMPORARY_CACHE.remove(name);
            if (subprojects != null) {
                HashSet<Project> toOpen = new HashSet<Project>();
                Iterator it = subprojects.iterator();
                while (it.hasNext()) {
                    boolean directoryChanged;
                    NbModuleProject originalComp = (NbModuleProject)it.next();
                    boolean bl = directoryChanged = !original.getProjectDirectory().equals(this.suite.getProjectDirectory());
                    if (directoryChanged && FileUtil.isParentOf((FileObject)original.getProjectDirectory(), (FileObject)originalComp.getProjectDirectory())) {
                        boolean isOpened = SuiteOperations.isOpened(originalComp);
                        Project nueComp = SuiteOperations.moveModule(originalComp, this.suite.getProjectDirectory());
                        SuiteUtils.addModule(this.suite, (NbModuleProject)nueComp);
                        if (!isOpened) continue;
                        toOpen.add(nueComp);
                        continue;
                    }
                    SuiteUtils.addModule(this.suite, originalComp);
                }
                OpenProjects.getDefault().open(toOpen.toArray(new Project[toOpen.size()]), false);
            }
            if (isRename = original.getProjectDirectory().getParent().equals(this.suite.getProjectDirectory().getParent())) {
                this.setDisplayName(nueName);
            }
            if ((origSuiteFO = FileUtil.toFileObject((File)originalPath)) != null && origSuiteFO.getChildren().length == 0) {
                origSuiteFO.delete();
            }
        }
    }

    public List getMetadataFiles() {
        ArrayList files = new ArrayList();
        this.addFile("build.xml", files);
        this.addFile("nbproject", files);
        this.addFile(".cvsignore", files);
        return files;
    }

    public List getDataFiles() {
        return Collections.EMPTY_LIST;
    }

    private void addFile(String fileName, List result) {
        FileObject file = this.projectDir.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    private void setDisplayName(final String nueName) throws IOException {
        final SuiteProperties sp = new SuiteProperties(this.suite, this.suite.getHelper(), this.suite.getEvaluator(), SuiteUtils.getSubProjects(this.suite));
        final BasicBrandingModel branding = sp.getBrandingModel();
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    if (branding.isBrandingEnabled()) {
                        branding.setTitle(nueName);
                        sp.storeProperties();
                    } else {
                        EditableProperties props = SuiteOperations.this.suite.getHelper().getProperties("nbproject/project.properties");
                        props.setProperty("app.title", nueName);
                        SuiteOperations.this.suite.getHelper().putProperties("nbproject/project.properties", props);
                    }
                    ProjectManager.getDefault().saveProject((Project)SuiteOperations.this.suite);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    static Project moveModule(NbModuleProject original, FileObject targetParent) throws IOException, IllegalArgumentException {
        ProjectOperations.notifyMoving((Project)original);
        SuiteOperations.close(original);
        FileObject origDir = original.getProjectDirectory();
        FileObject copy = SuiteOperations.doCopy(original, origDir, targetParent);
        ProjectManager.getDefault().clearNonProjectCache();
        Project nueComp = ProjectManager.getDefault().findProject(copy);
        if (!$assertionsDisabled && nueComp == null) {
            throw new AssertionError();
        }
        File originalPath = FileUtil.toFile((FileObject)origDir);
        SuiteOperations.doDelete(original, origDir);
        ProjectOperations.notifyMoved((Project)original, (Project)nueComp, (File)originalPath, (String)originalPath.getName());
        return nueComp;
    }

    private static boolean isOpened(Project original) {
        boolean opened = false;
        Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < openProjects.length; ++i) {
            if (openProjects[i] != original) continue;
            opened = true;
            break;
        }
        return opened;
    }

    private static FileObject doCopy(Project original, FileObject from, FileObject toParent) throws IOException {
        FileObject copy;
        if (!VisibilityQuery.getDefault().isVisible(from)) {
            return null;
        }
        if (!original.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)from).getProjectDirectory())) {
            return null;
        }
        if (from.isFolder()) {
            copy = toParent.createFolder(from.getNameExt());
            FileObject[] kids = from.getChildren();
            for (int i = 0; i < kids.length; ++i) {
                SuiteOperations.doCopy(original, kids[i], copy);
            }
        } else {
            if (!$assertionsDisabled && !from.isData()) {
                throw new AssertionError();
            }
            copy = FileUtil.copyFile((FileObject)from, (FileObject)toParent, (String)from.getName(), (String)from.getExt());
        }
        return copy;
    }

    private static boolean doDelete(Project original, FileObject toDelete) throws IOException {
        if (!original.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)toDelete).getProjectDirectory())) {
            return false;
        }
        if (toDelete.isFolder()) {
            FileObject[] kids = toDelete.getChildren();
            boolean delete = true;
            for (int i = 0; i < kids.length; ++i) {
                delete &= SuiteOperations.doDelete(original, kids[i]);
            }
            if (delete) {
                toDelete.delete();
            }
            return delete;
        }
        if (!$assertionsDisabled && !toDelete.isData()) {
            throw new AssertionError();
        }
        toDelete.delete();
        return true;
    }

    private static void close(final Project prj) {
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                LifecycleManager.getDefault().saveAll();
                Action closeAction = CommonProjectActions.closeProjectAction();
                Action action = closeAction = closeAction instanceof ContextAwareAction ? ((ContextAwareAction)closeAction).createContextAwareInstance(Lookups.fixed((Object[])new Object[]{prj})) : null;
                if (closeAction != null && closeAction.isEnabled()) {
                    closeAction.actionPerformed(new ActionEvent(prj, -1, ""));
                } else {
                    OpenProjects.getDefault().close(new Project[]{prj});
                }
                return null;
            }
        });
    }

    static {
        $assertionsDisabled = !SuiteOperations.class.desiredAssertionStatus();
        TEMPORARY_CACHE = new HashMap();
    }
}

