/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesTreeModelFilter;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class NumericDisplayFilter
implements TableModelFilter,
NodeActionsProviderFilter,
Constants {
    private final Map variableToDisplaySettings = new HashMap();
    private HashSet listeners;

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if ((columnID == "WatchValue" || columnID == "LocalsValue") && node instanceof Variable && this.isIntegralType((Variable)node)) {
            Variable var = (Variable)node;
            return this.getValue(var, (NumericDisplaySettings)this.variableToDisplaySettings.get(var));
        }
        return original.getValueAt(node, columnID);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        return original.isReadOnly(node, columnID);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(node, columnID, value);
    }

    public void addModelListener(ModelListener l) {
        HashSet newListeners = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        newListeners.add(l);
        this.listeners = newListeners;
    }

    public void removeModelListener(ModelListener l) {
        if (this.listeners == null) {
            return;
        }
        HashSet newListeners = (HashSet)this.listeners.clone();
        newListeners.remove(l);
        this.listeners = newListeners;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Variable var;
        Action[] actions;
        if (!(node instanceof Variable)) {
            return original.getActions(node);
        }
        try {
            actions = original.getActions(node);
        }
        catch (UnknownTypeException e) {
            actions = new Action[]{};
        }
        ArrayList<Action> myActions = new ArrayList<Action>();
        if (node instanceof Variable && this.isIntegralType(var = (Variable)node)) {
            myActions.add(new DisplayAsAction((Variable)node));
        }
        myActions.addAll(Arrays.asList(actions));
        return myActions.toArray(new Action[myActions.size()]);
    }

    private Object getValue(Variable var, NumericDisplaySettings settings) {
        if (settings == null) {
            return var.getValue();
        }
        String type = var.getType();
        switch (settings.getDisplayAs()) {
            case 0: {
                return var.getValue();
            }
            case 1: {
                if (type.equals("int")) {
                    return "0x" + Integer.toHexString(Integer.parseInt(var.getValue()));
                }
                if (type.equals("short")) {
                    String rv = Integer.toHexString(Short.parseShort(var.getValue()));
                    if (rv.length() > 4) {
                        rv = rv.substring(rv.length() - 4, rv.length());
                    }
                    return "0x" + rv;
                }
                if (type.equals("byte")) {
                    String rv = Integer.toHexString(Byte.parseByte(var.getValue()));
                    if (rv.length() > 2) {
                        rv = rv.substring(rv.length() - 2, rv.length());
                    }
                    return "0x" + rv;
                }
                return "0x" + Long.toHexString(Long.parseLong(var.getValue()));
            }
            case 2: {
                if (type.equals("int")) {
                    return "0" + Integer.toOctalString(Integer.parseInt(var.getValue()));
                }
                if (type.equals("short")) {
                    String rv = Integer.toOctalString(Short.parseShort(var.getValue()));
                    if (rv.length() > 5) {
                        rv = rv.substring(rv.length() - 5, rv.length());
                    }
                    return "0" + (rv.charAt(0) == '0' ? "1" : "") + rv;
                }
                if (type.equals("byte")) {
                    String rv = Integer.toOctalString(Byte.parseByte(var.getValue()));
                    if (rv.length() > 3) {
                        rv = "1" + rv.substring(rv.length() - 2, rv.length());
                    }
                    return "0" + rv;
                }
                return "0" + Long.toOctalString(Long.parseLong(var.getValue()));
            }
            case 3: {
                if (type.equals("int")) {
                    return Integer.toBinaryString(Integer.parseInt(var.getValue()));
                }
                if (type.equals("short")) {
                    String rv = Integer.toBinaryString(Short.parseShort(var.getValue()));
                    if (rv.length() > 16) {
                        rv = rv.substring(rv.length() - 16, rv.length());
                    }
                    return rv;
                }
                if (type.equals("byte")) {
                    String rv = Integer.toBinaryString(Byte.parseByte(var.getValue()));
                    if (rv.length() > 8) {
                        rv = rv.substring(rv.length() - 8, rv.length());
                    }
                    return rv;
                }
                return Long.toBinaryString(Long.parseLong(var.getValue()));
            }
            case 4: {
                try {
                    return "'" + new Character((char)Integer.parseInt(var.getValue())) + "'";
                }
                catch (Exception e) {
                    return "?";
                }
            }
        }
        return var.getValue();
    }

    private boolean isIntegralType(Variable v) {
        if (!VariablesTreeModelFilter.isEvaluated(v)) {
            return false;
        }
        String type = v.getType();
        return type != null && (type.equals("int") || type.equals("char") || type.equals("byte") || type.equals("long") || type.equals("short"));
    }

    private String localize(String s) {
        return NbBundle.getBundle((Class)NumericDisplayFilter.class).getString(s);
    }

    private static class NumericDisplaySettings {
        public static final int DECIMAL = 0;
        public static final int HEXADECIMAL = 1;
        public static final int OCTAL = 2;
        public static final int BINARY = 3;
        public static final int CHAR = 4;
        private int displayAs;

        public NumericDisplaySettings(int displayAs) {
            this.displayAs = displayAs;
        }

        public int getDisplayAs() {
            return this.displayAs;
        }
    }

    private class DisplayAsAction
    extends AbstractAction
    implements Presenter.Popup {
        private Variable variable;

        public DisplayAsAction(Variable variable) {
            this.variable = variable;
        }

        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu displayAsPopup = new JMenu(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Popup"));
            JRadioButtonMenuItem decimalItem = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Decimal")){

                public void actionPerformed(ActionEvent e) {
                    DisplayAsAction.this.onDisplayAs(0);
                }
            });
            JRadioButtonMenuItem hexadecimalItem = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Hexadecimal")){

                public void actionPerformed(ActionEvent e) {
                    DisplayAsAction.this.onDisplayAs(1);
                }
            });
            JRadioButtonMenuItem octalItem = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Octal")){

                public void actionPerformed(ActionEvent e) {
                    DisplayAsAction.this.onDisplayAs(2);
                }
            });
            JRadioButtonMenuItem binaryItem = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Binary")){

                public void actionPerformed(ActionEvent e) {
                    DisplayAsAction.this.onDisplayAs(3);
                }
            });
            JRadioButtonMenuItem charItem = new JRadioButtonMenuItem(new AbstractAction(NumericDisplayFilter.this.localize("CTL_Variable_DisplayAs_Character")){

                public void actionPerformed(ActionEvent e) {
                    DisplayAsAction.this.onDisplayAs(4);
                }
            });
            NumericDisplaySettings lds = (NumericDisplaySettings)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable);
            if (lds != null) {
                switch (lds.getDisplayAs()) {
                    case 0: {
                        decimalItem.setSelected(true);
                        break;
                    }
                    case 1: {
                        hexadecimalItem.setSelected(true);
                        break;
                    }
                    case 2: {
                        octalItem.setSelected(true);
                        break;
                    }
                    case 3: {
                        binaryItem.setSelected(true);
                        break;
                    }
                    case 4: {
                        charItem.setSelected(true);
                    }
                }
            } else {
                decimalItem.setSelected(true);
            }
            displayAsPopup.add(decimalItem);
            displayAsPopup.add(hexadecimalItem);
            displayAsPopup.add(octalItem);
            displayAsPopup.add(binaryItem);
            displayAsPopup.add(charItem);
            return displayAsPopup;
        }

        private void onDisplayAs(int how) {
            NumericDisplaySettings lds = (NumericDisplaySettings)NumericDisplayFilter.this.variableToDisplaySettings.get(this.variable);
            if (lds == null) {
                lds = new NumericDisplaySettings(0);
            }
            if (lds.getDisplayAs() == how) {
                return;
            }
            NumericDisplayFilter.this.variableToDisplaySettings.put(this.variable, new NumericDisplaySettings(how));
            this.fireModelChanged();
        }

        private void fireModelChanged() {
            if (NumericDisplayFilter.this.listeners == null) {
                return;
            }
            ModelEvent.TableValueChanged evt = new ModelEvent.TableValueChanged((Object)this, (Object)this.variable, null);
            Iterator i = NumericDisplayFilter.this.listeners.iterator();
            while (i.hasNext()) {
                ModelListener listener = (ModelListener)i.next();
                listener.modelChanged((ModelEvent)evt);
            }
        }
    }
}

