/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.spi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.TooManyListenersException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public abstract class RelatedItemProviderSupport
implements RelatedItemProvider {
    private RelatedItemProvider.RelatedItemListener listener = null;
    private static final RequestProcessor rp;
    private Updater updater = null;
    private Collection list = Collections.EMPTY_LIST;
    private Object primary = null;
    private RelatedItemProvider eventDelegate = this;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RelatedItemProviderSupport() {
    }

    final void setEventDelegate(RelatedItemProvider eventDelegate) {
        this.eventDelegate = eventDelegate;
    }

    protected abstract Collection collectRelatedItems(Object var1);

    protected abstract Object findPrimaryItem();

    protected abstract void startListening();

    protected abstract void stopListening();

    protected final void change() {
        if (!this.isActive()) {
            return;
        }
        this.updater.start();
    }

    public final synchronized void addRelatedItemListener(RelatedItemProvider.RelatedItemListener l) throws TooManyListenersException {
        if (this.listener != null) {
            throw new TooManyListenersException();
        }
        if (l == null) {
            throw new NullPointerException();
        }
        this.listener = l;
        this.start();
    }

    public final synchronized void removeRelatedItemListener(RelatedItemProvider.RelatedItemListener l) {
        this.listener = null;
        this.stop();
    }

    protected final boolean isActive() {
        return this.listener != null;
    }

    public final boolean isRelated(Object o) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"Not the AWT thread");
        }
        return this.isActive() && this.list != null ? this.list.contains(o) : false;
    }

    public final void reset() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"Not the AWT thread");
        }
        this.list = Collections.EMPTY_LIST;
    }

    public final boolean isPrimary(Object o) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"Not the AWT thread");
        }
        return this.primary == null || !this.isActive() ? false : this.primary.equals(o);
    }

    protected Collection getList() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        return this.list == null ? Collections.EMPTY_SET : Collections.unmodifiableCollection(this.list);
    }

    public final Object getPrimaryItem() {
        return this.primary;
    }

    private void setContents(Collection l, Object primary) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        Collection oldList = this.list;
        this.list = l;
        Object oldPrimary = this.primary;
        this.primary = primary;
        if (oldList != null && this.list != null && !((Object)oldList).equals(this.list) || oldPrimary != primary) {
            this.fire(oldList, this.list, oldPrimary, primary);
        }
    }

    private void fire(Collection old, Collection nue, Object oldPrimary, Object primary) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.isActive()) {
            return;
        }
        RelatedItemProvider.RelatedItemEvent evt = new RelatedItemProvider.RelatedItemEvent(this.eventDelegate, old, nue, oldPrimary, primary);
        if ((nue == null || nue.isEmpty()) && primary == null) {
            this.listener.itemsCleared(evt);
        } else {
            this.listener.itemsChanged(evt);
        }
    }

    private void start() {
        if (!$assertionsDisabled && this.updater != null) {
            throw new AssertionError((Object)"Start called twice");
        }
        this.updater = new Updater();
        this.updater.start();
    }

    private void stop() {
        if (this.updater != null) {
            this.updater.cancel();
        }
        this.updater = null;
        this.primary = null;
        this.list = null;
        this.stopListening();
    }

    static {
        $assertionsDisabled = !RelatedItemProviderSupport.class.desiredAssertionStatus();
        rp = new RequestProcessor("Navigator RelatedItemProviderSupport gatherer");
    }

    public static abstract class ActiveNodeSupport
    extends RelatedItemProviderSupport {
        private PropertyChangeListener pcl = null;
        private final boolean useCurrentNodes;
        private static final Object PCL_LOCK = new Object();

        protected ActiveNodeSupport(boolean useCurrentNodes) {
            this.useCurrentNodes = useCurrentNodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void startListening() {
            Object object = PCL_LOCK;
            synchronized (object) {
                this.pcl = new PCL();
                TopComponent.getRegistry().addPropertyChangeListener(this.pcl);
                this.pcl.propertyChange(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void stopListening() {
            Object object = PCL_LOCK;
            synchronized (object) {
                TopComponent.getRegistry().removePropertyChangeListener(this.pcl);
                this.pcl = null;
            }
        }

        protected final Collection collectRelatedItems() {
            return this.collectRelatedItems(this.getNodes());
        }

        protected abstract Collection collectRelatedItems(Object var1);

        protected abstract Object getPrimaryItemFromNodes(Node[] var1);

        protected final Object findPrimaryItem() {
            return this.getPrimaryItemFromNodes(this.getNodes());
        }

        private Node[] getNodes() {
            return this.useCurrentNodes ? TopComponent.getRegistry().getCurrentNodes() : TopComponent.getRegistry().getActivatedNodes();
        }

        private final class PCL
        implements PropertyChangeListener {
            private PCL() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (ActiveNodeSupport.this.useCurrentNodes && (evt == null || "currentNodes".equals(evt.getPropertyName())) || !ActiveNodeSupport.this.useCurrentNodes && (evt == null || "activatedNodes".equals(evt.getPropertyName()))) {
                    ActiveNodeSupport.this.change();
                }
            }
        }
    }

    private final class Updater
    implements Runnable {
        boolean enqueued = false;
        boolean cancelled = false;
        boolean firstRun = true;
        Object newPrimary = null;
        Collection newItems = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Updater() {
        }

        void start() {
            if (this.enqueued) {
                return;
            }
            this.enqueued = true;
            rp.post((Runnable)this);
        }

        void cancel() {
            this.cancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (rp.isRequestProcessorThread()) {
                if (!RelatedItemProviderSupport.this.isActive()) {
                    return;
                }
                if (this.firstRun) {
                    this.firstRun = false;
                    RelatedItemProviderSupport.this.startListening();
                }
                Updater updater = this;
                synchronized (updater) {
                    this.newPrimary = RelatedItemProviderSupport.this.findPrimaryItem();
                    this.newItems = RelatedItemProviderSupport.this.collectRelatedItems(this.newPrimary);
                }
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (InterruptedException e) {
                    return;
                }
                catch (InvocationTargetException e) {
                    return;
                }
            }
            if (SwingUtilities.isEventDispatchThread()) {
                if (!RelatedItemProviderSupport.this.isActive()) {
                    return;
                }
                Collection nue = null;
                Object prim = null;
                Updater updater = this;
                synchronized (updater) {
                    nue = this.newItems;
                    prim = this.newPrimary;
                }
                RelatedItemProviderSupport.this.setContents(this.newItems, this.newPrimary);
                this.newItems = null;
                this.newPrimary = null;
                this.enqueued = false;
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Wrong thread");
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$navigation$spi$RelatedItemProviderSupport == null ? (class$org$netbeans$modules$java$navigation$spi$RelatedItemProviderSupport = RelatedItemProviderSupport.class$("org.netbeans.modules.java.navigation.spi.RelatedItemProviderSupport")) : class$org$netbeans$modules$java$navigation$spi$RelatedItemProviderSupport).desiredAssertionStatus();
        }
    }
}

