/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import [Lorg.openide.src.Identifier;;
import [Lorg.openide.src.MethodParameter;;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.ConstructorElement;
import org.openide.src.ElementFormat;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.nodes.ElementNode;
import org.openide.src.nodes.MemberElementNode;
import org.openide.src.nodes.MethodCustomizer;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.HelpCtx;

public class ConstructorElementNode
extends MemberElementNode {
    public ConstructorElementNode(ConstructorElement element, boolean writeable) {
        super(element, Children.LEAF, writeable);
        this.setElementFormat0(sourceOptions.getConstructorElementFormat());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.openide.src.ConstructorNode");
    }

    protected String resolveIconBase() {
        int modif = ((ConstructorElement)this.element).getModifiers();
        if (Modifier.isPrivate(modif)) {
            return "org/openide/src/resources/constructorPrivate";
        }
        if (Modifier.isProtected(modif)) {
            return "org/openide/src/resources/constructorProtected";
        }
        if (Modifier.isPublic(modif)) {
            return "org/openide/src/resources/constructorPublic";
        }
        return "org/openide/src/resources/constructorPackage";
    }

    protected ElementFormat getHintElementFormat() {
        return sourceOptions.getConstructorElementLongFormat();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createModifiersProperty(this.writeable));
        ps.put(this.createNameProperty(false));
        ps.put(this.createParametersProperty(this.writeable));
        ps.put(this.createExceptionsProperty(this.writeable));
        return sheet;
    }

    public void destroy() throws IOException {
        if (!(this.element instanceof MethodElement)) {
            SourceEditSupport.invokeAtomicAsUser(this.element, new SourceEditSupport.ExceptionalRunnable(){

                public void run() throws SourceException {
                    ConstructorElement el = (ConstructorElement)ConstructorElementNode.this.element;
                    el.getDeclaringClass().removeConstructor(el);
                }
            });
        }
        super.destroy();
    }

    public boolean canRename() {
        return false;
    }

    public Component getCustomizer() {
        return new MethodCustomizer((ConstructorElement)this.element);
    }

    public boolean hasCustomizer() {
        return this.isWriteable();
    }

    protected Node.Property createParametersProperty(boolean canW) {
        ElementNode.ElementProp p = new ElementNode.ElementProp("parameters", MethodParameter;.class, canW){

            public Object getValue() {
                return ((ConstructorElement)ConstructorElementNode.this.element).getParameters();
            }

            public void setValue(final Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof MethodParameter[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ConstructorElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ((ConstructorElement)(this).ConstructorElementNode.this.element).setParameters((MethodParameter[])val);
                    }
                });
            }
        };
        p.setValue("changeImmediate", Boolean.FALSE);
        return p;
    }

    protected Node.Property createExceptionsProperty(boolean canW) {
        ElementNode.ElementProp p = new ElementNode.ElementProp("exceptions", Identifier;.class, canW){

            public Object getValue() {
                return ((ConstructorElement)ConstructorElementNode.this.element).getExceptions();
            }

            public void setValue(final Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Identifier[])) {
                    throw new IllegalArgumentException();
                }
                this.runAtomic(ConstructorElementNode.this.element, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        ((ConstructorElement)(this).ConstructorElementNode.this.element).setExceptions((Identifier[])val);
                    }
                });
            }
        };
        p.setValue("changeImmediate", Boolean.FALSE);
        return p;
    }
}

