/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.netbeans.modules.autoupdate.IdeDescription;
import org.netbeans.modules.autoupdate.L10NUpdate;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;

class DependencyChecker {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.autoupdate");

    DependencyChecker() {
    }

    Collection modulesToAdd(ModuleUpdate toAdd, Enumeration selected, List group, StringBuffer dontAddModuleName) {
        err.log("DO modulesToAdd: " + toAdd.getCodeNameBase() + "[L10N? " + (toAdd instanceof L10NUpdate) + "], group: " + group + ", dontAddModuleName: " + dontAddModuleName);
        ArrayList result = new ArrayList();
        this.checkDependencies(toAdd.getRemoteModule(), result, selected, group, dontAddModuleName, toAdd.getLocalModule() != null);
        if (err.isLoggable(1)) {
            String res = "";
            Iterator it = result.iterator();
            while (it.hasNext()) {
                ModuleUpdate mu = (ModuleUpdate)it.next();
                res = res + mu.getCodeNameBase() + "[L10N? " + (mu instanceof L10NUpdate) + "], ";
                err.log("modulesToAdd: " + toAdd.getCodeNameBase() + ", RETURNS: " + res);
            }
        }
        err.log("Do find localization for " + toAdd.getCodeNameBase() + " on locale " + Locale.getDefault());
        DependencyChecker.checkFreeLocalizationDependency(toAdd, Locale.getDefault().toString(), result, selected, group);
        return result;
    }

    Collection modulesToRemove(ModuleUpdate toRemove, ModuleUpdate toReplace) {
        ArrayList result = new ArrayList();
        this.checkReverseDependencies(toRemove.getRemoteModule(), result, toReplace);
        return result;
    }

    private boolean checkDependencies(ModuleInfo md, Collection result, Enumeration selected, List group, StringBuffer dontAddModuleName, boolean isUpgrade) {
        NotifyDescriptor.Confirmation nd;
        List brokenlist;
        Set depsS = md.getDependencies();
        Dependency[] deps = depsS.toArray(new Dependency[depsS.size()]);
        boolean[] satisfied = new boolean[deps.length];
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ModuleInfo[] installedPatches = Updates.getInstalledPatches();
        for (int j = 0; j < deps.length; ++j) {
            ModuleUpdate mu;
            if (deps[j].getType() == 1 || deps[j].getType() == 5) {
                int i;
                boolean ok = false;
                for (i = 0; i < installedModules.length && !(ok = DependencyChecker.checkModuleDependency(deps[j], installedModules[i])); ++i) {
                }
                if (!ok) {
                    for (i = 0; i < installedPatches.length && !(ok = DependencyChecker.checkModuleDependency(deps[j], installedPatches[i])); ++i) {
                    }
                }
                if (!ok && selected != null) {
                    while (selected.hasMoreElements()) {
                        ModuleUpdate mu2 = (ModuleUpdate)selected.nextElement();
                        if (mu2 instanceof L10NUpdate || !(ok = DependencyChecker.checkModuleDependency(deps[j], mu2.getRemoteModule()))) continue;
                        if (result.contains(mu2)) break;
                        err.log("  ADDED[SELECTED]: " + mu2.getCodeNameBase() + "[L10N? " + (mu2 instanceof L10NUpdate) + "]: DEP: " + deps[j]);
                        result.add(mu2);
                        break;
                    }
                }
                if (!ok && group != null) {
                    Iterator it = group.iterator();
                    while (it.hasNext()) {
                        mu = (ModuleUpdate)it.next();
                        if (mu instanceof L10NUpdate || !(ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule()))) continue;
                        if (result.contains(mu)) break;
                        err.log("  ADDED[GROUP]: " + mu.getCodeNameBase() + "[L10N? " + (mu instanceof L10NUpdate) + "]: DEP: " + deps[j]);
                        result.add(mu);
                        break;
                    }
                }
                if (!ok) {
                    Iterator it = Wizard.getAllModules().iterator();
                    while (it.hasNext()) {
                        mu = (ModuleUpdate)it.next();
                        if (mu instanceof L10NUpdate || !(ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule()))) continue;
                        if (result.contains(mu)) break;
                        err.log("  ADDED[ALL]: " + mu.getCodeNameBase() + "[L10N? " + (mu instanceof L10NUpdate) + "]: DEP: " + deps[j]);
                        result.add(mu);
                        break;
                    }
                }
                if (!ok) {
                    satisfied[j] = false;
                    continue;
                }
                satisfied[j] = true;
                continue;
            }
            if (deps[j].getType() == 4) {
                if (this.checkIdeDependency(deps[j], IdeDescription.getIdeDescription())) {
                    satisfied[j] = true;
                    continue;
                }
                Iterator it = Wizard.getAllModules().iterator();
                boolean ok = false;
                while (it.hasNext()) {
                    mu = (ModuleUpdate)it.next();
                    if (mu instanceof L10NUpdate || !(ok = DependencyChecker.checkModuleDependency(deps[j], mu.getRemoteModule()))) continue;
                    if (result.contains(mu)) break;
                    err.log("  ADDED[GROUP]: " + mu.getCodeNameBase() + "[L10N? " + (mu instanceof L10NUpdate) + "]: DEP: " + deps[j]);
                    result.add(mu);
                    break;
                }
                satisfied[j] = ok;
                continue;
            }
            satisfied[j] = true;
        }
        StringBuffer sb = new StringBuffer(280);
        sb.append(this.getBundle("MSG_NotSatisfied") + this.getBundle("TXT_DependencyChecker_Module") + md.getCodeName() + " ");
        int notSatisfied = 0;
        for (int j = 0; j < deps.length; ++j) {
            if (satisfied[j]) continue;
            sb.append(deps[j]);
            ++notSatisfied;
        }
        StringBuffer sbbroken = null;
        if (isUpgrade && (brokenlist = this.checkBrokenImplDependency(md, result)).size() > 0) {
            sbbroken = new StringBuffer(280);
            sbbroken.append("MODULE :" + md.getCodeName());
            sbbroken.append(this.getBundle("MSG_BadsList"));
            Iterator it = brokenlist.iterator();
            while (it.hasNext()) {
                sbbroken.append("\n" + ((ModuleInfo)it.next()).getCodeName());
            }
            sbbroken.append(this.getBundle("MSG_IncludeBadsAnyway"));
        }
        if (notSatisfied == 0 && sbbroken == null) {
            return true;
        }
        if (notSatisfied > 0) {
            sb.append(this.getBundle("MSG_IncludeAnyway"));
            nd = new NotifyDescriptor.Confirmation((Object)sb.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                dontAddModuleName.append(md.getDisplayName());
                return false;
            }
        }
        if (sbbroken != null) {
            nd = new NotifyDescriptor.Confirmation((Object)sbbroken.toString(), 0, 0);
            if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                dontAddModuleName.append(md.getDisplayName());
            }
        }
        return false;
    }

    boolean checkReverseDependencies(ModuleInfo module, Collection result, ModuleUpdate toReplace) {
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ModuleInfo[] installedPatches = Updates.getInstalledPatches();
        Iterator it = Wizard.getAllModules().iterator();
        while (it.hasNext()) {
            ModuleUpdate mu = (ModuleUpdate)it.next();
            ModuleInfo md = mu.getRemoteModule();
            Set depsS = md.getDependencies();
            Dependency[] deps = depsS.toArray(new Dependency[depsS.size()]);
            boolean moduleOk = true;
            for (int j = 0; j < deps.length; ++j) {
                if (deps[j].getType() == 1 && (deps[j].getName() + "/").startsWith(module.getCodeNameBase() + "/") || deps[j].getType() == 5 && Arrays.asList(module.getProvides()).contains(deps[j].getName())) {
                    int k;
                    boolean ok = false;
                    for (k = 0; k < installedModules.length && !(ok = DependencyChecker.checkModuleDependency(deps[j], installedModules[k])); ++k) {
                    }
                    if (!ok && toReplace != null) {
                        ok = DependencyChecker.checkModuleDependency(deps[j], toReplace.getRemoteModule());
                    }
                    if (!ok) {
                        for (k = 0; k < installedPatches.length && !(ok = DependencyChecker.checkModuleDependency(deps[j], installedPatches[k])); ++k) {
                        }
                    }
                    if (ok) continue;
                    moduleOk = false;
                    break;
                }
                if (deps[j].getType() != 4 || !deps[j].getName().equals(module.getCodeName()) || DependencyChecker.checkModuleDependency(deps[j], IdeDescription.getIdeDescription())) continue;
                moduleOk = false;
                break;
            }
            if (moduleOk || result.contains(mu)) continue;
            result.add(mu);
        }
        return result.size() == 0;
    }

    static boolean checkModuleDependency(Dependency dep, ModuleInfo otherModule) {
        if (dep.getType() == 5) {
            return Arrays.asList(otherModule.getProvides()).contains(dep.getName());
        }
        String depName = dep.getName();
        if (depName.equals(otherModule.getCodeName())) {
            if (dep.getComparison() == 3) {
                return true;
            }
            if (dep.getComparison() == 1) {
                if (otherModule.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dep.getVersion()).compareTo((Object)otherModule.getSpecificationVersion()) <= 0;
            }
            if (otherModule.getImplementationVersion() == null) {
                return false;
            }
            return otherModule.getImplementationVersion().equals(dep.getVersion());
        }
        int dash = depName.indexOf(45);
        if (dash != -1) {
            int slash = depName.indexOf(47);
            String cnb = depName.substring(0, slash);
            int relMin = Integer.parseInt(depName.substring(slash + 1, dash));
            int relMax = Integer.parseInt(depName.substring(dash + 1));
            if (cnb.equals(otherModule.getCodeNameBase()) && relMin <= otherModule.getCodeNameRelease() && relMax >= otherModule.getCodeNameRelease()) {
                if (dep.getComparison() == 3) {
                    return true;
                }
                if (otherModule.getCodeNameRelease() > relMin) {
                    return true;
                }
                if (otherModule.getSpecificationVersion() == null) {
                    return false;
                }
                return new SpecificationVersion(dep.getVersion()).compareTo((Object)otherModule.getSpecificationVersion()) <= 0;
            }
        }
        return false;
    }

    boolean checkIdeDependency(Dependency dep, ModuleInfo ide) {
        String IDEName = ide.getCodeName();
        SpecificationVersion IDESpecVersion = ide.getSpecificationVersion();
        String IDEImplVersion = ide.getImplementationVersion();
        if (!IDEName.equals(dep.getName())) {
            return false;
        }
        if (dep.getComparison() == 1) {
            return new SpecificationVersion(dep.getVersion()).compareTo((Object)IDESpecVersion) <= 0;
        }
        if (dep.getComparison() == 2) {
            return dep.getVersion().equals(IDEImplVersion);
        }
        throw new IllegalStateException("Cannot have COMPARE_ANY on IDE dependency");
    }

    private List checkBrokenImplDependency(ModuleInfo md, Collection result) {
        ModuleInfo[] installedModules = Updates.getInstalledModules();
        ArrayList<ModuleInfo> brokenlist = new ArrayList<ModuleInfo>();
        block0: for (int i = 0; i < installedModules.length; ++i) {
            Iterator deps = installedModules[i].getDependencies().iterator();
            while (deps.hasNext()) {
                Dependency dep = (Dependency)deps.next();
                if (!dep.getName().equals(md.getCodeName()) || dep.getComparison() != 2) continue;
                if (dep.getVersion().equals(md.getImplementationVersion())) continue block0;
                Iterator it = Wizard.getAllModules().iterator();
                boolean found = false;
                while (it.hasNext()) {
                    ModuleUpdate mu = (ModuleUpdate)it.next();
                    if (!mu.getRemoteModule().getCodeName().equals(installedModules[i].getCodeName()) || mu.getRemoteModule().getSpecificationVersion().compareTo((Object)installedModules[i].getSpecificationVersion()) <= 0) continue;
                    boolean maybeOK = true;
                    Iterator depsR = mu.getRemoteModule().getDependencies().iterator();
                    while (depsR.hasNext()) {
                        Dependency depR = (Dependency)depsR.next();
                        if (!depR.getName().equals(md.getCodeName()) || depR.getComparison() != 2 || depR.getVersion().equals(md.getImplementationVersion())) continue;
                        maybeOK = false;
                        break;
                    }
                    if (!maybeOK) continue;
                    if (!result.contains(mu)) {
                        result.add(mu);
                    }
                    found = true;
                    break;
                }
                if (found) continue block0;
                brokenlist.add(installedModules[i]);
                continue block0;
            }
        }
        return brokenlist;
    }

    static boolean checkPlatformDependency(ModuleInfo module) {
        Set deps = module.getDependencies();
        Iterator it = deps.iterator();
        boolean res = true;
        while (it.hasNext()) {
            Dependency d = (Dependency)it.next();
            if (5 != d.getType() || !d.getName().startsWith("org.openide.modules.os")) continue;
            res = false;
            ModuleInfo[] installedModules = Updates.getInstalledModules();
            for (int i = 0; !res && i < installedModules.length; ++i) {
                res = DependencyChecker.checkModuleDependency(d, installedModules[i]);
            }
            err.log("checkPlatformDependency on module " + module.getCodeNameBase() + " which requires " + d + " returns " + res);
        }
        return res;
    }

    private static boolean checkFreeLocalizationDependency(ModuleUpdate baseModule, String locale, Collection result, Enumeration selected, List group) {
        L10NUpdate lu;
        ModuleUpdate mu;
        Iterator it;
        boolean ok = false;
        if (baseModule instanceof L10NUpdate) {
            return false;
        }
        if (selected != null) {
            while (selected.hasMoreElements()) {
                L10NUpdate lu2;
                ModuleUpdate mu2 = (ModuleUpdate)selected.nextElement();
                if (!(mu2 instanceof L10NUpdate) || !(ok = locale.equals((lu2 = (L10NUpdate)mu2).getLangcode()) && lu2.getCodeNameBase().equals(baseModule.getCodeNameBase()))) continue;
                if (result.contains(lu2)) break;
                err.log("  ADDED[SELECTED]: " + lu2.getCodeNameBase() + "[" + lu2.getLangcode() + "]");
                result.add(lu2);
                break;
            }
        }
        if (!ok && group != null) {
            it = group.iterator();
            while (it.hasNext()) {
                mu = (ModuleUpdate)it.next();
                if (!(mu instanceof L10NUpdate) || !(ok = locale.equals((lu = (L10NUpdate)mu).getLangcode()) && lu.getCodeNameBase().equals(baseModule.getCodeNameBase()))) continue;
                if (result.contains(lu)) break;
                err.log("  ADDED[GROUP]: " + lu.getCodeNameBase() + "[" + lu.getLangcode() + "]");
                result.add(lu);
                break;
            }
        }
        if (!ok) {
            it = Wizard.getAllModules().iterator();
            while (it.hasNext()) {
                mu = (ModuleUpdate)it.next();
                if (!(mu instanceof L10NUpdate) || !(ok = locale.equals((lu = (L10NUpdate)mu).getLangcode()) && lu.getCodeNameBase().equals(baseModule.getCodeNameBase()))) continue;
                if (result.contains(lu)) break;
                err.log("  ADDED[ALL]: " + lu.getCodeNameBase() + "[" + lu.getLangcode() + "]");
                result.add(lu);
                break;
            }
        }
        return ok;
    }

    private String getBundle(String key) {
        return NbBundle.getMessage((Class)DependencyChecker.class, (String)key);
    }

    static Comparator getModuleDependencyComparator() {
        return new ModuleDependencyComparator();
    }

    static class ModuleDependencyComparator
    implements Comparator {
        ModuleDependencyComparator() {
        }

        public int compare(Object obj, Object obj1) {
            ModuleInfo modB;
            if (!(obj instanceof ModuleUpdate) || !(obj1 instanceof ModuleUpdate)) {
                return 0;
            }
            ModuleInfo modA = ((ModuleUpdate)obj).getRemoteModule();
            if (this.moduleDependsOnModule(modA, modB = ((ModuleUpdate)obj1).getRemoteModule())) {
                return 1;
            }
            if (this.moduleDependsOnModule(modB, modA)) {
                return -1;
            }
            return 0;
        }

        private boolean moduleDependsOnModule(ModuleInfo modA, ModuleInfo modB) {
            Set depsA = modA.getDependencies();
            Iterator it = depsA.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                if (dep.getType() != 1 && dep.getType() != 5 || !DependencyChecker.checkModuleDependency(dep, modB)) continue;
                return true;
            }
            return false;
        }
    }
}

