/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes;

import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;

public final class BridgeUtils {
    private static final ThreadLocal isForCookieSet = new ThreadLocal();

    public static RefObject getJavaObject(Element element) {
        ElementImpl impl = (ElementImpl)element.getCookie(Element.Impl.class);
        return impl.getJavaElement();
    }

    private static ClassElement getClassElement(ClassMember member) {
        JavaClass jc = (JavaClass)member.getDeclaringClass();
        if (jc == null) {
            BridgeUtils.throwIllegalState(member, "none declaring class");
        }
        return BridgeUtils.getElement(jc);
    }

    public static Element getElement(ClassMember member) {
        ClassElement e = null;
        if (member instanceof JavaClass) {
            e = BridgeUtils.getElement((JavaClass)member);
        } else if (member instanceof Constructor) {
            e = BridgeUtils.getElement((Constructor)member);
        } else if (member instanceof Field) {
            e = BridgeUtils.getElement((Field)member);
        } else if (member instanceof Initializer) {
            e = BridgeUtils.getElement((Initializer)member);
        } else if (member instanceof Method) {
            e = BridgeUtils.getElement((Method)member);
        } else {
            throw new IllegalArgumentException("Unknown member: " + member);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Element getElementForCookieSet(ClassMember member) {
        try {
            isForCookieSet.set(Boolean.TRUE);
            Element element = BridgeUtils.getElement(member);
            return element;
        }
        finally {
            isForCookieSet.set(Boolean.FALSE);
        }
    }

    public static ClassElement getElement(JavaClass member) {
        SourceCookie sc;
        DataObject d;
        Resource r = member.getResource();
        if (r == null) {
            BridgeUtils.throwIllegalState((ClassMember)member, "missing resource");
        }
        if ((d = JavaMetamodel.getManager().getDataObject(r)) == null) {
            BridgeUtils.throwIllegalState((ClassMember)member, "missing data object");
        }
        if ((sc = (SourceCookie)d.getCookie(SourceCookie.class)) == null) {
            if (Boolean.TRUE.equals(isForCookieSet.get())) {
                return null;
            }
            BridgeUtils.throwIllegalState((ClassMember)member, "missing source cookie");
        }
        SourceElement source = sc.getSource();
        ClassElement[] els = member.refImmediateComposite() instanceof JavaClass ? source.getAllClasses() : source.getClasses();
        return (ClassElement)BridgeUtils.chooseElement((Element[])els, (ClassMember)member);
    }

    public static ConstructorElement getElement(Constructor member) {
        ClassElement ce = BridgeUtils.getClassElement((ClassMember)member);
        if (ce == null) {
            return null;
        }
        ConstructorElement[] els = ce.getConstructors();
        return (ConstructorElement)BridgeUtils.chooseElement((Element[])els, (ClassMember)member);
    }

    public static FieldElement getElement(Field member) {
        ClassElement ce = BridgeUtils.getClassElement((ClassMember)member);
        if (ce == null) {
            return null;
        }
        FieldElement[] els = ce.getFields();
        return (FieldElement)BridgeUtils.chooseElement((Element[])els, (ClassMember)member);
    }

    public static MethodElement getElement(Method member) {
        ClassElement ce = BridgeUtils.getClassElement((ClassMember)member);
        if (ce == null) {
            return null;
        }
        MethodElement[] els = ce.getMethods();
        return (MethodElement)BridgeUtils.chooseElement((Element[])els, (ClassMember)member);
    }

    public static InitializerElement getElement(Initializer member) {
        ClassElement ce = BridgeUtils.getClassElement((ClassMember)member);
        if (ce == null) {
            return null;
        }
        InitializerElement[] els = ce.getInitializers();
        return (InitializerElement)BridgeUtils.chooseElement((Element[])els, (ClassMember)member);
    }

    private static Element chooseElement(Element[] els, ClassMember member) {
        for (int i = 0; i < els.length; ++i) {
            Element e = els[i];
            RefObject ref = BridgeUtils.getJavaObject(e);
            if (!member.equals(ref)) continue;
            return e;
        }
        BridgeUtils.throwIllegalState(member, "cannot map class member to source hierarchy element");
        return null;
    }

    private static void throwIllegalState(ClassMember member, String message) throws IllegalStateException {
        IllegalStateException ise = new IllegalStateException(message);
        ErrorManager.getDefault().annotate((Throwable)ise, 1, member.getClass().toString(), null, null, null);
        try {
            ErrorManager.getDefault().annotate((Throwable)ise, 1, "name: " + member.getName(), null, null, null);
            ErrorManager.getDefault().annotate((Throwable)ise, 1, "member: " + member.toString(), null, null, null);
        }
        catch (JmiException e) {
            ErrorManager.getDefault().annotate((Throwable)ise, 1, null, null, (Throwable)e, null);
        }
        throw ise;
    }
}

