/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.settings;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.netbeans.modules.java.settings.JavaSynchronizationSettings;
import org.netbeans.modules.javacore.JMManager;
import org.openide.options.ContextSystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JavaSettings
extends ContextSystemOption {
    private static final int currentVersion = 1;
    static final long serialVersionUID = -8522143676848697297L;
    public static final String PROP_SHOW_OVERRIDING = "showOverriding";
    public static final String PROP_SHOW_COMPILE_STATUS = "showCompileStatus";
    public static final String PROP_REPLACEABLE_STRINGS_TABLE = "replaceableStringsTable";
    public static final String PROP_AUTO_PARSING_DELAY = "autoParsingDelay";
    public static final String PROP_PARSING_ERRORS = "parsingErrors";
    public static final int DEFAULT_AUTO_PARSING_DELAY = 2000;
    public static final int DEFAULT_PARSING_ERRORS = 100;
    private static final boolean DEFAULT_SHOW_OVERRIDING = true;
    private int version;
    private static JavaSettings javaSettings;
    public static final String PROP_DEFAULT_ENCODING = "defaultEncoding";
    public static final String ENCODING_PLATFORM_DEFAULT = "";
    private String defaultEncoding = "";

    public String displayName() {
        return JavaSettings.getString("CTL_Java_option");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JavaSettings.class);
    }

    public JavaSettings() {
        this.addOption(JavaSettings.getJavaSynchronizationSettings());
    }

    public void setReplaceableStringsTable(String table) {
        String t = this.getReplaceableStringsTable();
        if (t.equals(table)) {
            return;
        }
        this.putProperty(PROP_REPLACEABLE_STRINGS_TABLE, table, true);
    }

    public String getReplaceableStringsTable() {
        String table = (String)this.getProperty(PROP_REPLACEABLE_STRINGS_TABLE);
        if (table == null) {
            return "USER=" + System.getProperty("user.name") + "\n";
        }
        return table;
    }

    public Properties getReplaceableStringsProps() {
        Properties props = new Properties();
        String propString = this.getReplaceableStringsTable();
        int len = propString.length();
        StringBuffer unicodeString = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char aChar = propString.charAt(i);
            if (aChar > '\u00ff') {
                String hex = Integer.toHexString(aChar);
                unicodeString.append("\\u");
                if (aChar < '\u1000') {
                    unicodeString.append("0");
                }
                unicodeString.append(hex);
                continue;
            }
            unicodeString.append(aChar);
        }
        try {
            props.load(new ByteArrayInputStream(unicodeString.toString().getBytes()));
        }
        catch (IOException e) {
            // empty catch block
        }
        return props;
    }

    public int getAutoParsingDelay() {
        Integer delay = (Integer)this.getProperty(PROP_AUTO_PARSING_DELAY);
        if (delay == null) {
            return 2000;
        }
        return delay;
    }

    public void setParsingErrors(int errors) {
        if (errors < 0) {
            throw new IllegalArgumentException();
        }
        this.putProperty(PROP_PARSING_ERRORS, new Integer(errors), true);
    }

    public int getParsingErrors() {
        Integer errors = (Integer)this.getProperty(PROP_PARSING_ERRORS);
        if (errors == null) {
            return 100;
        }
        return errors;
    }

    public boolean getShowOverriding() {
        Boolean value = (Boolean)this.getProperty(PROP_SHOW_OVERRIDING);
        if (value == null) {
            return true;
        }
        return value;
    }

    public void setShowOverriding(boolean value) {
        Boolean b = (Boolean)this.getProperty(PROP_SHOW_OVERRIDING);
        if (b != null && b == value) {
            return;
        }
        this.putProperty(PROP_SHOW_OVERRIDING, value ? Boolean.TRUE : Boolean.FALSE, true);
    }

    public void setAutoParsingDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException();
        }
        this.putProperty(PROP_AUTO_PARSING_DELAY, new Integer(delay));
    }

    public boolean isCompileStatusEnabled() {
        Boolean b = (Boolean)this.getProperty(PROP_SHOW_COMPILE_STATUS);
        if (b == null) {
            return true;
        }
        return b;
    }

    public void enableCompileStatus(boolean b) {
        if (this.isCompileStatusEnabled() == b) {
            return;
        }
        this.putProperty(PROP_SHOW_COMPILE_STATUS, b ? Boolean.TRUE : Boolean.FALSE, true);
    }

    static String getString(String s) {
        return NbBundle.getMessage((Class)JavaSettings.class, (String)s);
    }

    private static JavaSynchronizationSettings getJavaSynchronizationSettings() {
        return (JavaSynchronizationSettings)JavaSynchronizationSettings.findObject((Class)JavaSynchronizationSettings.class, (boolean)true);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (in.available() > 0) {
            this.version = in.readInt();
        }
        if (this.version < 1) {
            this.version = 1;
        }
        JMManager.setDefaultEncoding((String)this.defaultEncoding);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.version);
    }

    public static final JavaSettings getDefault() {
        if (javaSettings == null) {
            javaSettings = (JavaSettings)JavaSettings.findObject((Class)JavaSettings.class, (boolean)true);
        }
        return javaSettings;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setDefaultEncoding(String enc) {
        String e = this.defaultEncoding;
        this.defaultEncoding = enc;
        JMManager.setDefaultEncoding((String)enc);
        this.firePropertyChange(PROP_DEFAULT_ENCODING, e, enc);
    }
}

