/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;

public class MakeUpdateDesc
extends MatchingTask {
    protected boolean usedMatchingTask = false;
    private Vector entityincludes = new Vector();
    private Vector groups = new Vector();
    private Vector filesets = new Vector();
    private String desc_name;
    private File desc;
    private File desc_ent;
    private String dist_base;

    public void setDesc(String d) {
        this.desc_name = d;
        this.desc = new File(this.desc_name);
    }

    public Group createGroup() {
        Group g = new Group();
        this.groups.add(g);
        return g;
    }

    public Entityinclude createEntityinclude() {
        Entityinclude i = new Entityinclude();
        this.entityincludes.add(i);
        return i;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setDistBase(String dbase) {
        this.dist_base = dbase;
    }

    private static String xmlEscape(String s) {
        int max = s.length();
        StringBuffer s2 = new StringBuffer((int)((double)max * 1.1 + 1.0));
        block6: for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    s2.append("&lt;");
                    continue block6;
                }
                case '>': {
                    s2.append("&gt;");
                    continue block6;
                }
                case '&': {
                    s2.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    s2.append("&quot;");
                    continue block6;
                }
                default: {
                    s2.append(c);
                }
            }
        }
        return s2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        Group root = new Group();
        root.setName("root");
        for (int i = 0; i < this.filesets.size(); ++i) {
            root.addFileSet((FileSet)this.filesets.elementAt(i));
        }
        this.groups.addElement(root);
        if (this.desc.exists()) {
            long time = this.desc.lastModified();
            boolean uptodate = true;
            block14: for (int i = 0; i < this.groups.size(); ++i) {
                Group g = (Group)this.groups.elementAt(i);
                for (int j = 0; j < g.filesets.size(); ++j) {
                    FileSet n = (FileSet)g.filesets.elementAt(j);
                    if (n == null) continue;
                    DirectoryScanner ds = n.getDirectoryScanner(this.getProject());
                    String[] files = ds.getIncludedFiles();
                    File bdir = ds.getBasedir();
                    for (int k = 0; k < files.length; ++k) {
                        File n_file = new File(bdir, files[k]);
                        if (n_file.lastModified() <= time) continue;
                        uptodate = false;
                        break block14;
                    }
                }
            }
            if (uptodate) {
                return;
            }
        }
        this.log("Creating update description " + this.desc.getAbsolutePath());
        try {
            this.desc.delete();
            FileOutputStream os = new FileOutputStream(this.desc);
            try {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                pw.println();
                SimpleDateFormat format = new SimpleDateFormat("ss/mm/HH/dd/MM/yyyy");
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                String date = format.format(new Date());
                if (this.entityincludes.size() > 0) {
                    int i;
                    String ent_name = this.desc_name.toString();
                    int xml_idx = ent_name.indexOf(".xml");
                    ent_name = xml_idx != -1 ? ent_name.substring(0, xml_idx) + ".ent" : ent_name + ".ent";
                    this.desc_ent = new File(ent_name);
                    this.desc_ent.delete();
                    pw.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.3//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_3.dtd\" [");
                    pw.println("    <!ENTITY entity SYSTEM \"" + MakeUpdateDesc.xmlEscape(this.desc_ent.getName()) + "\">");
                    boolean inc_num = false;
                    for (i = 0; i < this.entityincludes.size(); ++i) {
                        Entityinclude ei = (Entityinclude)this.entityincludes.elementAt(i);
                        pw.println("    <!ENTITY include" + i + " SYSTEM \"" + MakeUpdateDesc.xmlEscape(ei.file) + "\">");
                    }
                    pw.println("]>");
                    pw.println();
                    pw.println("<module_updates timestamp=\"" + MakeUpdateDesc.xmlEscape(date) + "\">");
                    pw.println("    &entity;");
                    for (i = 0; i < this.entityincludes.size(); ++i) {
                        pw.println("    &include" + i + ";");
                    }
                    pw.println("</module_updates>");
                    pw.println();
                    pw.flush();
                    pw.close();
                    os = new FileOutputStream(this.desc_ent);
                    pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                    pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    pw.println("<!-- external entity include " + date + " -->");
                    pw.println();
                } else {
                    pw.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.3//EN\" \"http://www.netbeans.org/dtds/autoupdate-catalog-2_3.dtd\">");
                    pw.println("<module_updates timestamp=\"" + date + "\">");
                    pw.println();
                }
                pw.println();
                StringBuffer licenses = new StringBuffer();
                HashSet<String> licenseNames = new HashSet<String>();
                for (int gi = 0; gi < this.groups.size(); ++gi) {
                    Group g = (Group)this.groups.elementAt(gi);
                    this.log("Creating group \"" + g.name + "\"");
                    if (!g.name.equals("root")) {
                        pw.println("<module_group name=\"" + MakeUpdateDesc.xmlEscape(g.name) + "\">");
                        pw.println();
                    }
                    for (int fsi = 0; fsi < g.filesets.size(); ++fsi) {
                        FileSet fs = (FileSet)g.filesets.elementAt(fsi);
                        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                        String[] files = ds.getIncludedFiles();
                        for (int fid = 0; fid < files.length; ++fid) {
                            File n_file = new File(fs.getDir(this.getProject()), files[fid]);
                            try {
                                long size = n_file.length();
                                ZipFile zip = new ZipFile(n_file);
                                try {
                                    ZipEntry entry = zip.getEntry("Info/info.xml");
                                    if (entry == null) {
                                        throw new BuildException("NBM " + n_file + " was malformed: no Info/info.xml", this.getLocation());
                                    }
                                    InputStream is = zip.getInputStream(entry);
                                    try {
                                        BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                                        String line = r.readLine();
                                        if (!line.startsWith("<?xml")) {
                                            throw new BuildException("Strange info.xml line: " + line, this.getLocation());
                                        }
                                        block22: while ((line = r.readLine()) != null) {
                                            String docType;
                                            String dummyDistribution;
                                            String dummyModuleName;
                                            String dummyDownloadSize = "downloadsize=\"0\"";
                                            int idx = line.indexOf(dummyDownloadSize);
                                            if (idx != -1) {
                                                line = line.substring(0, idx) + "downloadsize=\"" + size + "\"" + line.substring(idx + dummyDownloadSize.length());
                                            }
                                            if ((idx = line.indexOf(dummyModuleName = "OpenIDE-Module-Name=\"")) != -1) {
                                                String mn = line.substring(idx + dummyModuleName.length() - 1);
                                                this.log(" Adding module   " + mn + " (" + n_file.getAbsolutePath() + ")");
                                            }
                                            if (this.dist_base != null && (idx = line.indexOf(dummyDistribution = "distribution=\"")) != -1) {
                                                String line1 = line.substring(0, idx) + "distribution=\"";
                                                this.log("distribution line1  : \"" + line1 + "\"", 4);
                                                String pomline = line.substring(idx + dummyDistribution.length());
                                                this.log("distribution pomline: \"" + pomline + "\"", 4);
                                                int idx2 = pomline.indexOf("\"");
                                                if (idx2 == -1) {
                                                    throw new BuildException("Strange info.xml line: " + line, this.getLocation());
                                                }
                                                String line2 = pomline.substring(idx2);
                                                this.log("distribution line2: \"" + line2 + "\"", 4);
                                                String newline = line1 + this.dist_base + "/" + n_file.getName() + line2;
                                                if (!newline.equals(line)) {
                                                    this.log(" <- distribution fixed from: \"" + line + "\"", 4);
                                                    this.log(" -> distribution fixed to  : \"" + newline + "\"", 3);
                                                    line = newline;
                                                }
                                            }
                                            if ((idx = line.indexOf(docType = "<!DOCTYPE module")) != -1) continue;
                                            String licenseMarker = "<license name=\"";
                                            idx = line.indexOf(licenseMarker);
                                            if (idx != -1) {
                                                int idx2 = line.indexOf("\"", idx + licenseMarker.length());
                                                if (idx2 == -1) {
                                                    throw new BuildException("Strange info.xml line: " + line, this.getLocation());
                                                }
                                                String name = line.substring(idx + licenseMarker.length(), idx2);
                                                boolean copy = !licenseNames.contains(name);
                                                licenseNames.add(name);
                                                do {
                                                    if (copy) {
                                                        licenses.append(line);
                                                        licenses.append('\n');
                                                    }
                                                    if (line.indexOf("</license>") == -1) continue;
                                                    licenses.append('\n');
                                                    continue block22;
                                                } while ((line = r.readLine()) != null);
                                                continue;
                                            }
                                            pw.println(line);
                                        }
                                        continue;
                                    }
                                    finally {
                                        is.close();
                                        pw.println();
                                    }
                                }
                                finally {
                                    zip.close();
                                }
                            }
                            catch (IOException ioe) {
                                throw new BuildException("Cannot access nbm file: " + n_file, (Throwable)ioe, this.getLocation());
                            }
                        }
                    }
                    if (g.name.equals("root")) continue;
                    pw.println("</module_group>");
                    pw.println();
                }
                pw.print(licenses.toString());
                if (this.entityincludes.size() <= 0) {
                    pw.println("</module_updates>");
                    pw.println();
                }
                pw.flush();
                pw.close();
            }
            finally {
                os.flush();
                ((OutputStream)os).close();
            }
        }
        catch (IOException ioe) {
            this.desc.delete();
            throw new BuildException("Cannot create update description", (Throwable)ioe, this.getLocation());
        }
    }

    public class Entityinclude {
        public String file;

        public void setFile(String f) {
            this.file = f;
        }
    }

    public class Group {
        public Vector nbms = new Vector();
        public Vector filesets = new Vector();
        public Vector scanners = new Vector();
        public String name;

        public void setName(String s) {
            this.name = s;
        }

        public void addFileSet(FileSet set) {
            this.filesets.add(set);
        }
    }
}

