/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.ModuleSelector;
import org.xml.sax.SAXException;

public class MakeJNLP
extends Task {
    private FileSet files;
    private SignJar signTask;
    private File target;
    private String codebase = "$$codebase";
    private boolean verify;
    private String verifyExcludes;

    public FileSet createModules() throws BuildException {
        if (this.files != null) {
            throw new BuildException("modules can be created just once");
        }
        this.files = new FileSet();
        return this.files;
    }

    private SignJar getSignTask() {
        if (this.signTask == null) {
            this.signTask = (SignJar)this.getProject().createTask("signjar");
        }
        return this.signTask;
    }

    public void setDir(File t) {
        this.target = t;
    }

    public void setAlias(String a) {
        this.getSignTask().setAlias(a);
    }

    public void setStorePass(String p) {
        this.getSignTask().setStorepass(p);
    }

    public void setKeystore(String k) {
        this.getSignTask().setKeystore(k);
    }

    public void setCodebase(String s) {
        this.codebase = s;
    }

    public void setVerify(boolean v) {
        this.verify = v;
    }

    public void setVerifyExcludes(String s) {
        this.verifyExcludes = s;
    }

    public void execute() throws BuildException {
        if (this.target == null) {
            throw new BuildException("Output dir must be provided");
        }
        if (this.files == null) {
            throw new BuildException("modules must be provided");
        }
        try {
            this.generateFiles();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void generateFiles() throws IOException, BuildException {
        DirectoryScanner scan = this.files.getDirectoryScanner(this.getProject());
        String[] arr = scan.getIncludedFiles();
        for (int i = 0; i < arr.length; ++i) {
            File jar = new File(this.files.getDir(this.getProject()), arr[i]);
            if (!jar.canRead()) {
                throw new BuildException("Cannot read file: " + jar);
            }
            JarFile theJar = new JarFile(jar);
            String codenamebase = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module");
            if (codenamebase == null) {
                throw new BuildException("Not a NetBeans Module: " + jar);
            }
            int slash = codenamebase.indexOf(47);
            if (slash >= 0) {
                codenamebase = codenamebase.substring(0, slash);
            }
            String dashcnb = codenamebase.replace('.', '-');
            String bundle = theJar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle");
            Properties prop = new Properties();
            if (bundle != null) {
                ZipEntry en = theJar.getEntry(bundle);
                if (en == null) {
                    throw new BuildException("Cannot find entry: " + bundle + " in file: " + jar);
                }
                InputStream is = theJar.getInputStream(en);
                prop.load(is);
                is.close();
            }
            String title = prop.getProperty("OpenIDE-Module-Name", codenamebase);
            String oneline = prop.getProperty("OpenIDE-Module-Short-Description", title);
            String shrt = prop.getProperty("OpenIDE-Module-Long-Description", oneline);
            Map localizedFiles = this.verifyExtensions(jar, theJar.getManifest(), dashcnb, codenamebase, this.verify);
            File signed = new File(this.target, jar.getName());
            File jnlp = new File(this.target, dashcnb + ".jnlp");
            StringWriter writeJNLP = new StringWriter();
            writeJNLP.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            writeJNLP.write("<jnlp spec='1.0+' codebase='" + this.codebase + "' >\n");
            writeJNLP.write("  <information>\n");
            writeJNLP.write("   <title>" + title + "</title>\n");
            writeJNLP.write("   <vendor>NetBeans</vendor>\n");
            writeJNLP.write("   <description kind='one-line'>" + oneline + "</description>\n");
            writeJNLP.write("   <description kind='short'>" + shrt + "</description>\n");
            writeJNLP.write("  </information>\n");
            writeJNLP.write("  <security><all-permissions/></security>\n");
            writeJNLP.write("  <resources>\n");
            writeJNLP.write("     <jar href='");
            writeJNLP.write(jar.getName());
            writeJNLP.write("'/>\n");
            this.processExtensions(jar, theJar.getManifest(), writeJNLP, dashcnb, this.codebase);
            writeJNLP.write("  </resources>\n");
            for (Map.Entry e : localizedFiles.entrySet()) {
                String locale = (String)e.getKey();
                List files = (List)e.getValue();
                writeJNLP.write("  <resources locale='" + locale + "'>\n");
                for (File n : files) {
                    File t = new File(this.target, n.getName());
                    this.getSignTask().setJar(n);
                    this.getSignTask().setSignedjar(t);
                    this.getSignTask().execute();
                    writeJNLP.write("     <jar href='");
                    writeJNLP.write(n.getName());
                    writeJNLP.write("'/>\n");
                }
                writeJNLP.write("  </resources>\n");
            }
            writeJNLP.write("  <component-desc/>\n");
            writeJNLP.write("</jnlp>\n");
            writeJNLP.close();
            FileWriter w = new FileWriter(jnlp);
            w.write(writeJNLP.toString());
            w.close();
            this.getSignTask().setJar(jar);
            this.getSignTask().setSignedjar(signed);
            this.getSignTask().execute();
            theJar.close();
        }
    }

    private Map verifyExtensions(File f, Manifest mf, String dashcnb, String codebasename, boolean verify) throws IOException, BuildException {
        StringTokenizer tok;
        File updateTracking;
        HashMap localizedFiles = new HashMap();
        File clusterRoot = f.getParentFile();
        String moduleDirPrefix = "";
        while (!(updateTracking = new File(clusterRoot, "update_tracking")).isDirectory()) {
            moduleDirPrefix = clusterRoot.getName() + "/" + moduleDirPrefix;
            if ((clusterRoot = clusterRoot.getParentFile()) != null && clusterRoot.exists()) continue;
            if (!verify) {
                return localizedFiles;
            }
            throw new BuildException("Cannot find update_tracking directory for module " + f);
        }
        File ut = new File(updateTracking, dashcnb + ".xml");
        if (!ut.exists()) {
            throw new BuildException("The file " + ut + " for module " + codebasename + " cannot be found");
        }
        HashMap fileToOwningModule = new HashMap();
        try {
            ModuleSelector.readUpdateTracking(this.getProject(), ut.toString(), fileToOwningModule);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
        this.log("project files: " + fileToOwningModule, 4);
        String name = MakeJNLP.relative(f, clusterRoot);
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "config/Modules/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "config/ModuleAutoDeps/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        name = "update_tracking/" + dashcnb + ".xml";
        this.log("  removing: " + name, 4);
        MakeJNLP.removeWithLocales(fileToOwningModule, name, clusterRoot, localizedFiles);
        String path = mf.getMainAttributes().getValue("Class-Path");
        if (path != null) {
            tok = new StringTokenizer(path, ", ");
            while (tok.hasMoreElements()) {
                String s = tok.nextToken();
                File e = new File(f.getParentFile(), s);
                String r = MakeJNLP.relative(e, clusterRoot);
                MakeJNLP.removeWithLocales(fileToOwningModule, r, clusterRoot, localizedFiles);
            }
        }
        if (this.verifyExcludes != null) {
            tok = new StringTokenizer(this.verifyExcludes, ", ");
            while (tok.hasMoreElements()) {
                MakeJNLP.removeWithLocales(fileToOwningModule, tok.nextToken(), clusterRoot, localizedFiles);
            }
        }
        if (verify && !fileToOwningModule.isEmpty()) {
            throw new BuildException("Cannot build JNLP for module " + f + " as these files are in " + "module's NBM, but are not referenced from any path:\n" + fileToOwningModule.keySet());
        }
        return localizedFiles;
    }

    private static void removeWithLocales(Map removeFrom, String removeWhat, File clusterRoot, Map recordLocales) {
        if (removeFrom.remove(removeWhat) != null && removeWhat.endsWith(".jar")) {
            int basedir = removeWhat.lastIndexOf(47);
            String base = basedir == -1 ? "" : removeWhat.substring(0, basedir);
            String name = removeWhat.substring(basedir + 1, removeWhat.length() - 4);
            Pattern p = Pattern.compile(base + "/locale/" + name + "(|_[a-zA-Z0-9_]+)\\.jar");
            Iterator it = removeFrom.keySet().iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                Matcher m = p.matcher(s);
                if (!m.matches()) continue;
                String locale = m.group(1).substring(1);
                ArrayList<File> l = (ArrayList<File>)recordLocales.get(locale);
                if (l == null) {
                    l = new ArrayList<File>();
                    recordLocales.put(locale, l);
                }
                l.add(new File(clusterRoot, s.replace('/', File.separatorChar)));
                it.remove();
            }
        }
    }

    private void processExtensions(File f, Manifest mf, Writer fileWriter, String dashcnb, String codebase) throws IOException, BuildException {
        String path = mf.getMainAttributes().getValue("Class-Path");
        if (path == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(path, ", ");
        while (tok.hasMoreElements()) {
            String s = tok.nextToken();
            File e = new File(f.getParentFile(), s);
            if (!e.canRead()) {
                throw new BuildException("Cannot read extension " + e + " referenced from " + f);
            }
            String n = e.getName();
            if (n.endsWith(".jar")) {
                n = n.substring(0, n.length() - 4);
            }
            if (MakeJNLP.isSigned(e)) {
                Copy copy = (Copy)this.getProject().createTask("copy");
                copy.setFile(e);
                File t = new File(this.target, e.getName());
                copy.setTofile(t);
                copy.execute();
                String extJnlpName = dashcnb + "-ext-" + n + ".jnlp";
                File jnlp = new File(this.target, extJnlpName);
                FileWriter writeJNLP = new FileWriter(jnlp);
                writeJNLP.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                writeJNLP.write("<jnlp spec='1.0+' codebase='" + codebase + "' >\n");
                writeJNLP.write("  <information>\n");
                writeJNLP.write("   <title>" + n + "</title>\n");
                writeJNLP.write("   <vendor>NetBeans</vendor>\n");
                writeJNLP.write("  </information>\n");
                writeJNLP.write("  <security><all-permissions/></security>\n");
                writeJNLP.write("  <resources>\n");
                writeJNLP.write("     <jar href='");
                writeJNLP.write(e.getName());
                writeJNLP.write("'/>\n");
                writeJNLP.write("  </resources>\n");
                writeJNLP.write("  <component-desc/>\n");
                writeJNLP.write("</jnlp>\n");
                writeJNLP.close();
                fileWriter.write("    <extension name='" + e.getName() + "' href='" + extJnlpName + "'/>\n");
                continue;
            }
            File ext = new File(this.target, e.getName());
            fileWriter.write("    <jar href='" + e.getName() + "'/>\n");
            this.getSignTask().setJar(e);
            this.getSignTask().setSignedjar(ext);
            this.getSignTask().execute();
        }
    }

    private static String relative(File file, File root) {
        String sroot;
        String sfile = file.toString().replace(File.separatorChar, '/');
        if (sfile.startsWith(sroot = (root.toString() + File.separator).replace(File.separatorChar, '/'))) {
            return sfile.substring(sroot.length());
        }
        return sfile;
    }

    private static boolean isSigned(File f) throws IOException {
        JarFile jar = new JarFile(f);
        Enumeration<JarEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            if (!e.getName().endsWith(".SF")) continue;
            jar.close();
            return true;
        }
        jar.close();
        return false;
    }
}

