/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.validation.constraints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.j2ee.sun.validation.constraints.Constraint;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintFailure;
import org.netbeans.modules.j2ee.sun.validation.constraints.ConstraintUtils;
import org.netbeans.modules.j2ee.sun.validation.util.BundleReader;

public class CardinalConstraint
extends ConstraintUtils
implements Constraint {
    private int cardinal = 32;

    public CardinalConstraint() {
        this.cardinal = 32;
    }

    public CardinalConstraint(int cardinal) {
        this.cardinal = cardinal;
    }

    public CardinalConstraint(String cardinal) {
        try {
            this.cardinal = Integer.parseInt(cardinal);
        }
        catch (NumberFormatException e) {
            String format = BundleReader.getValue("Error_failed_to_create");
            Object[] arguments = new Object[]{"CardinalConstraint"};
            System.out.println(MessageFormat.format(format, arguments));
        }
    }

    public Collection match(String value, String name) {
        return this.match((Object)value, name);
    }

    public Collection match(Object value, String name) {
        ArrayList<ConstraintFailure> failed_constrained_list = new ArrayList<ConstraintFailure>();
        if (64 == this.cardinal) {
            Object[] values = null;
            try {
                values = (Object[])value;
            }
            catch (ClassCastException exception) {
                System.out.println(BundleReader.getValue("Error_expects_argument_one_to_be_an_array_of_Objects"));
            }
            if (null == values || values.length < 1) {
                String failureMessage = this.formatFailureMessage(this.toString(), name);
                failed_constrained_list.add(new ConstraintFailure(this.toString(), null, name, failureMessage, BundleReader.getValue("MSG_CardinalConstraint_Failure")));
            }
        } else if (32 == this.cardinal && null == value) {
            String failureMessage = this.formatFailureMessage(this.toString(), name);
            failed_constrained_list.add(new ConstraintFailure(this.toString(), null, name, failureMessage, BundleReader.getValue("MSG_CardinalConstraint_Failure")));
        }
        return failed_constrained_list;
    }

    public void setCardinal(int cardinal) {
        this.cardinal = cardinal;
    }

    public void setCardinal(String cardinal) {
        try {
            this.cardinal = Integer.parseInt(cardinal);
        }
        catch (NumberFormatException e) {
            String format = BundleReader.getValue("Error_failed_to_set");
            Object[] arguments = new Object[]{this.toString(), "Cardinal"};
            System.out.println(MessageFormat.format(format, arguments));
        }
    }

    public void print() {
        super.print();
        String format = BundleReader.getValue("Name_Value_Pair_Format");
        Object[] arguments = new Object[]{"Cardinal", String.valueOf(this.cardinal)};
        System.out.println(MessageFormat.format(format, arguments));
    }
}

