/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableDialogPanelAccessor;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.TextMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.ValidationSupport;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.MessageEntry;
import org.openide.util.NbBundle;

public class MessageSecurityEntryPanel
extends JPanel
implements GenericTableDialogPanelAccessor {
    private static final ResourceBundle webserviceBundle;
    private static final ResourceBundle commonBundle;
    private static final TextMapping[] sourceTypes;
    private static final TextMapping[] recipientTypes;
    private static final int METHOD_FIELD = 0;
    private static final int REQ_SOURCE_FIELD = 1;
    private static final int REQ_RECIPIENT_FIELD = 2;
    private static final int RESP_SOURCE_FIELD = 3;
    private static final int RESP_RECIPIENT_FIELD = 4;
    private static final int NUM_FIELDS = 5;
    private DefaultComboBoxModel authReqSourceModel;
    private DefaultComboBoxModel authReqRecipientModel;
    private DefaultComboBoxModel authRespSourceModel;
    private DefaultComboBoxModel authRespRecipientModel;
    private boolean methodAsOperation;
    private String methodName;
    private String reqSource;
    private String reqRecipient;
    private String respSource;
    private String respRecipient;
    private boolean initializingFields;
    private JComboBox jCbxReqAuthRecip;
    private JComboBox jCbxReqAuthSource;
    private JComboBox jCbxRespAuthRecip;
    private JComboBox jCbxRespAuthSource;
    private JLabel jLblMethodName;
    private JLabel jLblMethodNameReqFlag;
    private JLabel jLblReqAuthRecip;
    private JLabel jLblReqAuthSource;
    private JLabel jLblRespAuthRecip;
    private JLabel jLblRespAuthSource;
    private JTextField jTxtMethodName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MessageSecurityEntryPanel() {
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblMethodNameReqFlag = new JLabel();
        this.jLblMethodName = new JLabel();
        this.jTxtMethodName = new JTextField();
        this.jLblReqAuthSource = new JLabel();
        this.jCbxReqAuthSource = new JComboBox();
        this.jLblReqAuthRecip = new JLabel();
        this.jCbxReqAuthRecip = new JComboBox();
        this.jLblRespAuthSource = new JLabel();
        this.jCbxRespAuthSource = new JComboBox();
        this.jLblRespAuthRecip = new JLabel();
        this.jCbxRespAuthRecip = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.jLblMethodNameReqFlag.setText(commonBundle.getString("LBL_RequiredMark"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblMethodNameReqFlag, gridBagConstraints);
        this.jLblMethodNameReqFlag.getAccessibleContext().setAccessibleName(commonBundle.getString("ACSN_RequiredMark"));
        this.jLblMethodNameReqFlag.getAccessibleContext().setAccessibleDescription(commonBundle.getString("ACSD_RequiredMark"));
        this.jLblMethodName.setDisplayedMnemonic(webserviceBundle.getString("MNE_MethodName").charAt(0));
        this.jLblMethodName.setText(webserviceBundle.getString("LBL_MethodName_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblMethodName, gridBagConstraints);
        this.jTxtMethodName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                MessageSecurityEntryPanel.this.jTxtMethodNameKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jTxtMethodName, gridBagConstraints);
        this.jLblReqAuthSource.setDisplayedMnemonic(webserviceBundle.getString("MNE_ReqAuthSource").charAt(0));
        this.jLblReqAuthSource.setText(webserviceBundle.getString("LBL_ReqAuthSource_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblReqAuthSource, gridBagConstraints);
        this.jCbxReqAuthSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageSecurityEntryPanel.this.jCbxReqAuthSourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jCbxReqAuthSource, gridBagConstraints);
        this.jLblReqAuthRecip.setDisplayedMnemonic(webserviceBundle.getString("MNE_ReqAuthRecipient").charAt(0));
        this.jLblReqAuthRecip.setText(webserviceBundle.getString("LBL_ReqAuthRecipient_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblReqAuthRecip, gridBagConstraints);
        this.jCbxReqAuthRecip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageSecurityEntryPanel.this.jCbxReqAuthRecipActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jCbxReqAuthRecip, gridBagConstraints);
        this.jLblRespAuthSource.setDisplayedMnemonic(webserviceBundle.getString("MNE_RespAuthSource").charAt(0));
        this.jLblRespAuthSource.setText(webserviceBundle.getString("LBL_RespAuthSource_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblRespAuthSource, gridBagConstraints);
        this.jCbxRespAuthSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageSecurityEntryPanel.this.jCbxRespAuthSourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jCbxRespAuthSource, gridBagConstraints);
        this.jLblRespAuthRecip.setDisplayedMnemonic(webserviceBundle.getString("MNE_RespAuthRecipient").charAt(0));
        this.jLblRespAuthRecip.setText(webserviceBundle.getString("LBL_RespAuthRecipient_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.add((Component)this.jLblRespAuthRecip, gridBagConstraints);
        this.jCbxRespAuthRecip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageSecurityEntryPanel.this.jCbxRespAuthRecipActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.add((Component)this.jCbxRespAuthRecip, gridBagConstraints);
    }

    private void jTxtMethodNameKeyReleased(KeyEvent evt) {
        if (!this.initializingFields) {
            String oldMethodName = this.methodName;
            this.methodName = this.jTxtMethodName.getText().trim();
            if (!this.methodName.equals(oldMethodName)) {
                this.firePropertyChange("UserDataChanged", null, null);
            }
        }
    }

    private void jCbxRespAuthRecipActionPerformed(ActionEvent evt) {
        if (!this.initializingFields) {
            TextMapping authMapping = (TextMapping)this.authRespRecipientModel.getSelectedItem();
            this.respRecipient = this.normalizeBlank(authMapping.getXMLString());
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void jCbxRespAuthSourceActionPerformed(ActionEvent evt) {
        if (!this.initializingFields) {
            TextMapping authMapping = (TextMapping)this.authRespSourceModel.getSelectedItem();
            this.respSource = this.normalizeBlank(authMapping.getXMLString());
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void jCbxReqAuthRecipActionPerformed(ActionEvent evt) {
        if (!this.initializingFields) {
            TextMapping authMapping = (TextMapping)this.authReqRecipientModel.getSelectedItem();
            this.reqRecipient = this.normalizeBlank(authMapping.getXMLString());
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    private void jCbxReqAuthSourceActionPerformed(ActionEvent evt) {
        if (!this.initializingFields) {
            TextMapping authMapping = (TextMapping)this.authReqSourceModel.getSelectedItem();
            this.reqSource = this.normalizeBlank(authMapping.getXMLString());
            this.firePropertyChange("UserDataChanged", null, null);
        }
    }

    protected void initUserComponents() {
        int i;
        this.authReqSourceModel = new DefaultComboBoxModel();
        this.authRespSourceModel = new DefaultComboBoxModel();
        for (i = 0; i < sourceTypes.length; ++i) {
            this.authReqSourceModel.addElement(sourceTypes[i]);
            this.authRespSourceModel.addElement(sourceTypes[i]);
        }
        this.jCbxReqAuthSource.setModel(this.authReqSourceModel);
        this.jCbxRespAuthSource.setModel(this.authRespSourceModel);
        this.authReqRecipientModel = new DefaultComboBoxModel();
        this.authRespRecipientModel = new DefaultComboBoxModel();
        for (i = 0; i < recipientTypes.length; ++i) {
            this.authReqRecipientModel.addElement(recipientTypes[i]);
            this.authRespRecipientModel.addElement(recipientTypes[i]);
        }
        this.jCbxReqAuthRecip.setModel(this.authReqRecipientModel);
        this.jCbxRespAuthRecip.setModel(this.authRespRecipientModel);
    }

    private String normalizeBlank(String value) {
        return value != "" ? value : null;
    }

    private TextMapping getAuthMapping(String xmlKey, TextMapping[] authMap) {
        TextMapping result = null;
        if (xmlKey == null) {
            xmlKey = "";
        }
        for (int i = 0; i < authMap.length; ++i) {
            if (authMap[i].getXMLString().compareTo(xmlKey) != 0) continue;
            result = authMap[i];
            break;
        }
        return result;
    }

    public Collection getErrors(ValidationSupport validationSupport) {
        ArrayList<String> errorList;
        block5: {
            block6: {
                block4: {
                    errorList = new ArrayList<String>();
                    if (Utils.notEmpty(this.methodName)) break block4;
                    String msgPattern = webserviceBundle.getString("ERR_MethodNameRequired");
                    errorList.add(MessageFormat.format(msgPattern, new Integer(this.methodAsOperation ? 1 : 0)));
                    break block5;
                }
                if ("*".equals(this.methodName)) break block5;
                if (!this.methodAsOperation) break block6;
                if (Utils.isJavaIdentifier(this.methodName)) break block5;
                errorList.add(NbBundle.getMessage((Class)MessageSecurityEntryPanel.class, (String)"ERR_OperationNameInvalid", (Object)this.methodName));
                break block5;
            }
            String[] parts = MessageEntry.methodSplitter.split(this.methodName);
            if (parts.length > 0) {
                if (!Utils.isJavaIdentifier(parts[0])) {
                    errorList.add(NbBundle.getMessage((Class)MessageSecurityEntryPanel.class, (String)"ERR_JavaMethodInvalid", (Object)parts[0]));
                } else {
                    for (int i = 1; i < parts.length; ++i) {
                        if (Utils.isJavaClass(parts[i])) continue;
                        errorList.add(NbBundle.getMessage((Class)MessageSecurityEntryPanel.class, (String)"ERR_MethodParamInvalid", (Object)parts[i]));
                        break;
                    }
                }
            }
        }
        return errorList;
    }

    public Object[] getValues() {
        Object[] result = new Object[]{this.methodName, this.reqSource, this.reqRecipient, this.respSource, this.respRecipient};
        return result;
    }

    public void init(ASDDVersion asVersion, int preferredWidth, List entries, Object data) {
        if (data instanceof Boolean) {
            this.methodAsOperation = (Boolean)data;
        }
        this.setPreferredSize(new Dimension(preferredWidth, this.getPreferredSize().height));
    }

    public void setValues(Object[] values) {
        if (values != null && values.length == 5) {
            this.methodName = (String)values[0];
            this.reqSource = (String)values[1];
            this.reqRecipient = (String)values[2];
            this.respSource = (String)values[3];
            this.respRecipient = (String)values[4];
        } else {
            if (values != null && !$assertionsDisabled && values.length != 5) {
                throw new AssertionError();
            }
            this.methodName = "*";
            this.reqSource = null;
            this.reqRecipient = null;
            this.respSource = null;
            this.respRecipient = null;
        }
        this.setComponentValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setComponentValues() {
        try {
            this.initializingFields = true;
            this.jTxtMethodName.setText(this.methodName);
            this.jCbxReqAuthSource.setSelectedItem(this.getAuthMapping(this.reqSource, sourceTypes));
            this.jCbxReqAuthRecip.setSelectedItem(this.getAuthMapping(this.reqRecipient, recipientTypes));
            this.jCbxRespAuthSource.setSelectedItem(this.getAuthMapping(this.respSource, sourceTypes));
            this.jCbxRespAuthRecip.setSelectedItem(this.getAuthMapping(this.respRecipient, recipientTypes));
        }
        finally {
            this.initializingFields = false;
        }
    }

    public boolean requiredFieldsFilled() {
        return Utils.notEmpty(this.methodName);
    }

    static {
        $assertionsDisabled = !MessageSecurityEntryPanel.class.desiredAssertionStatus();
        webserviceBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle");
        commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
        sourceTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("sender", webserviceBundle.getString("AUTH_SOURCE_SENDER")), new TextMapping("content", webserviceBundle.getString("AUTH_SOURCE_CONTENT"))};
        recipientTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("before-content", webserviceBundle.getString("AUTH_RECIPIENT_BEFORE_CONTENT")), new TextMapping("after-content", webserviceBundle.getString("AUTH_RECIPIENT_AFTER_CONTENT"))};
    }
}

