/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.web.LocaleCharsetInfo;
import org.netbeans.modules.j2ee.sun.dd.api.web.LocaleCharsetMap;
import org.netbeans.modules.j2ee.sun.share.CharsetMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.ASDDVersion;
import org.netbeans.modules.j2ee.sun.share.configbean.StorageBeanFactory;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.WebAppRoot;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTableModel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.GenericTablePanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.LocaleCharsetMapEntryPanel;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.LocaleMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.WebAppRootCustomizer;

public class WebAppLocalePanel
extends JPanel
implements TableModelListener {
    private static final ResourceBundle webappBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.webapp.Bundle");
    private static final ResourceBundle commonBundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private WebAppRootCustomizer masterPanel;
    private String defaultCharset;
    private String formHintField;
    private DefaultComboBoxModel defaultCharsetCbxModel;
    private DefaultComboBoxModel defaultLocaleCbxModel;
    private GenericTableModel localeCharsetMapModel;
    private GenericTablePanel localeCharsetMapPanel;
    private PropertyChangeListener charsetChangeListener;
    private ButtonGroup jBtnGrpCharsetAliases;
    private JComboBox jCbxDefaultCharset;
    private JComboBox jCbxDefaultLocale;
    private JLabel jLabel1;
    private JLabel jLblDefaultCharset;
    private JLabel jLblDefaultLocale;
    private JLabel jLblFormHintField;
    private JLabel jLblParameterEncoding;
    private JPanel jPnlLocaleSettings;
    private JPanel jPnlParameterEncoding;
    private JTextField jTxtFormHintField;
    private ActionListener defaultLocaleActionListener;
    private ActionListener defaultCharsetActionListener;
    static GenericTableModel.ParentPropertyFactory localeCharsetMapFactory = new GenericTableModel.ParentPropertyFactory(){

        public CommonDDBean newParentProperty(ASDDVersion asVersion) {
            return StorageBeanFactory.getStorageBeanFactory(asVersion).createLocaleCharsetMap();
        }
    };

    public WebAppLocalePanel(WebAppRootCustomizer src) {
        this.masterPanel = src;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jBtnGrpCharsetAliases = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPnlLocaleSettings = new JPanel();
        this.jLblDefaultLocale = new JLabel();
        this.jCbxDefaultLocale = new JComboBox();
        this.jLblParameterEncoding = new JLabel();
        this.jPnlParameterEncoding = new JPanel();
        this.jLblDefaultCharset = new JLabel();
        this.jCbxDefaultCharset = new JComboBox();
        this.jLblFormHintField = new JLabel();
        this.jTxtFormHintField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_WebAppLocaleTab"));
        this.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_WebAppLocaleTab"));
        this.jLabel1.setText(webappBundle.getString("LBL_LocaleInfoPanelDescription"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPnlLocaleSettings.setLayout(new GridBagLayout());
        this.jLblDefaultLocale.setLabelFor(this.jCbxDefaultLocale);
        this.jLblDefaultLocale.setText(webappBundle.getString("LBL_DefaultLocaleMapping_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPnlLocaleSettings.add((Component)this.jLblDefaultLocale, gridBagConstraints);
        this.jCbxDefaultLocale.setPrototypeDisplayValue("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPnlLocaleSettings.add((Component)this.jCbxDefaultLocale, gridBagConstraints);
        this.jCbxDefaultLocale.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_DefaultLocaleMapping"));
        this.jCbxDefaultLocale.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_DefaultLocaleMapping"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add((Component)this.jPnlLocaleSettings, gridBagConstraints);
        this.jLblParameterEncoding.setLabelFor(this.jPnlParameterEncoding);
        this.jLblParameterEncoding.setText(webappBundle.getString("LBL_ParameterEncoding"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.jLblParameterEncoding, gridBagConstraints);
        this.jPnlParameterEncoding.setLayout(new GridBagLayout());
        this.jPnlParameterEncoding.setBorder(BorderFactory.createEtchedBorder());
        this.jLblDefaultCharset.setLabelFor(this.jCbxDefaultCharset);
        this.jLblDefaultCharset.setText(webappBundle.getString("LBL_DefaultCharset_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPnlParameterEncoding.add((Component)this.jLblDefaultCharset, gridBagConstraints);
        this.jCbxDefaultCharset.setPrototypeDisplayValue("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.jPnlParameterEncoding.add((Component)this.jCbxDefaultCharset, gridBagConstraints);
        this.jCbxDefaultCharset.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_DefaultCharset"));
        this.jCbxDefaultCharset.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_DefaultCharset"));
        this.jLblFormHintField.setLabelFor(this.jTxtFormHintField);
        this.jLblFormHintField.setText(webappBundle.getString("LBL_FormHintField_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.jPnlParameterEncoding.add((Component)this.jLblFormHintField, gridBagConstraints);
        this.jTxtFormHintField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                WebAppLocalePanel.this.jTxtFormHintFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.jPnlParameterEncoding.add((Component)this.jTxtFormHintField, gridBagConstraints);
        this.jTxtFormHintField.getAccessibleContext().setAccessibleName(webappBundle.getString("ACSN_FormHintField"));
        this.jTxtFormHintField.getAccessibleContext().setAccessibleDescription(webappBundle.getString("ACSD_FormHintField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 5);
        this.add((Component)this.jPnlParameterEncoding, gridBagConstraints);
    }

    private void jTxtFormHintFieldKeyReleased(KeyEvent evt) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            LocaleCharsetInfo localeInfo = bean.getLocaleCharsetInfo();
            this.formHintField = this.jTxtFormHintField.getText();
            localeInfo.setParameterEncodingFormHintField(this.formHintField);
            localeInfo.setParameterEncoding(this.hasParameterEncoding());
            bean.setDirty();
            this.masterPanel.validateField("locale-charset-info/parameter-encoding/form-hint-field");
        }
    }

    private void jCbxDefaultCharsetActionPerformed(ActionEvent evt) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            LocaleCharsetInfo localeInfo = bean.getLocaleCharsetInfo();
            Object item = this.defaultCharsetCbxModel.getSelectedItem();
            if (item instanceof CharsetMapping) {
                this.defaultCharset = ((CharsetMapping)item).getAlias();
                localeInfo.setParameterEncodingDefaultCharset(this.defaultCharset);
            } else {
                this.defaultCharset = null;
                localeInfo.setParameterEncodingDefaultCharset(null);
            }
            localeInfo.setParameterEncoding(this.hasParameterEncoding());
            bean.setDirty();
        }
    }

    private void jCbxDefaultLocaleActionPerformed(ActionEvent evt) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            LocaleCharsetInfo localeInfo = bean.getLocaleCharsetInfo();
            Object item = this.defaultLocaleCbxModel.getSelectedItem();
            if (item instanceof LocaleMapping) {
                localeInfo.setDefaultLocale(((LocaleMapping)item).getLocale().toString());
            } else {
                localeInfo.setDefaultLocale(null);
            }
            bean.setDirty();
        }
    }

    private void initUserComponents() {
        this.defaultLocaleActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebAppLocalePanel.this.jCbxDefaultLocaleActionPerformed(evt);
            }
        };
        this.defaultCharsetCbxModel = new DefaultComboBoxModel();
        this.defaultCharsetCbxModel.addElement("");
        SortedMap charsets = CharsetMapping.getSortedAvailableCharsetMappings();
        Iterator iter = charsets.entrySet().iterator();
        while (iter.hasNext()) {
            CharsetMapping cm = (CharsetMapping)iter.next().getValue();
            this.defaultCharsetCbxModel.addElement(cm);
        }
        this.jCbxDefaultCharset.setModel(this.defaultCharsetCbxModel);
        this.defaultCharsetActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebAppLocalePanel.this.jCbxDefaultCharsetActionPerformed(evt);
            }
        };
        ArrayList<GenericTableModel.TableEntry> tableColumns = new ArrayList<GenericTableModel.TableEntry>(4);
        tableColumns.add(new GenericTableModel.AttributeEntry("Locale", webappBundle.getString("LBL_Locale"), true));
        tableColumns.add(new GenericTableModel.AttributeEntry("Charset", webappBundle.getString("LBL_CharacterSet"), true));
        tableColumns.add(new GenericTableModel.AttributeEntry("Agent", webappBundle.getString("LBL_Agent")));
        tableColumns.add(new GenericTableModel.ValueEntry("Description", webappBundle.getString("LBL_LocaleDescription")));
        this.localeCharsetMapModel = new LocaleCharsetTableModel(tableColumns);
        this.localeCharsetMapPanel = new GenericTablePanel(this.localeCharsetMapModel, webappBundle, "LocaleCharsetMapping", LocaleCharsetMapEntryPanel.class, "AS_CFG_WebAppLocaleCharsetMapping");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 5);
        this.add((Component)this.localeCharsetMapPanel, gridBagConstraints);
        this.charsetChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                WebAppLocalePanel.this.updateDefaultCharsetModel();
            }
        };
    }

    public void addListeners() {
        this.localeCharsetMapModel.addTableModelListener(this);
        this.jCbxDefaultLocale.addActionListener(this.defaultLocaleActionListener);
        this.jCbxDefaultCharset.addActionListener(this.defaultCharsetActionListener);
        CharsetMapping.addPropertyChangeListener(this.charsetChangeListener);
    }

    public void removeListeners() {
        this.localeCharsetMapModel.removeTableModelListener(this);
        this.jCbxDefaultLocale.removeActionListener(this.defaultLocaleActionListener);
        this.jCbxDefaultCharset.removeActionListener(this.defaultCharsetActionListener);
        CharsetMapping.removePropertyChangeListener(this.charsetChangeListener);
    }

    public void initFields(WebAppRoot bean) {
        LocaleCharsetInfo localeInfo = bean.getLocaleCharsetInfo();
        if (this.enableDefaultFields(localeInfo.sizeLocaleCharsetMap() > 0)) {
            this.defaultLocaleCbxModel = this.getDefaultLocales(localeInfo);
            this.jCbxDefaultLocale.setModel(this.defaultLocaleCbxModel);
            this.defaultLocaleCbxModel.setSelectedItem(LocaleMapping.getLocaleMapping(localeInfo.getDefaultLocale()));
            if (localeInfo.isParameterEncoding()) {
                this.defaultCharset = localeInfo.getParameterEncodingDefaultCharset();
                this.formHintField = localeInfo.getParameterEncodingFormHintField();
                this.defaultCharsetCbxModel.setSelectedItem(CharsetMapping.getCharsetMapping(this.defaultCharset));
            } else {
                this.defaultCharset = null;
                this.formHintField = "";
                this.defaultCharsetCbxModel.setSelectedItem(this.defaultCharset);
            }
            this.jTxtFormHintField.setText(this.formHintField);
        } else {
            this.jCbxDefaultLocale.setSelectedItem(null);
            this.jCbxDefaultCharset.setSelectedItem(null);
            this.jTxtFormHintField.setText("");
        }
        this.localeCharsetMapPanel.setModel((CommonDDBean)localeInfo, bean.getAppServerVersion());
    }

    private boolean enableDefaultFields(boolean hasMappings) {
        this.jLblDefaultLocale.setEnabled(hasMappings);
        this.jCbxDefaultLocale.setEnabled(hasMappings);
        this.jLblParameterEncoding.setEnabled(hasMappings);
        this.jLblDefaultCharset.setEnabled(hasMappings);
        this.jCbxDefaultCharset.setEnabled(hasMappings);
        this.jLblFormHintField.setEnabled(hasMappings);
        this.jTxtFormHintField.setEnabled(hasMappings);
        this.jTxtFormHintField.setEditable(hasMappings);
        return hasMappings;
    }

    private boolean hasParameterEncoding() {
        return Utils.notEmpty(this.defaultCharset) || Utils.notEmpty(this.formHintField);
    }

    private DefaultComboBoxModel getDefaultLocales(LocaleCharsetInfo localeInfo) {
        DefaultComboBoxModel<LocaleMapping> defaultLocaleModel = new DefaultComboBoxModel<LocaleMapping>();
        if (localeInfo.sizeLocaleCharsetMap() > 0) {
            LocaleCharsetMap[] maps = localeInfo.getLocaleCharsetMap();
            for (int i = 0; i < maps.length; ++i) {
                LocaleMapping lm = LocaleMapping.getLocaleMapping(maps[i].getLocale());
                if (lm == null) continue;
                defaultLocaleModel.addElement(lm);
            }
        }
        return defaultLocaleModel;
    }

    private void updateDefaultLocale(LocaleCharsetInfo localeInfo) {
        int oldSize = this.defaultLocaleCbxModel != null ? this.defaultLocaleCbxModel.getSize() : 0;
        this.defaultLocaleCbxModel = this.getDefaultLocales(localeInfo);
        this.jCbxDefaultLocale.setModel(this.defaultLocaleCbxModel);
        int newSize = this.defaultLocaleCbxModel.getSize();
        if (oldSize == 0 && newSize > 0) {
            LocaleMapping lm = (LocaleMapping)this.defaultLocaleCbxModel.getElementAt(0);
            localeInfo.setDefaultLocale(lm.getLocale().toString());
            this.defaultLocaleCbxModel.setSelectedItem(lm);
        } else {
            LocaleMapping lm = LocaleMapping.getLocaleMapping(localeInfo.getDefaultLocale());
            if (this.defaultLocaleCbxModel.getIndexOf(lm) >= 0) {
                localeInfo.setDefaultLocale(lm.getLocale().toString());
                this.defaultLocaleCbxModel.setSelectedItem(lm);
            } else {
                localeInfo.setDefaultLocale(null);
                this.defaultCharset = null;
                localeInfo.setParameterEncodingDefaultCharset(null);
                this.defaultCharsetCbxModel.setSelectedItem(null);
                this.formHintField = null;
                localeInfo.setParameterEncodingFormHintField(null);
                this.jTxtFormHintField.setText(null);
                this.masterPanel.validateField("locale-charset-info/parameter-encoding/form-hint-field");
            }
        }
        this.enableDefaultFields(localeInfo.sizeLocaleCharsetMap() > 0);
    }

    private void updateDefaultCharsetModel() {
        Object mapping = this.defaultCharsetCbxModel.getSelectedItem();
        CharsetMapping oldMapping = mapping instanceof CharsetMapping ? (CharsetMapping)mapping : null;
        this.defaultCharsetCbxModel = new DefaultComboBoxModel();
        this.defaultCharsetCbxModel.addElement("");
        SortedMap charsets = CharsetMapping.getSortedAvailableCharsetMappings();
        Iterator iter = charsets.entrySet().iterator();
        while (iter.hasNext()) {
            CharsetMapping cm = (CharsetMapping)iter.next().getValue();
            this.defaultCharsetCbxModel.addElement(cm);
        }
        this.jCbxDefaultCharset.setModel(this.defaultCharsetCbxModel);
        if (oldMapping != null) {
            oldMapping = CharsetMapping.getCharsetMapping(oldMapping.getCharset());
        }
        this.defaultCharsetCbxModel.setSelectedItem(oldMapping);
    }

    public void tableChanged(TableModelEvent e) {
        WebAppRoot bean = this.masterPanel.getBean();
        if (bean != null) {
            if (e.getSource() == this.localeCharsetMapModel) {
                this.updateDefaultLocale(bean.getLocaleCharsetInfo());
            }
            bean.setDirty();
        }
    }

    private static class LocaleCharsetTableModel
    extends GenericTableModel {
        public LocaleCharsetTableModel(List tableColumns) {
            super("LocaleCharsetMap", localeCharsetMapFactory, tableColumns);
        }

        public boolean alreadyExists(Object[] values) {
            boolean exists = false;
            List children = this.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                LocaleCharsetMap map = (LocaleCharsetMap)iter.next();
                if (!this.match((String)values[0], map.getLocale()) || !this.match((String)values[1], map.getCharset()) || !this.match((String)values[2], map.getAgent())) continue;
                exists = true;
                break;
            }
            return exists;
        }

        private final boolean match(String a, String b) {
            boolean result = false;
            if (a == b) {
                result = true;
            } else if (a != null && b != null && a.equals(b)) {
                result = true;
            }
            return result;
        }

        public boolean alreadyExists(String keyPropertyValue) {
            return false;
        }
    }
}

