/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.Utils;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchType;

public final class SearchPerformer
extends NodeAction {
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage((Class)SearchPerformer.class, (String)"TEXT_FIND_ACTION_IMPL_NAME");
    }

    static List getTypes(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return Collections.EMPTY_LIST;
        }
        Iterator it = Utils.getSearchTypes().iterator();
        if (!it.hasNext()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<SearchType> result = new ArrayList<SearchType>(5);
        do {
            SearchType searchType;
            if (!(searchType = (SearchType)it.next()).enabled(nodes) || result.contains(searchType)) continue;
            result.add(searchType);
        } while (it.hasNext());
        return result;
    }

    public boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (SearchPerformer.canSearch(nodes[i])) continue;
            return false;
        }
        Iterator it = Utils.getSearchTypes().iterator();
        while (it.hasNext()) {
            SearchType searchType = (SearchType)it.next();
            if (!searchType.enabled(nodes)) continue;
            return true;
        }
        return false;
    }

    private static boolean canSearch(Node node) {
        Lookup nodeLookup = node.getLookup();
        SearchInfo searchInfo = (SearchInfo)nodeLookup.lookup(SearchInfo.class);
        if (searchInfo != null) {
            return searchInfo.canSearch();
        }
        return nodeLookup.lookup(DataObject.Container.class) != null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodes) {
        Object title;
        List searchTypeList = SearchPerformer.getTypes(nodes);
        if (searchTypeList.isEmpty()) {
            return;
        }
        ArrayList<Object> clonedSearchTypeList = new ArrayList<Object>(searchTypeList.size());
        Iterator it = searchTypeList.iterator();
        while (it.hasNext()) {
            clonedSearchTypeList.add(((SearchType)it.next()).clone());
        }
        SearchPanel searchPanel = new SearchPanel(clonedSearchTypeList);
        if (nodes.length == 1 && (title = nodes[0].getValue("Find Files dialog title")) != null && title instanceof String) {
            searchPanel.setTitle((String)title);
        }
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() != 1) {
            return;
        }
        ResultView resultView = ResultView.getInstance();
        resultView.rememberInput(nodes, Utils.cloneSearchTypes(clonedSearchTypeList));
        resultView.open();
        resultView.requestActive();
        Manager.getInstance().scheduleSearchTask(new SearchTask(nodes, clonedSearchTypeList, searchPanel.getCustomizedSearchTypes()));
    }
}

