/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.derby.DerbyOptions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public class Util {
    private Util() {
    }

    public static boolean hasInstallLocation() {
        return Util.getCheckedLocation() != null;
    }

    private static File getCheckedLocation() {
        File location = new File(DerbyOptions.getDefault().getLocation());
        if (location.isAbsolute() && location.isDirectory() && location.exists()) {
            return location;
        }
        return null;
    }

    public static File getDerbyFile(String relPath) {
        File location = Util.getCheckedLocation();
        if (location != null) {
            return new File(location, relPath);
        }
        return null;
    }

    public static void showInformation(final String msg) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZip(File source, FileObject target) throws IOException {
        FileInputStream is = new FileInputStream(source);
        try {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(is);
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (ze.isDirectory()) {
                    FileUtil.createFolder((FileObject)target, (String)name);
                    continue;
                }
                FileObject fd = FileUtil.createData((FileObject)target, (String)name);
                FileLock lock = fd.lock();
                try {
                    OutputStream os = fd.getOutputStream(lock);
                    try {
                        FileUtil.copy((InputStream)zis, (OutputStream)os);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            is.close();
        }
    }
}

