/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openide.nodes.Node;
import org.openidex.search.CompoundSearchIterator;
import org.openidex.search.SearchInfo;
import org.openidex.search.SimpleSearchInfo;
import org.openidex.search.Utils;

final class SubnodesSearchInfo
implements SearchInfo {
    private final Node node;

    public SubnodesSearchInfo(Node node) {
        this.node = node;
    }

    public boolean canSearch() {
        Node[] nodes = this.node.getChildren().getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            SearchInfo searchInfo = Utils.getSearchInfo(nodes[i]);
            if (searchInfo == null || !searchInfo.canSearch()) continue;
            return true;
        }
        return false;
    }

    public Iterator objectsToSearch() {
        Node[] nodes = this.node.getChildren().getNodes(true);
        if (nodes.length == 0) {
            return SimpleSearchInfo.EMPTY_SEARCH_INFO.objectsToSearch();
        }
        ArrayList<SearchInfo> searchInfoElements = new ArrayList<SearchInfo>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            SearchInfo subInfo = Utils.getSearchInfo(nodes[i]);
            if (subInfo == null || !subInfo.canSearch()) continue;
            searchInfoElements.add(subInfo);
        }
        int size = searchInfoElements.size();
        switch (size) {
            case 0: {
                return Collections.EMPTY_LIST.iterator();
            }
            case 1: {
                return ((SearchInfo)searchInfoElements.get(0)).objectsToSearch();
            }
        }
        return new CompoundSearchIterator(searchInfoElements.toArray(new SearchInfo[size]));
    }
}

