/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ToolTipManager
extends MouseAdapter
implements MouseMotionListener {
    private static ToolTipManager shared;
    private static Component currentComponent;
    private static JToolTip currentTip;
    private static Point currentPoint;
    private static Popup popup;
    Timer enterTimer;
    Timer exitTimer;
    Timer insideTimer;
    private transient boolean enabled;
    protected boolean lightWeightPopupEnabled;
    protected boolean heavyWeightPopupEnabled;
    static /* synthetic */ Class class$javax$swing$JRootPane;

    public static ToolTipManager sharedInstance() {
        if (shared == null) {
            shared = new ToolTipManager();
        }
        return shared;
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.enterTimer.stop();
            this.exitTimer.stop();
            this.insideTimer.stop();
        }
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopupEnabled = bl;
        this.heavyWeightPopupEnabled = bl ^ true;
    }

    public int getInitialDelay() {
        return this.enterTimer.getDelay();
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setDelay(n);
    }

    public int getDismissDelay() {
        return this.insideTimer.getDelay();
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setDelay(n);
    }

    public int getReshowDelay() {
        return this.exitTimer.getDelay();
    }

    public void setReshowDelay(int n) {
        this.exitTimer.setDelay(n);
    }

    public void registerComponent(JComponent jComponent) {
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this);
    }

    public void unregisterComponent(JComponent jComponent) {
        jComponent.removeMouseMotionListener(this);
        jComponent.removeMouseListener(this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (currentComponent != null && this.getContentPaneDeepestComponent(mouseEvent) == currentComponent) {
            return;
        }
        currentPoint = mouseEvent.getPoint();
        currentComponent = (Component)mouseEvent.getSource();
        if (this.exitTimer.isRunning()) {
            this.exitTimer.stop();
            this.showTip();
            return;
        }
        if (!this.enterTimer.isRunning()) {
            this.enterTimer.start();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.getContentPaneDeepestComponent(mouseEvent) == currentComponent) {
            return;
        }
        currentPoint = mouseEvent.getPoint();
        currentComponent = null;
        this.hideTip();
        if (!this.enterTimer.isRunning()) {
            this.exitTimer.start();
        }
        if (this.enterTimer.isRunning()) {
            this.enterTimer.stop();
        }
        if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        currentPoint = mouseEvent.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        } else if (this.insideTimer.isRunning()) {
            this.insideTimer.stop();
            this.hideTip();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        currentPoint = mouseEvent.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        currentPoint = mouseEvent.getPoint();
        if (this.enterTimer.isRunning()) {
            this.enterTimer.restart();
        }
    }

    void showTip() {
        JRootPane jRootPane;
        if (!(this.enabled && currentComponent != null && currentComponent.isEnabled() && currentComponent.isShowing())) {
            popup = null;
            return;
        }
        if (currentTip == null || currentTip.getComponent() != currentComponent && currentComponent instanceof JComponent) {
            currentTip = ((JComponent)currentComponent).createToolTip();
        }
        Point point = currentPoint;
        Point point2 = currentComponent.getLocationOnScreen();
        Dimension dimension = currentTip.getPreferredSize();
        JLayeredPane jLayeredPane = null;
        Class clazz = class$javax$swing$JRootPane;
        if (clazz == null) {
            clazz = class$javax$swing$JRootPane = ToolTipManager.class("[Ljavax.swing.JRootPane;", false);
        }
        if ((jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(clazz, currentComponent)) != null) {
            jLayeredPane = jRootPane.getLayeredPane();
        }
        if (jLayeredPane == null) {
            return;
        }
        point.translate(point2.x, point2.y);
        this.adjustLocation(point, jLayeredPane, dimension);
        currentTip.setBounds(0, 0, dimension.width, dimension.height);
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        popup = popupFactory.getPopup(currentComponent, currentTip, point.x, point.y);
        popup.show();
    }

    private final Point adjustLocation(Point point, Component component, Dimension dimension) {
        if (point.x + dimension.width > component.getWidth()) {
            point.x -= dimension.width;
        }
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y + dimension.height < component.getHeight()) {
            point.y += dimension.height;
        }
        if (point.y + dimension.height > component.getHeight()) {
            point.y -= dimension.height;
        }
        return point;
    }

    void hideTip() {
        if (popup != null) {
            popup.hide();
        }
    }

    private final Component getContentPaneDeepestComponent(MouseEvent mouseEvent) {
        Container container;
        Component component = (Component)mouseEvent.getSource();
        Class clazz = class$javax$swing$JRootPane;
        if (clazz == null) {
            clazz = class$javax$swing$JRootPane = ToolTipManager.class("[Ljavax.swing.JRootPane;", false);
        }
        if ((container = SwingUtilities.getAncestorOfClass(clazz, currentComponent)) == null) {
            return null;
        }
        container = ((JRootPane)container).getContentPane();
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint(component, point, container);
        Component component2 = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        return component2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.enabled = true;
        this.lightWeightPopupEnabled = true;
        this.heavyWeightPopupEnabled = false;
    }

    ToolTipManager() {
        this.this();
        this.enterTimer = new Timer(750, new insideTimerAction());
        this.enterTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class insideTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.showTip();
        }

        protected insideTimerAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class stillInsideTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ToolTipManager.this.hideTip();
        }

        protected stillInsideTimerAction() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class outsideTimerAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
        }

        protected outsideTimerAction() {
        }
    }
}

