/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.print.attribute.IntegerSyntax;

public abstract class SetOfIntegerSyntax
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3666874174847632203L;
    private int[][] members;

    private static final int[][] normalize(int[][] nArray, int n) {
        Arrays.sort((Object[])nArray, 0, n, new Comparator(){

            public final int compare(Object object, Object object2) {
                int[] nArray = (int[])object;
                int[] nArray2 = (int[])object2;
                if (nArray[0] == nArray2[0]) {
                    return nArray[1] - nArray2[1];
                }
                return nArray[0] - nArray2[0];
            }
        });
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3;
            while (n3 + 1 < n && nArray[n3 + 1][0] <= nArray[n3][1] + 1) {
                nArray[n3][1] = Math.max(nArray[n3][1], nArray[n3 + 1][1]);
                ++n3;
            }
            nArray[n2++] = nArray[n4];
            ++n3;
        }
        int[][] nArrayArray = new int[n2][];
        System.arraycopy(nArray, 0, nArrayArray, 0, n2);
        return nArrayArray;
    }

    private final boolean skipWhitespace(StringCharacterIterator stringCharacterIterator) {
        while (Character.isWhitespace(stringCharacterIterator.current())) {
            stringCharacterIterator.next();
        }
        boolean bl = false;
        if (stringCharacterIterator.current() == (char)-1) {
            bl = true;
        }
        return bl;
    }

    private final boolean skipNumber(StringCharacterIterator stringCharacterIterator) {
        boolean bl = false;
        while (Character.isDigit(stringCharacterIterator.current())) {
            bl = true;
            stringCharacterIterator.next();
        }
        return bl;
    }

    public boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.members.length) {
            if (n < this.members[n2][0]) {
                return false;
            }
            if (n <= this.members[n2][1]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean contains(IntegerSyntax integerSyntax) {
        return this.contains(integerSyntax.getValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof SetOfIntegerSyntax)) {
            return false;
        }
        SetOfIntegerSyntax setOfIntegerSyntax = (SetOfIntegerSyntax)object;
        if (setOfIntegerSyntax.members.length != this.members.length) {
            return false;
        }
        int n = 0;
        while (n < this.members.length) {
            if (this.members[n][0] != setOfIntegerSyntax.members[n][0] || this.members[n][1] != setOfIntegerSyntax.members[n][1]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int[][] getMembers() {
        return (int[][])this.members.clone();
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.members.length) {
            n += this.members[n2][0] + this.members[n2][1];
            ++n2;
        }
        return n;
    }

    public int next(int n) {
        int n2 = 0;
        while (n2 < this.members.length) {
            if (n < this.members[n2][1]) {
                if (n < this.members[n2][0]) {
                    return this.members[n2][0];
                }
                return n + 1;
            }
            ++n2;
        }
        return -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.members.length) {
            if (n > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.members[n][0]);
            if (this.members[n][0] != this.members[n][1]) {
                stringBuilder.append('-');
                stringBuilder.append(this.members[n][1]);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    protected SetOfIntegerSyntax(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("member may not be less than 0");
        }
        this.members = new int[][]{{n, n}};
    }

    protected SetOfIntegerSyntax(int[][] nArray) {
        int[][] nArrayArray;
        int n = 0;
        if (nArray == null) {
            nArrayArray = new int[][]{};
        } else {
            nArrayArray = new int[nArray.length][];
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3;
                int n4;
                if (nArray[n2].length == 1) {
                    n4 = nArray[n2][0];
                    n3 = nArray[n2][0];
                } else if (nArray[n2].length == 2) {
                    n4 = nArray[n2][0];
                    n3 = nArray[n2][1];
                } else {
                    throw new IllegalArgumentException("invalid member element");
                }
                if (n4 <= n3 && n4 < 0) {
                    throw new IllegalArgumentException("invalid member element");
                }
                if (n4 <= n3) {
                    int[] nArray2 = new int[]{n4, n3};
                    nArrayArray[n++] = nArray2;
                }
                ++n2;
            }
        }
        this.members = SetOfIntegerSyntax.normalize(nArrayArray, n);
    }

    protected SetOfIntegerSyntax(String string) {
        if (string == null) {
            this.members = SetOfIntegerSyntax.normalize(new int[0][], 0);
        } else {
            ArrayList arrayList = new ArrayList();
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            while (!this.skipWhitespace(stringCharacterIterator)) {
                int n = stringCharacterIterator.getIndex();
                if (!this.skipNumber(stringCharacterIterator)) {
                    throw new IllegalArgumentException();
                }
                int[] nArray = new int[2];
                nArray[0] = Integer.parseInt(string.substring(n, stringCharacterIterator.getIndex()));
                if (!this.skipWhitespace(stringCharacterIterator)) {
                    char c = stringCharacterIterator.current();
                    if (c == ':' || c == '-') {
                        stringCharacterIterator.next();
                        if (this.skipWhitespace(stringCharacterIterator)) {
                            throw new IllegalArgumentException();
                        }
                        n = stringCharacterIterator.getIndex();
                        if (!this.skipNumber(stringCharacterIterator)) {
                            throw new IllegalArgumentException();
                        }
                        nArray[1] = Integer.parseInt(string.substring(n, stringCharacterIterator.getIndex()));
                    } else {
                        nArray[1] = nArray[0];
                    }
                } else {
                    nArray[1] = nArray[0];
                }
                if (nArray[0] <= nArray[1]) {
                    arrayList.add(nArray);
                }
                if (this.skipWhitespace(stringCharacterIterator)) break;
                if (stringCharacterIterator.current() != ',') {
                    throw new IllegalArgumentException();
                }
                stringCharacterIterator.next();
            }
            this.members = SetOfIntegerSyntax.normalize((int[][])arrayList.toArray((Object[])new int[0][]), arrayList.size());
        }
    }

    protected SetOfIntegerSyntax(int n, int n2) {
        int[][] nArrayArray;
        if (n <= n2 && n < 0) {
            throw new IllegalArgumentException();
        }
        if (n <= n2) {
            int[][] nArrayArray2 = new int[1][];
            nArrayArray = nArrayArray2;
            nArrayArray2[0] = new int[]{n, n2};
        } else {
            nArrayArray = new int[][]{};
        }
        this.members = nArrayArray;
    }
}

