/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class Cipher {
    private static final String SERVICE = "Cipher";
    public static final int DECRYPT_MODE = 2;
    public static final int ENCRYPT_MODE = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int PUBLIC_KEY = 1;
    public static final int SECRET_KEY = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    private static final int INITIAL_STATE = 0;
    private CipherSpi cipherSpi;
    private Provider provider;
    private String transformation;
    private int state;

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider[] providerArray = Security.getProviders();
        NoSuchPaddingException noSuchPaddingException = null;
        String string2 = "";
        int n = 0;
        while (n < providerArray.length) {
            try {
                return Cipher.getInstance(string, providerArray[n]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                string2 = noSuchAlgorithmException.getMessage();
                noSuchPaddingException = null;
            }
            catch (NoSuchPaddingException noSuchPaddingException2) {
                noSuchPaddingException = noSuchPaddingException2;
            }
            ++n;
        }
        if (noSuchPaddingException != null) {
            throw noSuchPaddingException;
        }
        throw new NoSuchAlgorithmException(string2);
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return Cipher.getInstance(string, provider);
    }

    public static final Cipher getInstance(String string, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        CipherSpi cipherSpi = null;
        Object var3_3 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "";
        if (string.indexOf(47) < 0) {
            try {
                cipherSpi = (CipherSpi)Engine.getInstance(SERVICE, string, provider);
                return new Cipher(cipherSpi, provider, string);
            }
            catch (Exception exception) {
                string5 = exception.getMessage();
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if (stringTokenizer.countTokens() != 3) {
                throw new NoSuchAlgorithmException("badly formed transformation");
            }
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            string4 = stringTokenizer.nextToken();
            try {
                cipherSpi = (CipherSpi)Engine.getInstance(SERVICE, string, provider);
                return new Cipher(cipherSpi, provider, string);
            }
            catch (Exception exception) {
                string5 = exception.getMessage();
                try {
                    cipherSpi = (CipherSpi)Engine.getInstance(SERVICE, string2 + '/' + string3, provider);
                    cipherSpi.engineSetPadding(string4);
                    return new Cipher(cipherSpi, provider, string);
                }
                catch (Exception exception2) {
                    if (exception2 instanceof NoSuchPaddingException) {
                        throw (NoSuchPaddingException)exception2;
                    }
                    string5 = exception2.getMessage();
                    try {
                        cipherSpi = (CipherSpi)Engine.getInstance(SERVICE, string2 + "//" + string4, provider);
                        cipherSpi.engineSetMode(string3);
                        return new Cipher(cipherSpi, provider, string);
                    }
                    catch (Exception exception3) {
                        string5 = exception3.getMessage();
                        try {
                            cipherSpi = (CipherSpi)Engine.getInstance(SERVICE, string2, provider);
                            cipherSpi.engineSetMode(string3);
                            cipherSpi.engineSetPadding(string4);
                            return new Cipher(cipherSpi, provider, string);
                        }
                        catch (Exception exception4) {
                            if (exception4 instanceof NoSuchPaddingException) {
                                throw (NoSuchPaddingException)exception4;
                            }
                            string5 = exception4.getMessage();
                        }
                    }
                }
            }
        }
        throw new NoSuchAlgorithmException(string + ": " + string5);
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        if (this.cipherSpi != null) {
            return this.cipherSpi.engineGetBlockSize();
        }
        return 1;
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public final byte[] getIV() {
        if (this.cipherSpi != null) {
            return this.cipherSpi.engineGetIV();
        }
        return null;
    }

    public final AlgorithmParameters getParameters() {
        if (this.cipherSpi != null) {
            return this.cipherSpi.engineGetParameters();
        }
        return null;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(new byte[0], 0, 0);
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(byArray, 0, byArray.length);
    }

    public final byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.cipherSpi == null) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2);
    }

    public final int doFinal(byte[] byArray, int n) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (this.cipherSpi == null) {
            return 0;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        return this.cipherSpi.engineDoFinal(new byte[0], 0, 0, byArray, n);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (this.cipherSpi == null) {
            if (n2 > byArray2.length - n3) {
                throw new ShortBufferException();
            }
            System.arraycopy(byArray, n, byArray2, n3, n2);
            return n2;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public final int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        return this.doFinal(byArray, n, n2, byArray2, 0);
    }

    public final int doFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ReadOnlyBufferException, ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        if (byteBuffer == byteBuffer2) {
            throw new IllegalArgumentException("input and output buffers cannot be the same");
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("not initialized for encrypting or decrypting");
        }
        return this.cipherSpi.engineDoFinal(byteBuffer, byteBuffer2);
    }

    public final int getOutputSize(int n) throws IllegalStateException {
        if (this.cipherSpi == null) {
            return n;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        return this.cipherSpi.engineGetOutputSize(n);
    }

    public final void init(int n, Certificate certificate) throws InvalidKeyException {
        this.init(n, certificate, new SecureRandom());
    }

    public final void init(int n, Key key) throws InvalidKeyException {
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(n, key, new SecureRandom());
        }
        this.state = n;
    }

    public final void init(int n, Certificate certificate, SecureRandom secureRandom) throws InvalidKeyException {
        boolean[] blArray;
        if (certificate instanceof X509Certificate && (blArray = ((X509Certificate)certificate).getKeyUsage()) != null) {
            switch (n) {
                case 2: {
                    if (!blArray[3]) {
                        throw new InvalidKeyException("the certificate's key cannot be used for transforming data");
                    }
                    if (!blArray[7]) break;
                    throw new InvalidKeyException("the certificate's key can only be used for encryption");
                }
                case 1: {
                    if (!blArray[3]) {
                        throw new InvalidKeyException("the certificate's key cannot be used for transforming data");
                    }
                    if (!blArray[8]) break;
                    throw new InvalidKeyException("the certificate's key can only be used for decryption");
                }
                case 4: {
                    if (blArray[2] && !blArray[7]) break;
                    throw new InvalidKeyException("the certificate's key cannot be used for key unwrapping");
                }
                case 3: {
                    if (blArray[2] && !blArray[8]) break;
                    throw new InvalidKeyException("the certificate's key cannot be used for key wrapping");
                }
            }
        }
        this.init(n, (Key)certificate.getPublicKey(), secureRandom);
    }

    public final void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(n, key, secureRandom);
        }
        this.state = n;
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameters, new SecureRandom());
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameterSpec, new SecureRandom());
    }

    public final void init(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(n, key, algorithmParameters, secureRandom);
        }
        this.state = n;
    }

    public final void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(n, key, algorithmParameterSpec, secureRandom);
        }
        this.state = n;
    }

    public final Key unwrap(byte[] byArray, String string, int n) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (this.cipherSpi == null) {
            return null;
        }
        if (this.state != 4) {
            throw new IllegalStateException("instance is not for unwrapping");
        }
        return this.cipherSpi.engineUnwrap(byArray, string, n);
    }

    public final byte[] update(byte[] byArray) throws IllegalStateException {
        return this.update(byArray, 0, byArray.length);
    }

    public final byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.cipherSpi == null) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            return byArray2;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("cipher is not for encrypting or decrypting");
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        return this.update(byArray, n, n2, byArray2, 0);
    }

    public final int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException {
        if (this.cipherSpi == null) {
            if (n2 > byArray2.length - n3) {
                throw new ShortBufferException();
            }
            System.arraycopy(byArray, n, byArray2, n3, n2);
            return n2;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("cipher is not for encrypting or decrypting");
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2, byArray2, n3);
    }

    public final int update(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ReadOnlyBufferException, ShortBufferException {
        if (byteBuffer == byteBuffer2) {
            throw new IllegalArgumentException("input and output buffers must be different");
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("not initialized for encryption or decryption");
        }
        return this.cipherSpi.engineUpdate(byteBuffer, byteBuffer2);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        if (this.cipherSpi == null) {
            return null;
        }
        if (this.state != 3) {
            throw new IllegalStateException("instance is not for key wrapping");
        }
        return this.cipherSpi.engineWrap(key);
    }

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = string;
        this.state = 0;
    }
}

