/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class MultiPixelPackedSampleModel
extends SampleModel {
    private int scanlineStride;
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;
    private int dataBitOffset;
    private int elemBits;
    private int numberOfBits;
    private int numElems;

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return new MultiPixelPackedSampleModel(this.dataType, n, n2, this.numberOfBits);
    }

    public DataBuffer createDataBuffer() {
        int n = this.scanlineStride * this.height;
        return Buffers.createBuffer(this.getDataType(), n);
    }

    public int getNumDataElements() {
        return 1;
    }

    public int[] getSampleSize() {
        return this.sampleSize;
    }

    public int getSampleSize(int n) {
        return this.sampleSize[0];
    }

    public int getOffset(int n, int n2) {
        return this.scanlineStride * n2 + (this.dataBitOffset + n * this.numberOfBits) / this.elemBits;
    }

    public int getBitOffset(int n) {
        return (this.dataBitOffset + n * this.numberOfBits) % this.elemBits;
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.numberOfBits;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        int n = nArray.length;
        if (n != 1) {
            throw new RasterFormatException("MultiPixelPackedSampleModel only supports one band");
        }
        return new MultiPixelPackedSampleModel(this.dataType, this.width, this.height, this.numberOfBits, this.scanlineStride, this.dataBitOffset);
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getSample(n, n2, 0, dataBuffer);
        switch (this.getTransferType()) {
            case 0: {
                if (object == null) {
                    object = new byte[1];
                }
                ((byte[])object)[0] = (byte)n3;
                return object;
            }
            case 1: {
                if (object == null) {
                    object = new short[1];
                }
                ((short[])object)[0] = (short)n3;
                return object;
            }
            case 3: {
                if (object == null) {
                    object = new int[1];
                }
                ((int[])object)[0] = n3;
                return object;
            }
        }
        throw new ClassCastException();
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        if (nArray == null) {
            nArray = new int[]{this.getSample(n, n2, 0, dataBuffer)};
        }
        return nArray;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = this.getOffset(n, n2);
        if (nArray == null) {
            nArray = new int[n3 * n4];
        }
        int n6 = 0;
        n2 = 0;
        while (n2 < n4) {
            int n7 = n5;
            n = 0;
            while (n < n3) {
                int n8 = dataBuffer.getElem(n7++);
                int n9 = 0;
                while (n9 < this.numElems && n < n3) {
                    nArray[n6++] = (n8 & this.bitMasks[n9]) >>> this.bitOffsets[n9];
                    ++n;
                    ++n9;
                }
            }
            n5 += this.scanlineStride;
            ++n2;
        }
        return nArray;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = (this.dataBitOffset + n * this.numberOfBits) % this.elemBits / this.numberOfBits;
        int n5 = this.getOffset(n, n2);
        int n6 = dataBuffer.getElem(n5);
        return (n6 & this.bitMasks[n4]) >>> this.bitOffsets[n4];
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        if (this.getTransferType() != dataBuffer.getDataType()) {
            throw new IllegalArgumentException("transfer type (" + this.getTransferType() + "), does not match data buffer type (" + dataBuffer.getDataType() + ").");
        }
        int n4 = this.getOffset(n, n2);
        try {
            switch (n3) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
                    byte[] byArray = (byte[])object;
                    dataBufferByte.getData()[n4] = byArray[0];
                    return;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
                    short[] sArray = (short[])object;
                    dataBufferUShort.getData()[n4] = sArray[0];
                    return;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
                    int[] nArray = (int[])object;
                    dataBufferInt.getData()[n4] = nArray[0];
                    return;
                }
            }
            throw new ClassCastException("Unsupported data type");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = "While writing data elements, x=" + n + ", y=" + n2 + ", width=" + this.width + ", height=" + this.height + ", scanlineStride=" + this.scanlineStride + ", offset=" + n4 + ", data.getSize()=" + dataBuffer.getSize() + ", data.getOffset()=" + dataBuffer.getOffset() + ": " + arrayIndexOutOfBoundsException;
            throw new ArrayIndexOutOfBoundsException(string);
        }
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        this.setSample(n, n2, 0, nArray[0], dataBuffer);
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        int n5 = (this.dataBitOffset + n * this.numberOfBits) % this.elemBits / this.numberOfBits;
        int n6 = this.getOffset(n, n2);
        n4 <<= this.bitOffsets[n5];
        int n7 = dataBuffer.getElem(n6);
        dataBuffer.setElem(n6, n7 |= (n4 &= this.bitMasks[n5]));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[");
        stringBuffer.append("scanlineStride=").append(this.scanlineStride);
        int n = 0;
        while (n < this.bitMasks.length) {
            stringBuffer.append(", mask[").append(n).append("]=0x").append(Integer.toHexString(this.bitMasks[n]));
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public MultiPixelPackedSampleModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0, 0);
    }

    public MultiPixelPackedSampleModel(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, 1);
        switch (n) {
            case 0: {
                this.elemBits = 8;
                break;
            }
            case 1: {
                this.elemBits = 16;
                break;
            }
            case 3: {
                this.elemBits = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("MultiPixelPackedSampleModel unsupported dataType");
            }
        }
        this.dataBitOffset = n6;
        this.numberOfBits = n4;
        if (n4 > this.elemBits) {
            throw new RasterFormatException("MultiPixelPackedSampleModel pixel size larger than dataType");
        }
        switch (n4) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new RasterFormatException("MultiPixelPackedSampleModel pixel size not 2^n bits");
            }
        }
        this.numElems = this.elemBits / n4;
        if (n5 == 0) {
            n5 = (n6 + n2 * n4) / this.elemBits;
        }
        this.scanlineStride = n5;
        this.sampleSize = new int[1];
        this.sampleSize[0] = n4;
        this.bitMasks = new int[this.numElems];
        this.bitOffsets = new int[this.numElems];
        int n7 = 0;
        while (n7 < this.numElems) {
            this.bitOffsets[this.numElems - n7 - 1] = n4 * n7;
            this.bitMasks[this.numElems - n7 - 1] = (1 << n4) - 1 << this.bitOffsets[this.numElems - n7 - 1];
            ++n7;
        }
    }
}

