/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

final class MessageNode
extends TemplateNode {
    static final Logger logger = Logger.getLogger("gnu.xml.transform");
    final boolean terminate;

    final TemplateNode clone(Stylesheet stylesheet) {
        MessageNode messageNode = new MessageNode(this.terminate);
        if (this.children != null) {
            messageNode.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            messageNode.next = this.next.clone(stylesheet);
        }
        return messageNode;
    }

    final void doApply(Stylesheet stylesheet, QName qName, Node node2, int n, int n2, Node node3, Node node4) throws TransformerException {
        if (this.children != null) {
            Document document = node3 instanceof Document ? (Document)node3 : node3.getOwnerDocument();
            DocumentFragment documentFragment = document.createDocumentFragment();
            this.children.apply(stylesheet, qName, node2, n, n2, documentFragment, null);
            String string = Expr.stringValue(documentFragment);
            logger.info(string);
            if (this.terminate) {
                stylesheet.terminated = true;
            }
        }
        if (this.next != null && !this.terminate) {
            this.next.apply(stylesheet, qName, node2, n, n2, node3, node4);
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("message");
        if (this.terminate) {
            stringBuffer.append('[');
            stringBuffer.append("terminate");
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    MessageNode(boolean bl) {
        this.terminate = bl;
    }
}

