/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.prng;

import gnu.java.security.prng.BasePRNG;
import gnu.java.security.prng.LimitReachedException;
import java.util.Map;

public class ARCFour
extends BasePRNG
implements Cloneable {
    public static final String ARCFOUR_KEY_MATERIAL = "gnu.crypto.prng.arcfour.key-material";
    public static final int ARCFOUR_SBOX_SIZE = 256;
    private byte[] s;
    private byte m;
    private byte n;

    public void setup(Map map) {
        int n;
        byte[] byArray = (byte[])map.get(ARCFOUR_KEY_MATERIAL);
        if (byArray == null) {
            throw new IllegalArgumentException("ARCFOUR needs a key");
        }
        this.s = new byte[256];
        this.n = 0;
        this.m = 0;
        byte[] byArray2 = new byte[256];
        int n2 = 0;
        while (n2 < 256) {
            this.s[n2] = (byte)n2;
            ++n2;
        }
        if (byArray.length > 0) {
            n2 = 0;
            n = 0;
            while (n2 < 256) {
                byArray2[n2] = byArray[n++];
                if (n >= byArray.length) {
                    n = 0;
                }
                ++n2;
            }
        }
        n2 = 0;
        n = 0;
        while (n2 < 256) {
            n = n + this.s[n2] + byArray2[n2];
            byte by = this.s[n2];
            this.s[n2] = this.s[n & 0xFF];
            this.s[n & 0xFF] = by;
            ++n2;
        }
        this.buffer = new byte[256];
        try {
            this.fillBlock();
        }
        catch (LimitReachedException limitReachedException) {}
    }

    public void fillBlock() throws LimitReachedException {
        int n = 0;
        while (n < this.buffer.length) {
            this.m = (byte)(this.m + 1);
            this.n = (byte)(this.n + this.s[this.m & 0xFF]);
            byte by = this.s[this.m & 0xFF];
            this.s[this.m & 0xFF] = this.s[this.n & 0xFF];
            this.s[this.n & 0xFF] = by;
            by = (byte)(this.s[this.m & 0xFF] + this.s[this.n & 0xFF]);
            this.buffer[n] = this.s[by & 0xFF];
            ++n;
        }
    }

    public ARCFour() {
        super("arcfour");
    }
}

