/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.PRNGFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class PBKDF2SecretKeyFactory
extends SecretKeyFactorySpi {
    private static final int DEFAULT_ITERATION_COUNT = 1000;
    private static final int DEFAULT_KEY_LEN = 32;
    protected String macName;

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (!(keySpec instanceof PBEKeySpec)) {
            throw new InvalidKeySpecException("not a PBEKeySpec");
        }
        IRandom iRandom = PRNGFactory.getInstance("PBKDF2-" + this.macName);
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.pbe.password", ((PBEKeySpec)keySpec).getPassword());
        byte[] byArray = ((PBEKeySpec)keySpec).getSalt();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        hashMap.put("gnu.crypto.pbe.salt", byArray);
        int n = ((PBEKeySpec)keySpec).getIterationCount();
        if (n <= 0) {
            n = 1000;
        }
        hashMap.put("gnu.crypto.pbe.iteration.count", new Integer(n));
        iRandom.init(hashMap);
        int n2 = ((PBEKeySpec)keySpec).getKeyLength();
        if (n2 <= 0) {
            n2 = 32;
        }
        byte[] byArray2 = new byte[n2];
        try {
            iRandom.nextBytes(byArray2, 0, n2);
        }
        catch (LimitReachedException limitReachedException) {
            throw new IllegalArgumentException(limitReachedException.toString());
        }
        return new SecretKeySpec(byArray2, "PBKDF2");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("not supported");
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) {
        return new SecretKeySpec(secretKey.getEncoded(), secretKey.getAlgorithm());
    }

    protected PBKDF2SecretKeyFactory(String string) {
        this.macName = string;
    }

    public static class HMacWhirlpool
    extends PBKDF2SecretKeyFactory {
        public HMacWhirlpool() {
            super("HMAC-WHIRLPOOL");
        }
    }

    public static class HMacTiger
    extends PBKDF2SecretKeyFactory {
        public HMacTiger() {
            super("HMAC-TIGER");
        }
    }

    public static class HMacSHA512
    extends PBKDF2SecretKeyFactory {
        public HMacSHA512() {
            super("HMAC-SHA512");
        }
    }

    public static class HMacSHA384
    extends PBKDF2SecretKeyFactory {
        public HMacSHA384() {
            super("HMAC-SHA384");
        }
    }

    public static class HMacSHA256
    extends PBKDF2SecretKeyFactory {
        public HMacSHA256() {
            super("HMAC-SHA256");
        }
    }

    public static class HMacSHA1
    extends PBKDF2SecretKeyFactory {
        public HMacSHA1() {
            super("HMAC-SHA1");
        }
    }

    public static class HMacRipeMD160
    extends PBKDF2SecretKeyFactory {
        public HMacRipeMD160() {
            super("HMAC-RIPEMD160");
        }
    }

    public static class HMacRipeMD128
    extends PBKDF2SecretKeyFactory {
        public HMacRipeMD128() {
            super("HMAC-RIPEMD128");
        }
    }

    public static class HMacMD5
    extends PBKDF2SecretKeyFactory {
        public HMacMD5() {
            super("HMAC-MD5");
        }
    }

    public static class HMacMD4
    extends PBKDF2SecretKeyFactory {
        public HMacMD4() {
            super("HMAC-MD4");
        }
    }

    public static class HMacMD2
    extends PBKDF2SecretKeyFactory {
        public HMacMD2() {
            super("HMAC-MD2");
        }
    }

    public static class HMacHaval
    extends PBKDF2SecretKeyFactory {
        public HMacHaval() {
            super("HMAC-HAVAL");
        }
    }
}

