/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Namespaces {
    List personal;
    List other;
    List shared;

    public Namespace[] getPersonal() {
        return this.toArray(this.personal);
    }

    public Namespace[] getOther() {
        return this.toArray(this.other);
    }

    public Namespace[] getShared() {
        return this.toArray(this.shared);
    }

    private final Namespace[] toArray(List list2) {
        if (list2 == null) {
            return null;
        }
        Object[] objectArray = new Namespace[list2.size()];
        list2.toArray(objectArray);
        return objectArray;
    }

    static int parse(String string, int n, int n2, List list2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n3 = n;
        while (n3 < n2) {
            String string2;
            char c = string.charAt(n3);
            if (bl) {
                if (c == '\"') {
                    string2 = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    bl = false;
                    list2.add(string2);
                } else {
                    stringBuffer.append(c);
                }
            } else {
                switch (c) {
                    case ' ': {
                        string2 = stringBuffer.toString();
                        if ("NIL".equals(string2)) {
                            list2.add(null);
                        }
                        stringBuffer.setLength(0);
                        break;
                    }
                    case '\"': {
                        bl = true;
                        stringBuffer.setLength(0);
                        break;
                    }
                    case '(': {
                        ArrayList arrayList = new ArrayList();
                        n3 = Namespaces.parse(string, n3 + 1, n2, arrayList);
                        list2.add(arrayList);
                        break;
                    }
                    case ')': {
                        return n3;
                    }
                }
            }
            ++n3;
        }
        return n2;
    }

    private final List parseNamespaceList(Object object) {
        if (object == null) {
            return null;
        }
        List list2 = (List)object;
        int n = list2.size();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.parseNamespace((List)list2.get(n2)));
            ++n2;
        }
        return arrayList;
    }

    private final Namespace parseNamespace(List list2) {
        int n = list2.size();
        Namespace namespace = new Namespace();
        namespace.prefix = (String)list2.get(0);
        namespace.delimiter = ((String)list2.get(1)).charAt(0);
        if (n > 2) {
            namespace.extensions = new TreeMap();
            int n2 = 2;
            while (n2 < n) {
                String string = (String)list2.get(n2);
                Object object = n2 == n - 1 ? null : list2.get(n2 + 1);
                namespace.extensions.put(string, object);
                n2 += 2;
            }
        }
        return namespace;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendNamespaceList(stringBuffer, this.personal);
        stringBuffer.append(' ');
        this.appendNamespaceList(stringBuffer, this.other);
        stringBuffer.append(' ');
        this.appendNamespaceList(stringBuffer, this.shared);
        return stringBuffer.toString();
    }

    private final void appendNamespaceList(StringBuffer stringBuffer, List list2) {
        if (list2 == null) {
            stringBuffer.append("NIL");
        } else {
            int n = list2.size();
            stringBuffer.append('(');
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(list2.get(n2));
                ++n2;
            }
            stringBuffer.append(')');
        }
    }

    Namespaces(String string) {
        ArrayList arrayList = new ArrayList();
        int n = string.length();
        Namespaces.parse(string, 0, n, arrayList);
        n = arrayList.size();
        if (n > 0) {
            this.personal = this.parseNamespaceList(arrayList.get(0));
            if (n > 1) {
                this.other = this.parseNamespaceList(arrayList.get(1));
                if (n > 2) {
                    this.shared = this.parseNamespaceList(arrayList.get(2));
                }
            }
        }
    }

    public static class Namespace {
        String prefix;
        char delimiter;
        Map extensions;

        public String getPrefix() {
            return this.prefix;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public Map getExtensions() {
            return this.extensions;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            stringBuffer.append(Namespace.quote(this.prefix));
            stringBuffer.append(' ');
            stringBuffer.append(Namespace.quote(this.delimiter));
            if (this.extensions != null) {
                stringBuffer.append(' ');
                Iterator iterator = this.extensions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String string = (String)entry.getKey();
                    stringBuffer.append(Namespace.quote(string));
                    stringBuffer.append(' ');
                    stringBuffer.append(this.format(entry.getValue()));
                }
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        static String quote(String string) {
            return "\"" + string + '\"';
        }

        static String quote(char c) {
            char[] cArray = new char[]{'\"', c, '\"'};
            return new String(cArray);
        }

        private final String format(Object object) {
            if (object == null) {
                return "NIL";
            }
            if (object instanceof String) {
                return Namespace.quote((String)object);
            }
            List list2 = (List)object;
            int n = list2.size();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('(');
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.format(list2.get(n2)));
                ++n2;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

