/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.lang.NumberUtils;

public class CompareToBuilder {
    private int comparison = 0;

    public static int reflectionCompare(Object lhs, Object rhs) {
        return CompareToBuilder.reflectionCompare(lhs, rhs, false);
    }

    public static int reflectionCompare(Object lhs, Object rhs, boolean testTransients) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        Class<?> c1 = lhs.getClass();
        if (!c1.isInstance(rhs)) {
            throw new ClassCastException();
        }
        AccessibleObject[] fields = c1.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        CompareToBuilder compareToBuilder = new CompareToBuilder();
        int i = 0;
        while (i < fields.length && compareToBuilder.comparison == 0) {
            AccessibleObject f = fields[i];
            if (!(!testTransients && Modifier.isTransient(((Field)f).getModifiers()) || Modifier.isStatic(((Field)f).getModifiers()))) {
                try {
                    compareToBuilder.append(((Field)f).get(lhs), ((Field)f).get(rhs));
                }
                catch (IllegalAccessException e) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
            ++i;
        }
        return compareToBuilder.toComparison();
    }

    public CompareToBuilder append(Object lhs, Object rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        Class<?> lhsClass = lhs.getClass();
        if (!lhsClass.isArray()) {
            this.comparison = ((Comparable)lhs).compareTo(rhs);
        } else if (lhs instanceof long[]) {
            this.append((long[])lhs, (long[])rhs);
        } else if (lhs instanceof int[]) {
            this.append((int[])lhs, (int[])rhs);
        } else if (lhs instanceof short[]) {
            this.append((short[])lhs, (short[])rhs);
        } else if (lhs instanceof char[]) {
            this.append((char[])lhs, (char[])rhs);
        } else if (lhs instanceof byte[]) {
            this.append((byte[])lhs, (byte[])rhs);
        } else if (lhs instanceof double[]) {
            this.append((double[])lhs, (double[])rhs);
        } else if (lhs instanceof float[]) {
            this.append((float[])lhs, (float[])rhs);
        } else if (lhs instanceof boolean[]) {
            this.append((boolean[])lhs, (boolean[])rhs);
        } else {
            this.append((Object[])lhs, (Object[])rhs);
        }
        return this;
    }

    public CompareToBuilder append(long lhs, long rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(int lhs, int rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(short lhs, short rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(char lhs, char rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(byte lhs, byte rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(double lhs, double rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = NumberUtils.compare(lhs, rhs);
        return this;
    }

    public CompareToBuilder append(float lhs, float rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = NumberUtils.compare(lhs, rhs);
        return this;
    }

    public CompareToBuilder append(boolean lhs, boolean rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        this.comparison = !lhs ? -1 : 1;
        return this;
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        int length = lhs.length < rhs.length ? lhs.length : rhs.length;
        int i = 0;
        while (i < length && this.comparison == 0) {
            Class<?> lhsClass = lhs[i].getClass();
            if (!lhsClass.isInstance(rhs[i])) {
                throw new ClassCastException();
            }
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        if (this.comparison == 0 && lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
        }
        return this;
    }

    public CompareToBuilder append(long[] lhs, long[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        int length = lhs.length < rhs.length ? lhs.length : rhs.length;
        int i = 0;
        while (i < length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        if (this.comparison == 0 && lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
        }
        return this;
    }

    public CompareToBuilder append(int[] lhs, int[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        int length = lhs.length < rhs.length ? lhs.length : rhs.length;
        int i = 0;
        while (i < length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        if (this.comparison == 0 && lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
        }
        return this;
    }

    public CompareToBuilder append(short[] lhs, short[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        int length = lhs.length < rhs.length ? lhs.length : rhs.length;
        int i = 0;
        while (i < length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        if (this.comparison == 0 && lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
        }
        return this;
    }

    public CompareToBuilder append(char[] lhs, char[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        int length = lhs.length < rhs.length ? lhs.length : rhs.length;
        int i = 0;
        while (i < length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        if (this.comparison == 0 && lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
        }
        return this;
    }

    public CompareToBuilder append(byte[] lhs, byte[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        int length = lhs.length < rhs.length ? lhs.length : rhs.length;
        int i = 0;
        while (i < length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        if (this.comparison == 0 && lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
        }
        return this;
    }

    public CompareToBuilder append(double[] lhs, double[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        int length = lhs.length < rhs.length ? lhs.length : rhs.length;
        int i = 0;
        while (i < length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        if (this.comparison == 0 && lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
        }
        return this;
    }

    public CompareToBuilder append(float[] lhs, float[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        int length = lhs.length < rhs.length ? lhs.length : rhs.length;
        int i = 0;
        while (i < length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        if (this.comparison == 0 && lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
        }
        return this;
    }

    public CompareToBuilder append(boolean[] lhs, boolean[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        int length = lhs.length < rhs.length ? lhs.length : rhs.length;
        int i = 0;
        while (i < length && this.comparison == 0) {
            this.append(lhs[i], rhs[i]);
            ++i;
        }
        if (this.comparison == 0 && lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
        }
        return this;
    }

    public int toComparison() {
        return this.comparison;
    }
}

