"""Remote tab completion.

Activation
==========

To use this, put in your ~/.ipython/ipy_user_conf.py file:

    from ipy_remote_completer import activate
    activate([complete_threshold])

The optional complete_threshold argument is the minimal length of text you need
to type for tab-completion to list names that are automatically generated by
traits.  The default value is 3.  Note that at runtime, you can change this
value simply by doing:

    import ipy_remote_completer


"""

#############################################################################
# External imports

# IPython imports
from IPython.ipapi import TryNext, get as ipget
from IPython.genutils import dir2

#############################################################################
# Module constants


#############################################################################
# Code begins

def remote_completer(self,event):
    """A custom IPython tab-completer.
    """

    """Brian says:

Here is what I have so far:
def px_completer(self, event):
   # print event
   activeController = self.activeController
   keys = activeController.keys(0)[0]
   return keys
I need to replace the keys = activeController ... line by something that
1) Instantiates an object in the engine namespace that has a complete method .
2) has a complete method that I can call like
activateController.execute('results = __completer.complete(%s)' % s)
activeController.pull(0, 'results')
    """

    
    #print '\nevent is:',event  # dbg
    symbol_parts = event.symbol.split('.')
    base = '.'.join(symbol_parts[:-1])
    #print 'base:',base  # dbg

    oinfo = self._ofind(base)
    if not oinfo['found']:
        raise TryNext

    obj = oinfo['obj']
    # OK, we got the object.  See if it's traits, else punt
    if not isinstance(obj,T.HasTraits):
        raise TryNext

    # it's a traits object, don't show the tr* attributes unless the completion
    # begins with 'tr'
    attrs = dir2(obj)
    # Now, filter out the attributes that start with the user's request
    attr_start = symbol_parts[-1]
    if attr_start:
        attrs = [a for a in attrs if a.startswith(attr_start)]

    #print '\nastart:<%r>' % attr_start  # dbg

    if len(attr_start)<COMPLETE_THRESHOLD:
        attrs = list(set(attrs) - REMOTE_NAMES)
        
    # The base of the completion, so we can form the final results list
    bdot = base+'.'

    tcomp = [bdot+a for a in attrs]
    #print 'tcomp:',tcomp
    return tcomp

def activate():
    """Activate the Traits completer.
    """
    # Activate the traits aware completer
    ip = ipget()
    ip.set_hook('complete_command', remote_completer, re_key = '.*')


#############################################################################
if __name__ == '__main__':
    # Testing/debugging


    ip = ipget().IP
    
    # A few simplistic tests

    # Reset the threshold to the default, in case the test is running inside an
    # instance of ipython that changed it
    import ipy_remote_completer

