#! /bin/echo This file must be sourced inside (ba)sh using: .
#
#   GNUstep.sh.  Generated from GNUstep.sh.in by configure.
#
#   Shell initialization for the GNUstep environment.
#
#   Copyright (C) 1997-2005 Free Software Foundation, Inc.
#
#   Author:  Scott Christley <scottc@net-community.com>
#   Author:  Adam Fedor <fedor@gnu.org>
#   Author:  Richard Frith-Macdonald <rfm@gnu.org>
#   Author:  Nicola Pero <n.pero@mi.flashnet.it>
#
#   This file is part of the GNUstep Makefile Package.
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 3
#   of the License, or (at your option) any later version.
#   
#   You should have received a copy of the GNU General Public
#   License along with this library; see the file COPYING.
#   If not, write to the Free Software Foundation,
#   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#

# Warning - this shell script is delicate, because it is sourced by
# using . rather than simply executed.  It is sourced because that is
# the only way to change the shell variables in the calling
# environment.
#
# Sourcing makes the shell script more delicate for the following reasons:
#
#  * temporary variables are automatically set in the calling
#  environment!  WORKAROUND: we need to unset all them after using
#  them to avoid polluting the calling environment;
#
#  * not only the exit value of the script, but the exit value of each
#  command we execute, might be interpreted by the calling
#  environment.  Typically, the calling environment might be using the
#  shell errexit option ('set -e') in bash parlance, which causes the
#  shell to exit if any command returns an error value.  If this were
#  a normal script, this option would mean that the shell would exit
#  if the return value of the whole script were an error value; but
#  because we are sourced, it is as all the commands in this script
#  were executed directly in the calling environment, so *all* values
#  returned by *all* commands must be non-error.  [this all typically
#  happens in rpm builds, where scripts are run with the errexit
#  option so that errors in scripts abort the build, and now if a
#  script sources GNUstep.sh, then we are exactly in this situation -
#  if any command inside GNUstep.sh returns an error value (even if
#  GNUstep.sh as a whole would be happy and return succes), the whole
#  rpm build process aborts!]. WORKAROUND: we must make sure all
#  commands return success - last resorts hacks like 'command || :'
#  which always returns success whatever command returns.
#

# If we're running in zsh (auch!) make sure we're using -y
# (SH_WORD_SPLIT) else our path manipulations won't work.
if [ -n "$ZSH_VERSION" ]; then

  # If -y is not already set, set it and remember that we
  # need to set it back to what it was at the end.
  if ( setopt | grep shwordsplit > /dev/null ); then :; else
    set -y
    GS_ZSH_NEED_TO_RESTORE_SET=yes
  fi

fi

#
# Set the GNUstep system root and local root
#

#
# Read our configuration files
#

# Determine the location of the system configuration file
if [ -z "$GNUSTEP_CONFIG_FILE" ]; then
  GNUSTEP_CONFIG_FILE=/etc/GNUstep.conf
fi

# Determine the location of the user configuration file
if [ -z "$GNUSTEP_USER_CONFIG_FILE" ]; then
  GNUSTEP_USER_CONFIG_FILE=.GNUstep.conf
fi

# Read the system configuration file
if [ -f "$GNUSTEP_CONFIG_FILE" ]; then
  . "$GNUSTEP_CONFIG_FILE"
fi

# FIXME: determining GNUSTEP_HOME
GNUSTEP_HOME=~

# Read the user configuration file ... unless it is disabled (ie, set
# to an empty string)
if [ -n "$GNUSTEP_USER_CONFIG_FILE" ]; then
  case "$GNUSTEP_USER_CONFIG_FILE" in 
    /*) # An absolute path
        if [ -f "$GNUSTEP_USER_CONFIG_FILE" ]; then
          . "$GNUSTEP_USER_CONFIG_FILE"
        fi;;
     *) # Something else
        if [ -f "$GNUSTEP_HOME/$GNUSTEP_USER_CONFIG_FILE" ]; then
          . "$GNUSTEP_HOME/$GNUSTEP_USER_CONFIG_FILE"
        fi;;
  esac
fi

# Now, set any essential variable (that is not already set) to the
# built-in values.

# This is deprecated and will be removed
if [ -z "$GNUSTEP_SYSTEM_ROOT" ]; then
  GNUSTEP_SYSTEM_ROOT=/usr/local/System
fi

# This is deprecated and will be removed
if [ -z "$GNUSTEP_LOCAL_ROOT" ]; then
  GNUSTEP_LOCAL_ROOT=/usr/local/Local
fi

# This is deprecated and will be removed
if [ -z "$GNUSTEP_NETWORK_ROOT" ]; then
  GNUSTEP_NETWORK_ROOT=/usr/local/Network
fi

export GNUSTEP_SYSTEM_ROOT GNUSTEP_LOCAL_ROOT GNUSTEP_NETWORK_ROOT

# GNUSTEP_FLATTENED is obsolete, please use GNUSTEP_IS_FLATTENED
# instead
GNUSTEP_FLATTENED=yes
GNUSTEP_IS_FLATTENED=yes
if [ -z "$LIBRARY_COMBO" ]; then
  LIBRARY_COMBO=gnu-gnu-gnu
fi
export GNUSTEP_IS_FLATTENED GNUSTEP_FLATTENED LIBRARY_COMBO

if [ -z "$GNUSTEP_MAKEFILES" ]; then
  GNUSTEP_MAKEFILES=/usr/local/share/GNUstep/Makefiles
fi
export GNUSTEP_MAKEFILES

if [ -z "$GNUSTEP_USER_DIR" ]; then
  GNUSTEP_USER_DIR=GNUstep
fi

#
# Set GNUSTEP_USER_ROOT which is the variable used in practice
#
case "$GNUSTEP_USER_DIR" in 
  /*) # An absolute path
      GNUSTEP_USER_ROOT="$GNUSTEP_USER_DIR";;
   *) # Something else
      GNUSTEP_USER_ROOT="$GNUSTEP_HOME/$GNUSTEP_USER_DIR";;
esac

# This is deprecated and will be removed
export GNUSTEP_USER_ROOT

# If multi-platform support is disabled, just use the hardcoded cpu,
# vendor and os determined when gnustep-make was configured.  The
# reason using the hardcoded ones might be better is that config.guess
# and similar scripts might even require compiling test files to
# determine the platform - but then you can't source GNUstep.sh
# without having gcc, binutils, libc6-dev installed.  Which can be a
# problem for end-users who are not developers and have no development
# tools installed.  To prevent this problem, unless we were configured
# to determine the platform at run time, by default we use the
# hardcoded values of GNUSTEP_HOST*.
if [ -z "yes" ]; then
  GNUSTEP_HOST=i386-unknown-openbsd4.3
  GNUSTEP_HOST_CPU=ix86
  GNUSTEP_HOST_VENDOR=unknown
  GNUSTEP_HOST_OS=openbsd4.3
fi

#
# Determine the host information
#
if [ -z "$GNUSTEP_HOST" ]; then
  # Not all shells (e.g. /bin/sh on FreeBSD < 4.0 or ash) have pushd/popd
  tmpdir=`pwd`; cd /tmp
  GNUSTEP_HOST=`$GNUSTEP_MAKEFILES/config.guess`
  GNUSTEP_HOST=`$GNUSTEP_MAKEFILES/config.sub $GNUSTEP_HOST`
  cd "$tmpdir"
  unset tmpdir
fi

if [ -z "$GNUSTEP_HOST_CPU" ]; then
  GNUSTEP_HOST_CPU=`$GNUSTEP_MAKEFILES/cpu.sh $GNUSTEP_HOST`
  GNUSTEP_HOST_CPU=`$GNUSTEP_MAKEFILES/clean_cpu.sh $GNUSTEP_HOST_CPU`
fi

if [ -z "$GNUSTEP_HOST_VENDOR" ]; then
  GNUSTEP_HOST_VENDOR=`$GNUSTEP_MAKEFILES/vendor.sh $GNUSTEP_HOST`
  GNUSTEP_HOST_VENDOR=`$GNUSTEP_MAKEFILES/clean_vendor.sh $GNUSTEP_HOST_VENDOR`
fi

if [ -z "$GNUSTEP_HOST_OS" ]; then 
  GNUSTEP_HOST_OS=`$GNUSTEP_MAKEFILES/os.sh $GNUSTEP_HOST`
  GNUSTEP_HOST_OS=`$GNUSTEP_MAKEFILES/clean_os.sh $GNUSTEP_HOST_OS`
fi

export GNUSTEP_HOST GNUSTEP_HOST_CPU GNUSTEP_HOST_VENDOR GNUSTEP_HOST_OS

# Now load in all the remaining paths
. $GNUSTEP_MAKEFILES/filesystem.sh

# No longer needed
unset GNUSTEP_HOME

# Determine if the paths look like Windows paths that need fixing
fixup_paths=no
# Here we want to use `...` but the only portable way to use it when
# there are "..." inside the expression (ie, it's actually
# `..."..."...`) seems to be to use it in variable assignments.  So we
# use a temporary variable and assign the result of `...` to it
path_check=`echo "$GNUSTEP_MAKEFILES" | sed 's|^[a-zA-Z]:/.*$||'`
if [ -z "$path_check" ]; then
  fixup_paths=yes
fi
unset path_check

# GNUSTEP_PATHLIST is deprecated and will be removed.
#
# GNUSTEP_PATHLIST is like an abstract path-like shell variable, which
# can be used to search the gnustep directories - and in these
# scripts, it is also used to set up other shell variables
#
if [ -z "$GNUSTEP_PATHLIST" ]; then

 GNUSTEP_PATHLIST=`$GNUSTEP_MAKEFILES/print_unique_pathlist.sh "$GNUSTEP_USER_ROOT" "$GNUSTEP_LOCAL_ROOT" "$GNUSTEP_NETWORK_ROOT" "$GNUSTEP_SYSTEM_ROOT" $fixup_paths`
 export GNUSTEP_PATHLIST
fi

#
# Add path to Tools to PATH
#
GNUSTEP_TOOLS_PATHLIST=`$GNUSTEP_MAKEFILES/print_unique_pathlist.sh "$GNUSTEP_USER_TOOLS" "$GNUSTEP_LOCAL_TOOLS" "$GNUSTEP_NETWORK_TOOLS" "$GNUSTEP_SYSTEM_TOOLS" $fixup_paths`

# Now, we check the paths in GNUSTEP_*_ADMIN_TOOLS.  These paths
# should only be used by Administrators -- normal users don't have
# enough powers to use those tools to do useful things.  Our test for
# being an 'Administrator' is that anyone who can write to an Admin
# directory can be considered powerful enough to use those tools.

# FIXME: Unfortunately, this doesn't work if the Admin directory
# is mounted read-only, so a better test is required!

# So we examine GNUSTEP_*_ADMIN_TOOLS; if we find any path in that
# list that exists and that we can write to, we add it to our PATH.
for dir in "$GNUSTEP_SYSTEM_ADMIN_TOOLS" "$GNUSTEP_NETWORK_ADMIN_TOOLS" "$GNUSTEP_LOCAL_ADMIN_TOOLS" "$GNUSTEP_USER_ADMIN_TOOLS"; do
  if [ -d "$dir"  -a  -w "$dir" ]; then
    # Only add the new dir if it's not already in GNUSTEP_TOOLS_PATHLIST
    if (echo $GNUSTEP_TOOLS_PATHLIST | grep -v "$dir" >/dev/null); then
      GNUSTEP_TOOLS_PATHLIST="$dir:$GNUSTEP_TOOLS_PATHLIST"
    fi
  fi
done

#
# And now, we put the results into PATH
#
old_IFS="$IFS"
IFS=:
temp_path=
for dir in $GNUSTEP_TOOLS_PATHLIST; do

  # Prepare the path_fragment
  if [ "$GNUSTEP_IS_FLATTENED" = "no" ]; then
    path_fragment="$dir:$dir/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}/${LIBRARY_COMBO}:$dir/${GNUSTEP_HOST_CPU}/${GNUSTEP_HOST_OS}"
  else
    path_fragment="$dir"
  fi

  # Add it to temp_path
  if [ -z "$temp_path" ]; then
    temp_path="$path_fragment"
  else
    temp_path="$temp_path:$path_fragment"
  fi

  unset path_fragment

done
IFS="$old_IFS"
unset old_IFS
unset dir
if [ -z "$PATH" ]; then
  PATH="$temp_path"
else
  if ( echo ${PATH}| grep -v "${temp_path}" >/dev/null ); then
    PATH="${temp_path}:${PATH}"
  fi
fi
unset temp_path
unset GNUSTEP_TOOLS_PATHLIST
export PATH

. $GNUSTEP_MAKEFILES/ld_lib_path.sh

GNUSTEP_LIBRARY_PATHLIST=`$GNUSTEP_MAKEFILES/print_unique_pathlist.sh "$GNUSTEP_USER_LIBRARY" "$GNUSTEP_LOCAL_LIBRARY" "$GNUSTEP_NETWORK_LIBRARY" "$GNUSTEP_SYSTEM_LIBRARY" $fixup_paths`

old_IFS="$IFS"
IFS=:
gnustep_class_path=
for dir in $GNUSTEP_LIBRARY_PATHLIST; do

  if [ -z "$gnustep_class_path" ]; then
    gnustep_class_path="$dir/Libraries/Java"
  else
    gnustep_class_path="$gnustep_class_path:$dir/Libraries/Java"
  fi

done
IFS="$old_IFS"
unset old_IFS
unset dir

if [ -z "$CLASSPATH" ]; then
  CLASSPATH="$gnustep_class_path"
else
  if ( echo ${CLASSPATH}| grep -v "${gnustep_class_path}" >/dev/null ); then
    CLASSPATH="$CLASSPATH:$gnustep_class_path"
  fi
fi

unset gnustep_class_path
export CLASSPATH

#
# Setup path for loading guile modules too.
#
old_IFS="$IFS"
IFS=:
guile_paths=
for dir in $GNUSTEP_LIBRARY_PATHLIST; do

  if [ -z "$guile_paths" ]; then
    guile_paths="$dir/Libraries/Guile"
  else
    guile_paths="$guile_paths:$dir/Libraries/Guile"
  fi

done
IFS="$old_IFS"
unset old_IFS
unset dir

if [ -z "$GUILE_LOAD_PATH" ]; then
  GUILE_LOAD_PATH="$guile_paths"
else
  if ( echo ${GUILE_LOAD_PATH}| grep -v "${guile_paths}" >/dev/null ); then
    GUILE_LOAD_PATH="$guile_paths:$GUILE_LOAD_PATH"
  fi
fi
export GUILE_LOAD_PATH
unset guile_paths
unset GNUSTEP_LIBRARY_PATHLIST

#
# Make sure info files, that we install by default into
# xxx/Library/Documentation/info, are found by the info browsing
# programs.  To get this effect, we add those paths to INFOPATH.
#
GNUSTEP_INFO_PATHLIST=`$GNUSTEP_MAKEFILES/print_unique_pathlist.sh "$GNUSTEP_USER_DOC_INFO" "$GNUSTEP_LOCAL_DOC_INFO" "$GNUSTEP_NETWORK_DOC_INFO" "$GNUSTEP_SYSTEM_DOC_INFO" $fixup_paths`
old_IFS="$IFS"
IFS=:
gnustep_info_path=
for dir in $GNUSTEP_INFO_PATHLIST; do

  if [ -z "$gnustep_info_path" ]; then
    gnustep_info_path="$dir"
  else
    gnustep_info_path="$gnustep_info_path:$dir"
  fi

done
IFS="$old_IFS"
unset old_IFS
unset dir

if [ -z "$INFOPATH" ]; then
  # The ':' at the end means to use the built-in paths after searching
  # the INFOPATH we provide.
  INFOPATH="${gnustep_info_path}:"
else
  if ( echo ${INFOPATH}| grep -v "${gnustep_info_path}" >/dev/null ); then
    INFOPATH="$INFOPATH:${gnustep_info_path}:"
  fi
fi

unset gnustep_info_path
export INFOPATH
unset GNUSTEP_INFO_PATHLIST

#
# Perform any user initialization
#
if [ -f "$GNUSTEP_USER_ROOT/GNUstep.sh" ]; then
  . "$GNUSTEP_USER_ROOT/GNUstep.sh"
fi

#
# Clean up the environment by removing the filesystem variables.  Do
# it unless we were explicitly requested not to clean it up!  Mostly
# gnustep-config will request that the environment is not cleaned up,
# so it can print out all of the GNUstep variables.
#
if [ -n "$GNUSTEP_SH_EXPORT_ALL_VARIABLES" ]; then
  export GNUSTEP_SYSTEM_APPS GNUSTEP_SYSTEM_ADMIN_APPS GNUSTEP_SYSTEM_WEB_APPS GNUSTEP_SYSTEM_TOOLS GNUSTEP_SYSTEM_ADMIN_TOOLS 
  export GNUSTEP_SYSTEM_LIBRARY GNUSTEP_SYSTEM_HEADERS GNUSTEP_SYSTEM_LIBRARIES
  export GNUSTEP_SYSTEM_DOC GNUSTEP_SYSTEM_DOC_MAN GNUSTEP_SYSTEM_DOC_INFO

  export GNUSTEP_NETWORK_APPS GNUSTEP_NETWORK_ADMIN_APPS GNUSTEP_NETWORK_WEB_APPS GNUSTEP_NETWORK_TOOLS GNUSTEP_NETWORK_ADMIN_TOOLS 
  export GNUSTEP_NETWORK_LIBRARY GNUSTEP_NETWORK_HEADERS GNUSTEP_NETWORK_LIBRARIES
  export GNUSTEP_NETWORK_DOC GNUSTEP_NETWORK_DOC_MAN GNUSTEP_NETWORK_DOC_INFO

  export GNUSTEP_LOCAL_APPS GNUSTEP_LOCAL_ADMIN_APPS GNUSTEP_LOCAL_WEB_APPS GNUSTEP_LOCAL_TOOLS GNUSTEP_LOCAL_ADMIN_TOOLS 
  export GNUSTEP_LOCAL_LIBRARY GNUSTEP_LOCAL_HEADERS GNUSTEP_LOCAL_LIBRARIES
  export GNUSTEP_LOCAL_DOC GNUSTEP_LOCAL_DOC_MAN GNUSTEP_LOCAL_DOC_INFO

  export GNUSTEP_USER_APPS GNUSTEP_USER_ADMIN_APPS GNUSTEP_USER_WEB_APPS GNUSTEP_USER_TOOLS GNUSTEP_USER_ADMIN_TOOLS 
  export GNUSTEP_USER_LIBRARY GNUSTEP_USER_HEADERS GNUSTEP_USER_LIBRARIES
  export GNUSTEP_USER_DOC GNUSTEP_USER_DOC_MAN GNUSTEP_USER_DOC_INFO
else
  unset GNUSTEP_SYSTEM_APPS 
  unset GNUSTEP_SYSTEM_ADMIN_APPS 
  unset GNUSTEP_SYSTEM_WEB_APPS 
  unset GNUSTEP_SYSTEM_TOOLS 
  unset GNUSTEP_SYSTEM_ADMIN_TOOLS 
  unset GNUSTEP_SYSTEM_LIBRARY
  unset GNUSTEP_SYSTEM_HEADERS 
  unset GNUSTEP_SYSTEM_LIBRARIES 
  unset GNUSTEP_SYSTEM_DOC 
  unset GNUSTEP_SYSTEM_DOC_MAN
  unset GNUSTEP_SYSTEM_DOC_INFO

  unset GNUSTEP_NETWORK_APPS 
  unset GNUSTEP_NETWORK_ADMIN_APPS 
  unset GNUSTEP_NETWORK_WEB_APPS 
  unset GNUSTEP_NETWORK_TOOLS 
  unset GNUSTEP_NETWORK_ADMIN_TOOLS 
  unset GNUSTEP_NETWORK_LIBRARY
  unset GNUSTEP_NETWORK_HEADERS 
  unset GNUSTEP_NETWORK_LIBRARIES 
  unset GNUSTEP_NETWORK_DOC 
  unset GNUSTEP_NETWORK_DOC_MAN
  unset GNUSTEP_NETWORK_DOC_INFO

  unset GNUSTEP_LOCAL_APPS 
  unset GNUSTEP_LOCAL_ADMIN_APPS 
  unset GNUSTEP_LOCAL_WEB_APPS 
  unset GNUSTEP_LOCAL_TOOLS 
  unset GNUSTEP_LOCAL_ADMIN_TOOLS 
  unset GNUSTEP_LOCAL_LIBRARY
  unset GNUSTEP_LOCAL_HEADERS 
  unset GNUSTEP_LOCAL_LIBRARIES 
  unset GNUSTEP_LOCAL_DOC 
  unset GNUSTEP_LOCAL_DOC_MAN
  unset GNUSTEP_LOCAL_DOC_INFO

  unset GNUSTEP_USER_APPS 
  unset GNUSTEP_USER_ADMIN_APPS 
  unset GNUSTEP_USER_WEB_APPS 
  unset GNUSTEP_USER_TOOLS 
  unset GNUSTEP_USER_ADMIN_TOOLS 
  unset GNUSTEP_USER_LIBRARY
  unset GNUSTEP_USER_HEADERS 
  unset GNUSTEP_USER_LIBRARIES 
  unset GNUSTEP_USER_DOC 
  unset GNUSTEP_USER_DOC_MAN
  unset GNUSTEP_USER_DOC_INFO
fi

if [ -n "$GS_ZSH_NEED_TO_RESTORE_SET" ]; then
  set +y
fi
# EOF
