/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;

class VisualAnnotationModel
extends AnnotationModel
implements IAnnotationModelListener {
    private IAnnotationModel fModel;

    public VisualAnnotationModel(IAnnotationModel modelAnnotationModel) {
        this.fModel = modelAnnotationModel;
    }

    public IAnnotationModel getModelAnnotationModel() {
        return this.fModel;
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        if (this.fModel != null && this.fAnnotationModelListeners.isEmpty()) {
            this.fModel.addAnnotationModelListener((IAnnotationModelListener)this);
        }
        super.addAnnotationModelListener(listener);
    }

    public void connect(IDocument document) {
        super.connect(document);
        if (this.fModel != null) {
            this.fModel.connect(document);
        }
    }

    public void disconnect(IDocument document) {
        super.disconnect(document);
        if (this.fModel != null) {
            this.fModel.disconnect(document);
        }
    }

    public Iterator getAnnotationIterator() {
        if (this.fModel == null) {
            return super.getAnnotationIterator();
        }
        ArrayList a = new ArrayList(20);
        Iterator e = this.fModel.getAnnotationIterator();
        while (e.hasNext()) {
            a.add(e.next());
        }
        e = super.getAnnotationIterator();
        while (e.hasNext()) {
            a.add(e.next());
        }
        return a.iterator();
    }

    public Position getPosition(Annotation annotation) {
        Position p = (Position)this.getAnnotationMap().get((Object)annotation);
        if (p != null) {
            return p;
        }
        if (this.fModel != null) {
            return this.fModel.getPosition(annotation);
        }
        return null;
    }

    public void modelChanged(IAnnotationModel model) {
        if (model == this.fModel) {
            for (IAnnotationModelListener l : new ArrayList(this.fAnnotationModelListeners)) {
                l.modelChanged((IAnnotationModel)this);
            }
        }
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        super.removeAnnotationModelListener(listener);
        if (this.fModel != null && this.fAnnotationModelListeners.isEmpty()) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this);
        }
    }
}

