/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.viewers.AbstractUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.viewers.TreeUpdatePolicy;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.memory.MemoryBlocksTreeViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.swt.widgets.Composite;

public class MemoryViewTreeViewer
extends AsynchronousTreeViewer {
    private MemoryBlocksTreeViewPane fPane;

    public MemoryViewTreeViewer(Composite parent, MemoryBlocksTreeViewPane pane) {
        super(parent);
        this.fPane = pane;
    }

    public MemoryViewTreeViewer(Composite parent) {
        super(parent);
    }

    public AbstractUpdatePolicy createUpdatePolicy() {
        return new MemoryViewTreeUpdatePolicy();
    }

    private boolean isFirstMemoryBlock() {
        IMemoryBlock[] memoryBlocks;
        return this.getInput() instanceof IMemoryBlockRetrieval && (memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IMemoryBlockRetrieval)this.getInput())).length == 1;
    }

    protected void updateComplete(IAsynchronousRequestMonitor monitor) {
        if (this.fPane != null) {
            this.fPane.restoreViewerState();
        }
        super.updateComplete(monitor);
    }

    private class MemoryViewTreeUpdatePolicy
    extends TreeUpdatePolicy {
        private MemoryViewTreeUpdatePolicy() {
        }

        protected void updateNodes(IModelDelta[] nodes) {
            AsynchronousTreeViewer viewer = (AsynchronousTreeViewer)this.getViewer();
            if (viewer == null) {
                return;
            }
            int i = 0;
            while (i < nodes.length) {
                IModelDelta node = nodes[i];
                int flags = node.getFlags();
                if ((flags & 1) != 0 && node.getElement() instanceof IMemoryBlock) {
                    MemoryView view;
                    IPresentationContext context;
                    if ((flags & 0x200000) != 0 && (context = this.getViewer().getPresentationContext()).getPart() instanceof MemoryView && (view = (MemoryView)context.getPart()).isPinMBDisplay()) {
                        flags |= 0x200000;
                        flags ^= 0x200000;
                    }
                    if (MemoryViewTreeViewer.this.isFirstMemoryBlock()) {
                        flags |= 0x200000;
                    }
                }
                if ((flags & 1) != 0) {
                    this.handleAdd(viewer, node);
                }
                if ((flags & 2) != 0) {
                    this.handleRemove(viewer, node);
                }
                if ((flags & 0x400) != 0) {
                    this.handleContent(viewer, node);
                }
                if ((flags & 0x100000) != 0) {
                    this.handleExpand(viewer, node);
                }
                if ((flags & 0x200000) != 0) {
                    this.handleSelect(viewer, node);
                }
                if ((flags & 0x800) != 0) {
                    this.handleState(viewer, node);
                }
                this.updateNodes(node.getNodes());
                ++i;
            }
        }
    }
}

