/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import org.apache.wsil.util.WSDLDocumentIdentifier;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WSDLDocument {
    protected static final String className = "WSDLDocument";
    private Definition wsdlDocumentDef = null;
    public static final String NS_URI_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_URI_WSDL_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String NS_URI_WSDL_HTTP = "http://schemas.xmlsoap.org/wsdl/http/";
    public static final String NS_URI_WSDL_MIME = "http://schemas.xmlsoap.org/wsdl/mime/";
    public static final String WSDL_FACTORY = "com.ibm.wsdl.factory.WSDLFactoryImpl";
    protected static WSDLFactory wsdlFactory = null;
    protected static WSDLException wsdlException = null;
    private static String WSDL4J_DEFINITION_FACTORY_PROP;

    public WSDLDocument(String string) throws WSDLException {
        this.read(string);
    }

    public WSDLDocument(URL uRL) throws WSDLException {
        this(uRL.toExternalForm());
    }

    public WSDLDocument(Reader reader) throws WSDLException {
        this.wsdlDocumentDef = WSDLDocument.getWSDLReader().readWSDL(null, new InputSource(reader));
    }

    public static WSDLReader getWSDLReader() throws WSDLException {
        return WSDLDocument.getWSDLReader(false);
    }

    public static WSDLReader getWSDLReader(boolean bl) throws WSDLException {
        if (null != wsdlException) {
            throw wsdlException;
        }
        WSDLReader wSDLReader = null;
        wSDLReader = wsdlFactory.newWSDLReader();
        wSDLReader.setFeature("javax.wsdl.verbose", false);
        wSDLReader.setFeature("javax.wsdl.importDocuments", bl);
        return wSDLReader;
    }

    public static WSDLWriter getWSDLWriter() throws WSDLException {
        if (null != wsdlException) {
            throw wsdlException;
        }
        WSDLWriter wSDLWriter = null;
        wSDLWriter = wsdlFactory.newWSDLWriter();
        return wSDLWriter;
    }

    public WSDLDocument(Document document) throws WSDLException {
        this.wsdlDocumentDef = WSDLDocument.getWSDLReader().readWSDL(null, document);
    }

    public WSDLDocument(Definition definition) throws WSDLException {
        this.wsdlDocumentDef = definition;
    }

    public void read(String string) throws WSDLException {
        this.read(string, true);
    }

    public void read(String string, boolean bl) throws WSDLException {
        this.wsdlDocumentDef = WSDLDocument.getWSDLReader(bl).readWSDL(null, string);
    }

    public void write(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            this.write(fileWriter);
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException occurred attempting to write document to file: " + string);
        }
    }

    public void write(Writer writer) {
        try {
            WSDLDocument.getWSDLWriter().writeWSDL(this.wsdlDocumentDef, writer);
        }
        catch (WSDLException wSDLException) {
            System.out.println("Exception occurred writing the document.");
            wSDLException.printStackTrace();
        }
    }

    public String serializeToXML() {
        StringWriter stringWriter = new StringWriter();
        this.write(stringWriter);
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException occurred closing the writer");
        }
        return stringWriter.toString();
    }

    public Definition getDefinitions() {
        return this.wsdlDocumentDef;
    }

    public Message[] getMessages() {
        return this.wsdlDocumentDef.getMessages().values().toArray(new Message[0]);
    }

    public PortType[] getPortTypes() {
        return this.wsdlDocumentDef.getPortTypes().values().toArray(new PortType[0]);
    }

    public Binding[] getBindings() {
        return this.wsdlDocumentDef.getBindings().values().toArray(new Binding[0]);
    }

    public Import[] getImports() {
        Iterator iterator = this.wsdlDocumentDef.getImports().values().iterator();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addAll((List)iterator.next());
        }
        return vector.toArray(new Import[0]);
    }

    public Service[] getServices() {
        return this.wsdlDocumentDef.getServices().values().toArray(new Service[0]);
    }

    public boolean isServiceInterface() {
        return WSDLDocumentIdentifier.isInterfaceDocument(this);
    }

    public boolean isServiceInterfaceWithBindingsOnly() {
        return WSDLDocumentIdentifier.isBindingInterfaceDocument(this);
    }

    public boolean isServiceImplementation() {
        return WSDLDocumentIdentifier.isImplementationDocument(this);
    }

    public boolean isCompleteServiceDefinition() {
        return WSDLDocumentIdentifier.isCompleteDocument(this);
    }

    public WSDLDocument findServiceInterface() throws WSDLException {
        WSDLDocument wSDLDocument = null;
        if (this.isServiceImplementation()) {
            Import[] importArray = this.getImports();
            for (int i = 0; i < importArray.length; ++i) {
                String string = importArray[i].getLocationURI();
                wSDLDocument = new WSDLDocument(string);
                if (wSDLDocument.isServiceInterface()) {
                    return wSDLDocument;
                }
                wSDLDocument = null;
            }
        }
        return wSDLDocument;
    }

    public String toString() {
        return this.wsdlDocumentDef == null ? "WSDL definition element is null." : this.wsdlDocumentDef.toString();
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length == 0) {
            System.out.println("Usage: WSDLDocument <filename>");
        } else {
            try {
                string = stringArray[0];
                System.out.println("Reading WSDL document [" + string + "]...");
                WSDLDocument wSDLDocument = new WSDLDocument(string);
                System.out.println("Document contents: ");
                System.out.println(wSDLDocument.toString());
            }
            catch (Exception exception) {
                System.out.println("EXCEPTION: Could not process WSDL document [" + string + "].");
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }

    static {
        try {
            wsdlFactory = WSDLFactory.newInstance((String)WSDL_FACTORY);
        }
        catch (WSDLException wSDLException) {
            wsdlException = wSDLException;
        }
        WSDL4J_DEFINITION_FACTORY_PROP = "javax.wsdl.factory.DefinitionFactory";
        String string = System.getProperty(WSDL4J_DEFINITION_FACTORY_PROP);
        if (null == string) {
            System.setProperty(WSDL4J_DEFINITION_FACTORY_PROP, "com.ibm.wsdl.factory.IBMWSTKDefinitionFactoryImpl");
        }
    }
}

