/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.common.util.UML2Util;

public class CacheAdapter
extends ECrossReferenceAdapter {
    public static final CacheAdapter INSTANCE = CacheAdapter.createCacheAdapter();
    private final Map values = Collections.synchronizedMap(this.createHashMap());
    protected boolean adapting = false;
    private URIConverter uriConverter = null;
    static /* synthetic */ Class class$0;

    private static CacheAdapter createCacheAdapter() {
        String property = System.getProperty("org.eclipse.uml2.common.util.CacheAdapter.INSTANCE");
        if (!UML2Util.isEmpty(property)) {
            try {
                return (CacheAdapter)((Object)Class.forName(property).newInstance());
            }
            catch (Exception exception) {}
        }
        return new CacheAdapter();
    }

    public static CacheAdapter getCacheAdapter(Notifier notifier) {
        EList eAdapters = notifier.eAdapters();
        int i = 0;
        int size = eAdapters.size();
        while (i < size) {
            Object adapter = eAdapters.get(i);
            if (adapter instanceof CacheAdapter) {
                return (CacheAdapter)((Object)adapter);
            }
            ++i;
        }
        return null;
    }

    public CacheAdapter() {
        this.unloadedResources = new Set(){
            Map map = new WeakHashMap();

            public boolean add(Object o) {
                if (this.map.containsKey(o)) {
                    return false;
                }
                this.map.put(o, null);
                return true;
            }

            public boolean addAll(Collection c) {
                boolean result = false;
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    if (!this.add(i.next())) continue;
                    result = true;
                }
                return result;
            }

            public void clear() {
                this.map.keySet().clear();
            }

            public boolean contains(Object o) {
                return this.map.keySet().contains(o);
            }

            public boolean containsAll(Collection c) {
                return this.map.keySet().containsAll(c);
            }

            public boolean isEmpty() {
                return this.map.keySet().isEmpty();
            }

            public Iterator iterator() {
                return this.map.keySet().iterator();
            }

            public boolean remove(Object o) {
                return this.map.keySet().remove(o);
            }

            public boolean removeAll(Collection c) {
                return this.map.keySet().removeAll(c);
            }

            public boolean retainAll(Collection c) {
                return this.map.keySet().retainAll(c);
            }

            public int size() {
                return this.map.keySet().size();
            }

            public Object[] toArray() {
                return this.map.keySet().toArray();
            }

            public Object[] toArray(Object[] a) {
                return this.map.keySet().toArray(a);
            }
        };
    }

    protected Map createHashMap() {
        return new HashMap();
    }

    protected ECrossReferenceAdapter.InverseCrossReferencer createInverseCrossReferencer() {
        return new InverseCrossReferencer();
    }

    protected boolean addAdapter(EList adapters) {
        return adapters.contains((Object)this) ? false : adapters.add((Object)this);
    }

    public boolean adapt(Notifier notifier) {
        boolean result = false;
        if (notifier != null) {
            this.adapting = true;
            result = this.addAdapter(notifier.eAdapters());
            this.adapting = false;
        }
        return result;
    }

    protected void addAdapter(Notifier notifier) {
        this.addAdapter(notifier.eAdapters());
    }

    protected void addAdapter(EObject eObject) {
        if (eObject != null && !eObject.eIsProxy()) {
            Resource eResource = eObject.eResource();
            if (eResource == null) {
                this.addAdapter(EcoreUtil.getRootContainer((EObject)eObject).eAdapters());
            } else {
                ResourceSet resourceSet = eResource.getResourceSet();
                if (resourceSet == null) {
                    this.addAdapter(eResource.eAdapters());
                } else {
                    this.addAdapter(resourceSet.eAdapters());
                }
            }
        }
    }

    public Collection getNonNavigableInverseReferences(EObject eObject) {
        this.addAdapter(eObject);
        return super.getNonNavigableInverseReferences(eObject);
    }

    public Collection getInverseReferences(EObject eObject) {
        this.addAdapter(eObject);
        return super.getInverseReferences(eObject);
    }

    public void handleCrossReference(EObject eObject) {
        this.inverseCrossReferencer.add(eObject);
    }

    public void setTarget(Notifier target) {
        if (!this.adapting) {
            super.setTarget(target);
        }
    }

    protected void unsetTarget(EObject target) {
        super.unsetTarget(target);
        if (this.uriConverter == null) {
            this.clear(target.eResource());
        }
    }

    protected void unsetTarget(Resource target) {
        super.unsetTarget(target);
        this.clear(target);
    }

    public void notifyChanged(Notification msg) {
        super.notifyChanged(msg);
        Object notifier = msg.getNotifier();
        if (notifier instanceof EObject) {
            if (!msg.isTouch()) {
                this.clear(((EObject)notifier).eResource());
            }
        } else if (notifier instanceof Resource) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.resource.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            switch (msg.getFeatureID((Class)clazz)) {
                case 2: {
                    ResourceSet resourceSet;
                    Resource resource;
                    this.clear();
                    if (this.uriConverter != null || (resource = (Resource)notifier).isLoaded() || (resourceSet = resource.getResourceSet()) == null) break;
                    this.uriConverter = resourceSet.getURIConverter();
                    break;
                }
                case 4: {
                    if (msg.getNewBooleanValue()) break;
                    this.uriConverter = null;
                }
            }
        }
    }

    public void clear() {
        this.values.clear();
    }

    public void clear(Resource resource) {
        this.values.remove(resource);
        if (resource != null) {
            this.values.remove(null);
        }
    }

    public boolean containsKey(EObject eObject, Object key) {
        return this.containsKey(null, eObject, key);
    }

    public boolean containsKey(Resource resource, EObject eObject, Object key) {
        Map eObjectMap;
        Map resourceMap = (Map)this.values.get(resource);
        if (resourceMap != null && (eObjectMap = (Map)resourceMap.get(eObject)) != null) {
            return eObjectMap.containsKey(key);
        }
        return false;
    }

    public Object get(EObject eObject, Object key) {
        return this.get(null, eObject, key);
    }

    public Object get(Resource resource, EObject eObject, Object key) {
        Map eObjectMap;
        Map resourceMap = (Map)this.values.get(resource);
        if (resourceMap != null && (eObjectMap = (Map)resourceMap.get(eObject)) != null) {
            return eObjectMap.get(key);
        }
        return null;
    }

    public Object put(EObject eObject, Object key, Object value) {
        return this.put(null, eObject, key, value);
    }

    public Object put(Resource resource, EObject eObject, Object key, Object value) {
        Map<Object, Object> eObjectMap;
        Map resourceMap;
        if (key == null) {
            throw new IllegalArgumentException(String.valueOf(key));
        }
        if (resource != null) {
            this.addAdapter((Notifier)resource);
        }
        if ((resourceMap = (Map)this.values.get(resource)) == null) {
            resourceMap = Collections.synchronizedMap(this.createHashMap());
            this.values.put(resource, resourceMap);
        }
        if ((eObjectMap = (Map<Object, Object>)resourceMap.get(eObject)) == null) {
            eObjectMap = Collections.synchronizedMap(this.createHashMap());
            resourceMap.put(eObject, eObjectMap);
        }
        return eObjectMap.put(key, value);
    }

    protected boolean resolve() {
        return false;
    }

    protected boolean isIncluded(EReference eReference) {
        return super.isIncluded(eReference) && eReference.isChangeable();
    }

    protected class InverseCrossReferencer
    extends ECrossReferenceAdapter.InverseCrossReferencer {
        protected InverseCrossReferencer() {
            super((ECrossReferenceAdapter)CacheAdapter.this);
        }

        private URI normalizeURI(URI uri, Resource resourceContext) {
            ResourceSet resourceSetContext;
            int index;
            int length;
            String fragment = uri.fragment();
            if (fragment != null && (length = fragment.length()) > 0 && fragment.charAt(0) != '/' && fragment.charAt(length - 1) == '?' && (index = fragment.lastIndexOf(63, length - 2)) > 0) {
                uri = uri.trimFragment().appendFragment(fragment.substring(0, index));
            }
            if (CacheAdapter.this.uriConverter != null) {
                return CacheAdapter.this.uriConverter.normalize(uri);
            }
            if (resourceContext != null && (resourceSetContext = resourceContext.getResourceSet()) != null) {
                return resourceSetContext.getURIConverter().normalize(uri);
            }
            return uri;
        }

        protected URI normalizeURI(URI uri, EObject objectContext) {
            return this.normalizeURI(uri, objectContext.eResource());
        }

        protected void addProxy(EObject proxy, EObject context) {
            if (proxy.eIsProxy()) {
                URI uri;
                List proxies;
                Resource resource;
                if (this.proxyMap == null) {
                    this.proxyMap = CacheAdapter.this.createHashMap();
                }
                if ((resource = context.eResource()) != null) {
                    CacheAdapter.this.addAdapter((Notifier)resource);
                }
                if ((proxies = (List)this.proxyMap.get(uri = this.normalizeURI(((InternalEObject)proxy).eProxyURI(), resource))) == null) {
                    proxies = new BasicEList.FastCompare();
                    this.proxyMap.put(uri, proxies);
                }
                proxies.add(proxy);
            }
        }
    }
}

