/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.MemberElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyElementDelta;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyFieldElementInfo;
import org.rubypeople.rdt.internal.core.RubyMethodElementInfo;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyTypeElementInfo;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public class RubyElementDeltaBuilder {
    IRubyElement rubyElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    RubyElementDelta delta;
    ArrayList added;
    ArrayList removed;

    public RubyElementDeltaBuilder(IRubyElement iRubyElement) {
        this.rubyElement = iRubyElement;
        this.initialize();
        this.recordElementInfo(iRubyElement, (RubyModel)this.rubyElement.getRubyModel(), 0);
    }

    public RubyElementDeltaBuilder(IRubyElement iRubyElement, int n) {
        this.rubyElement = iRubyElement;
        this.maxDepth = n;
        this.initialize();
        this.recordElementInfo(iRubyElement, (RubyModel)this.rubyElement.getRubyModel(), 0);
    }

    private void added(IRubyElement iRubyElement) {
        this.added.add(iRubyElement);
        ListItem listItem = this.getNewPosition(iRubyElement);
        ListItem listItem2 = null;
        ListItem listItem3 = null;
        if (listItem.previous != null) {
            listItem2 = this.getNewPosition(listItem.previous);
        }
        if (listItem.next != null) {
            listItem3 = this.getNewPosition(listItem.next);
        }
        if (listItem2 != null) {
            listItem2.next = listItem.next;
        }
        if (listItem3 != null) {
            listItem3.previous = listItem.previous;
        }
    }

    public void buildDeltas() {
        this.recordNewPositions(this.rubyElement, 0);
        this.findAdditions(this.rubyElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.rubyElement, 0);
        this.trimDelta(this.delta);
        if (this.delta.getAffectedChildren().length == 0) {
            this.delta.contentChanged();
        }
    }

    private void findAdditions(IRubyElement iRubyElement, int n) {
        IRubyElement[] iRubyElementArray;
        RubyElementInfo rubyElementInfo = this.getElementInfo(iRubyElement);
        if (rubyElementInfo == null && n < this.maxDepth) {
            this.delta.added(iRubyElement);
            this.added(iRubyElement);
        } else {
            this.removeElementInfo(iRubyElement);
        }
        if (n >= this.maxDepth) {
            this.delta.changed(iRubyElement, 1);
            return;
        }
        RubyElementInfo rubyElementInfo2 = null;
        try {
            rubyElementInfo2 = (RubyElementInfo)((RubyElement)iRubyElement).getElementInfo();
        }
        catch (RubyModelException rubyModelException) {
            return;
        }
        this.findContentChange(rubyElementInfo, rubyElementInfo2, iRubyElement);
        if (rubyElementInfo != null && iRubyElement instanceof IParent && (iRubyElementArray = rubyElementInfo2.getChildren()) != null) {
            int n2 = iRubyElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                this.findAdditions(iRubyElementArray[n3], n + 1);
                ++n3;
            }
        }
    }

    private void findChangesInPositioning(IRubyElement iRubyElement, int n) {
        if (n >= this.maxDepth || this.added.contains(iRubyElement) || this.removed.contains(iRubyElement)) {
            return;
        }
        if (!this.isPositionedCorrectly(iRubyElement)) {
            this.delta.changed(iRubyElement, 256);
        }
        if (iRubyElement instanceof IParent) {
            RubyElementInfo rubyElementInfo = null;
            try {
                rubyElementInfo = (RubyElementInfo)((RubyElement)iRubyElement).getElementInfo();
            }
            catch (RubyModelException rubyModelException) {
                return;
            }
            IRubyElement[] iRubyElementArray = rubyElementInfo.getChildren();
            if (iRubyElementArray != null) {
                int n2 = iRubyElementArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.findChangesInPositioning(iRubyElementArray[n3], n + 1);
                    ++n3;
                }
            }
        }
    }

    private void findContentChange(RubyElementInfo rubyElementInfo, RubyElementInfo rubyElementInfo2, IRubyElement iRubyElement) {
        MemberElementInfo memberElementInfo;
        MemberElementInfo memberElementInfo2;
        if (rubyElementInfo instanceof MemberElementInfo && rubyElementInfo2 instanceof MemberElementInfo) {
            if (rubyElementInfo instanceof RubyMethodElementInfo && rubyElementInfo2 instanceof RubyMethodElementInfo) {
                memberElementInfo2 = (RubyMethodElementInfo)rubyElementInfo;
                memberElementInfo = (RubyMethodElementInfo)rubyElementInfo2;
                if (((RubyMethodElementInfo)memberElementInfo2).getVisibility() != ((RubyMethodElementInfo)memberElementInfo).getVisibility()) {
                    this.delta.changed(iRubyElement, 2);
                }
                if (!CharOperation.equals(((RubyMethodElementInfo)memberElementInfo2).getArgumentNames(), ((RubyMethodElementInfo)memberElementInfo).getArgumentNames())) {
                    this.delta.changed(iRubyElement, 1);
                }
            } else if (rubyElementInfo instanceof RubyFieldElementInfo && rubyElementInfo2 instanceof RubyFieldElementInfo && !((RubyFieldElementInfo)rubyElementInfo).getTypeName().equals(((RubyFieldElementInfo)rubyElementInfo2).getTypeName())) {
                this.delta.changed(iRubyElement, 1);
            }
        }
        if (rubyElementInfo instanceof RubyTypeElementInfo && rubyElementInfo2 instanceof RubyTypeElementInfo) {
            memberElementInfo2 = (RubyTypeElementInfo)rubyElementInfo;
            memberElementInfo = (RubyTypeElementInfo)rubyElementInfo2;
            if (!((RubyTypeElementInfo)memberElementInfo2).getSuperclassName().equals(((RubyTypeElementInfo)memberElementInfo).getSuperclassName()) || !CharOperation.equals(((RubyTypeElementInfo)memberElementInfo2).getIncludedModuleNames(), ((RubyTypeElementInfo)memberElementInfo).getIncludedModuleNames())) {
                this.delta.changed(iRubyElement, 2048);
            }
        }
    }

    private void findDeletions() {
        Iterator iterator = this.infos.keySet().iterator();
        while (iterator.hasNext()) {
            IRubyElement iRubyElement = (IRubyElement)iterator.next();
            this.delta.removed(iRubyElement);
            this.removed(iRubyElement);
        }
    }

    private RubyElementInfo getElementInfo(IRubyElement iRubyElement) {
        return (RubyElementInfo)this.infos.get(iRubyElement);
    }

    private ListItem getNewPosition(IRubyElement iRubyElement) {
        return (ListItem)this.newPositions.get(iRubyElement);
    }

    private ListItem getOldPosition(IRubyElement iRubyElement) {
        return (ListItem)this.oldPositions.get(iRubyElement);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.rubyElement, new ListItem(null, null));
        this.putNewPosition(this.rubyElement, new ListItem(null, null));
        this.delta = new RubyElementDelta(this.rubyElement);
        if (this.rubyElement.getElementType() >= 2) {
            this.delta.fineGrained();
        }
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(IRubyElement[] iRubyElementArray, boolean bl) {
        int n = iRubyElementArray.length;
        IRubyElement iRubyElement = null;
        IRubyElement iRubyElement2 = null;
        IRubyElement iRubyElement3 = n > 0 ? iRubyElementArray[0] : null;
        int n2 = 0;
        while (n2 < n) {
            iRubyElement = iRubyElement2;
            iRubyElement2 = iRubyElement3;
            IRubyElement iRubyElement4 = iRubyElement3 = n2 + 1 < n ? iRubyElementArray[n2 + 1] : null;
            if (bl) {
                this.putNewPosition(iRubyElement2, new ListItem(iRubyElement, iRubyElement3));
            } else {
                this.putOldPosition(iRubyElement2, new ListItem(iRubyElement, iRubyElement3));
            }
            ++n2;
        }
    }

    private boolean isPositionedCorrectly(IRubyElement iRubyElement) {
        ListItem listItem = this.getOldPosition(iRubyElement);
        if (listItem == null) {
            return false;
        }
        ListItem listItem2 = this.getNewPosition(iRubyElement);
        if (listItem2 == null) {
            return false;
        }
        IRubyElement iRubyElement2 = listItem.previous;
        IRubyElement iRubyElement3 = listItem2.previous;
        if (iRubyElement2 == null) {
            return iRubyElement3 == null;
        }
        return iRubyElement2.equals(iRubyElement3);
    }

    private void putElementInfo(IRubyElement iRubyElement, RubyElementInfo rubyElementInfo) {
        this.infos.put(iRubyElement, rubyElementInfo);
    }

    private void putNewPosition(IRubyElement iRubyElement, ListItem listItem) {
        this.newPositions.put(iRubyElement, listItem);
    }

    private void putOldPosition(IRubyElement iRubyElement, ListItem listItem) {
        this.oldPositions.put(iRubyElement, listItem);
    }

    private void recordElementInfo(IRubyElement iRubyElement, RubyModel rubyModel, int n) {
        IRubyElement[] iRubyElementArray;
        if (n >= this.maxDepth) {
            return;
        }
        RubyElementInfo rubyElementInfo = (RubyElementInfo)RubyModelManager.getRubyModelManager().getInfo(iRubyElement);
        if (rubyElementInfo == null) {
            return;
        }
        this.putElementInfo(iRubyElement, rubyElementInfo);
        if (iRubyElement instanceof IParent && (iRubyElementArray = rubyElementInfo.getChildren()) != null) {
            this.insertPositions(iRubyElementArray, false);
            int n2 = 0;
            int n3 = iRubyElementArray.length;
            while (n2 < n3) {
                this.recordElementInfo(iRubyElementArray[n2], rubyModel, n + 1);
                ++n2;
            }
        }
    }

    private void recordNewPositions(IRubyElement iRubyElement, int n) {
        if (n < this.maxDepth && iRubyElement instanceof IParent) {
            RubyElementInfo rubyElementInfo = null;
            try {
                rubyElementInfo = (RubyElementInfo)((RubyElement)iRubyElement).getElementInfo();
            }
            catch (RubyModelException rubyModelException) {
                return;
            }
            IRubyElement[] iRubyElementArray = rubyElementInfo.getChildren();
            if (iRubyElementArray != null) {
                this.insertPositions(iRubyElementArray, true);
                int n2 = 0;
                int n3 = iRubyElementArray.length;
                while (n2 < n3) {
                    this.recordNewPositions(iRubyElementArray[n2], n + 1);
                    ++n2;
                }
            }
        }
    }

    private void removed(IRubyElement iRubyElement) {
        this.removed.add(iRubyElement);
        ListItem listItem = this.getOldPosition(iRubyElement);
        ListItem listItem2 = null;
        ListItem listItem3 = null;
        if (listItem.previous != null) {
            listItem2 = this.getOldPosition(listItem.previous);
        }
        if (listItem.next != null) {
            listItem3 = this.getOldPosition(listItem.next);
        }
        if (listItem2 != null) {
            listItem2.next = listItem.next;
        }
        if (listItem3 != null) {
            listItem3.previous = listItem.previous;
        }
    }

    private void removeElementInfo(IRubyElement iRubyElement) {
        this.infos.remove(iRubyElement);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Built delta:\n");
        stringBuffer.append(this.delta.toString());
        return stringBuffer.toString();
    }

    private void trimDelta(RubyElementDelta rubyElementDelta) {
        if (rubyElementDelta.getKind() == 2) {
            IRubyElementDelta[] iRubyElementDeltaArray = rubyElementDelta.getAffectedChildren();
            int n = 0;
            int n2 = iRubyElementDeltaArray.length;
            while (n < n2) {
                rubyElementDelta.removeAffectedChild((RubyElementDelta)iRubyElementDeltaArray[n]);
                ++n;
            }
        } else {
            IRubyElementDelta[] iRubyElementDeltaArray = rubyElementDelta.getAffectedChildren();
            int n = 0;
            int n3 = iRubyElementDeltaArray.length;
            while (n < n3) {
                this.trimDelta((RubyElementDelta)iRubyElementDeltaArray[n]);
                ++n;
            }
        }
    }

    class ListItem {
        public IRubyElement previous;
        public IRubyElement next;

        public ListItem(IRubyElement iRubyElement, IRubyElement iRubyElement2) {
            this.previous = iRubyElement;
            this.next = iRubyElement2;
        }
    }
}

