/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.core.parsing;

import java.io.IOException;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.rubypeople.rdt.internal.debug.core.RdtDebugCorePlugin;
import org.rubypeople.rdt.internal.debug.core.parsing.AbstractReadStrategy;
import org.rubypeople.rdt.internal.debug.core.parsing.XmlStreamReader;
import org.rubypeople.rdt.internal.debug.core.parsing.XmlStreamReaderException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MultiReaderStrategy
extends AbstractReadStrategy {
    private Vector streamReaders = new Vector();
    private Hashtable threads = new Hashtable();
    private XmlStreamReader currentReader;

    public MultiReaderStrategy(XmlPullParser xmlPullParser) {
        super(xmlPullParser);
        new Thread("xml reader"){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        MultiReaderStrategy.this.readLoop();
                    }
                    catch (SocketException socketException) {
                        RdtDebugCorePlugin.debug("read loop stopped because socket has been closed.");
                    }
                    catch (Exception exception) {
                        RdtDebugCorePlugin.debug("read loop stopped due to error : ", exception);
                        exception.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    MultiReaderStrategy.this.releaseAllReader();
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                    MultiReaderStrategy.this.releaseAllReader();
                    return;
                }
            }
        }.start();
    }

    protected void readLoop() throws XmlPullParserException, IOException, XmlStreamReaderException {
        RdtDebugCorePlugin.debug("Starting xml read loop.");
        int n = this.xpp.getEventType();
        do {
            if (n == 2) {
                this.dispatchStartTag();
                continue;
            }
            if (n != 3 || this.currentReader == null || !this.currentReader.processEndElement(this.xpp)) continue;
            this.removeReader(this.currentReader);
            this.currentReader = null;
        } while ((n = this.xpp.next()) != 1);
        RdtDebugCorePlugin.debug("Read loop stopped because end of stream was reached.");
    }

    protected void dispatchStartTag() throws XmlPullParserException, IOException, XmlStreamReaderException {
        RdtDebugCorePlugin.debug("Dispatching start tag " + this.xpp.getName());
        if (this.currentReader != null) {
            if (this.currentReader.processStartElement(this.xpp)) {
                return;
            }
            RdtDebugCorePlugin.debug("Current Reader can not process tag " + this.xpp.getName());
            this.currentReader = null;
        }
        int n = 0;
        RdtDebugCorePlugin.debug("Searching reader for start tag " + this.xpp.getName());
        do {
            Iterator iterator = this.streamReaders.iterator();
            while (iterator.hasNext()) {
                XmlStreamReader xmlStreamReader = (XmlStreamReader)iterator.next();
                if (!xmlStreamReader.processStartElement(this.xpp)) continue;
                this.currentReader = xmlStreamReader;
                break;
            }
            if (this.currentReader != null) continue;
            ++n;
            RdtDebugCorePlugin.debug("Missed Start Tag : " + this.xpp.getName());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        } while (this.currentReader == null && n < 10);
    }

    protected void releaseAllReader() {
        Iterator iterator = this.streamReaders.iterator();
        while (iterator.hasNext()) {
            XmlStreamReader xmlStreamReader = (XmlStreamReader)iterator.next();
            ((Thread)this.threads.get(xmlStreamReader)).interrupt();
            iterator.remove();
        }
        this.threads.clear();
    }

    protected synchronized void removeReader(XmlStreamReader xmlStreamReader) {
        ((Thread)this.threads.get(xmlStreamReader)).interrupt();
        this.threads.remove(xmlStreamReader);
        this.streamReaders.remove(xmlStreamReader);
    }

    protected synchronized void addReader(XmlStreamReader xmlStreamReader) {
        this.streamReaders.add(xmlStreamReader);
        this.threads.put(xmlStreamReader, Thread.currentThread());
    }

    public void readElement(XmlStreamReader xmlStreamReader) {
        this.addReader(xmlStreamReader);
        try {
            RdtDebugCorePlugin.debug("Thread is waiting for input: " + Thread.currentThread());
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {
            RdtDebugCorePlugin.debug("Thread has finished processing : " + Thread.currentThread());
        }
    }
}

